/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mxf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.api.NotSupportedException;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.SeekableDemuxerTrack;
import org.jcodec.common.TrackType;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Size;
import org.jcodec.common.model.TapeTimecode;
import org.jcodec.containers.mxf.MXFConst;
import org.jcodec.containers.mxf.model.FileDescriptor;
import org.jcodec.containers.mxf.model.GenericDescriptor;
import org.jcodec.containers.mxf.model.GenericPictureEssenceDescriptor;
import org.jcodec.containers.mxf.model.GenericSoundEssenceDescriptor;
import org.jcodec.containers.mxf.model.IndexSegment;
import org.jcodec.containers.mxf.model.KLV;
import org.jcodec.containers.mxf.model.MXFMetadata;
import org.jcodec.containers.mxf.model.MXFPartition;
import org.jcodec.containers.mxf.model.MXFUtil;
import org.jcodec.containers.mxf.model.TimecodeComponent;
import org.jcodec.containers.mxf.model.TimelineTrack;
import org.jcodec.containers.mxf.model.UL;
import org.jcodec.containers.mxf.model.WaveAudioDescriptor;

public class MXFDemuxer {
    protected List<MXFMetadata> metadata;
    protected MXFPartition header;
    protected List<MXFPartition> partitions;
    protected List<IndexSegment> indexSegments;
    protected SeekableByteChannel ch;
    protected MXFDemuxerTrack[] tracks;
    protected int totalFrames;
    protected double duration;
    protected TimecodeComponent timecode;

    public MXFDemuxer(SeekableByteChannel ch) throws IOException {
        this.ch = ch;
        ch.setPosition(0L);
        this.parseHeader(ch);
        this.findIndex();
        this.tracks = this.findTracks();
        this.timecode = MXFUtil.findMeta(this.metadata, TimecodeComponent.class);
    }

    public OP getOp() {
        UL op = this.header.getPack().getOp();
        OP[] values = OP.values();
        for (int i = 0; i < values.length; ++i) {
            OP op2 = values[i];
            if (op.get(12) != op2.major || op.get(13) != op2.minor) continue;
            return op2;
        }
        return OP.OPAtom;
    }

    private MXFDemuxerTrack[] findTracks() throws IOException {
        ArrayList<MXFDemuxerTrack> rt = new ArrayList<MXFDemuxerTrack>();
        List<TimelineTrack> tracks = MXFUtil.findAllMeta(this.metadata, TimelineTrack.class);
        List<FileDescriptor> descriptors = MXFUtil.findAllMeta(this.metadata, FileDescriptor.class);
        for (TimelineTrack track : tracks) {
            if (track.getTrackNumber() == 0) continue;
            int trackNumber = track.getTrackNumber();
            FileDescriptor descriptor = MXFDemuxer.findDescriptor(descriptors, track.getTrackId());
            if (descriptor == null) {
                Logger.warn("No generic descriptor for track: " + track.getTrackId());
                if (descriptors.size() == 1 && descriptors.get(0).getLinkedTrackId() == 0) {
                    descriptor = descriptors.get(0);
                }
            }
            if (descriptor == null) {
                Logger.warn("Track without descriptor: " + track.getTrackId());
                continue;
            }
            MXFDemuxerTrack dt = this.createTrack(UL.newUL(6, 14, 43, 52, 1, 2, 1, 1, 13, 1, 3, 1, trackNumber >>> 24 & 0xFF, trackNumber >>> 16 & 0xFF, trackNumber >>> 8 & 0xFF, trackNumber & 0xFF), track, descriptor);
            if (dt.getCodec() == null && !(descriptor instanceof WaveAudioDescriptor)) continue;
            rt.add(dt);
        }
        return rt.toArray(new MXFDemuxerTrack[0]);
    }

    public static FileDescriptor findDescriptor(List<FileDescriptor> descriptors, int trackId) {
        for (FileDescriptor descriptor : descriptors) {
            if (descriptor.getLinkedTrackId() != trackId) continue;
            return descriptor;
        }
        return null;
    }

    protected MXFDemuxerTrack createTrack(UL ul, TimelineTrack track, GenericDescriptor descriptor) throws IOException {
        return new MXFDemuxerTrack(this, ul, track, descriptor);
    }

    public List<IndexSegment> getIndexes() {
        return this.indexSegments;
    }

    public List<MXFPartition> getEssencePartitions() {
        return this.partitions;
    }

    public TimecodeComponent getTimecode() {
        return this.timecode;
    }

    public void parseHeader(SeekableByteChannel ff) throws IOException {
        this.header = MXFDemuxer.readHeaderPartition(ff);
        this.metadata = new ArrayList<MXFMetadata>();
        this.partitions = new ArrayList<MXFPartition>();
        long nextPartition = ff.size();
        ff.setPosition(this.header.getPack().getFooterPartition());
        do {
            long thisPartition = ff.position();
            KLV kl = KLV.readKL(ff);
            ByteBuffer fetchFrom = NIOUtils.fetchFromChannel(ff, (int)kl.len);
            this.header = MXFPartition.read(kl.key, fetchFrom, ff.position() - kl.offset, nextPartition);
            if (this.header.getPack().getNbEssenceContainers() > 0) {
                this.partitions.add(0, this.header);
            }
            this.metadata.addAll(0, MXFDemuxer.readPartitionMeta(ff, this.header));
            ff.setPosition(this.header.getPack().getPrevPartition());
            nextPartition = thisPartition;
        } while (this.header.getPack().getThisPartition() != 0L);
    }

    public static List<MXFMetadata> readPartitionMeta(SeekableByteChannel ff, MXFPartition header) throws IOException {
        KLV kl;
        long basePos = ff.position();
        ArrayList<MXFMetadata> local = new ArrayList<MXFMetadata>();
        ByteBuffer metaBuffer = NIOUtils.fetchFromChannel(ff, (int)Math.max(0L, header.getEssenceFilePos() - basePos));
        while (metaBuffer.hasRemaining() && (kl = KLV.readKLFromBuffer(metaBuffer, basePos)) != null) {
            MXFMetadata meta = MXFDemuxer.parseMeta(kl.key, NIOUtils.read(metaBuffer, (int)kl.len));
            if (meta == null) continue;
            local.add(meta);
        }
        return local;
    }

    public static MXFPartition readHeaderPartition(SeekableByteChannel ff) throws IOException {
        KLV kl;
        MXFPartition header = null;
        while ((kl = KLV.readKL(ff)) != null) {
            if (MXFConst.HEADER_PARTITION_KLV.equals(kl.key)) {
                ByteBuffer data = NIOUtils.fetchFromChannel(ff, (int)kl.len);
                header = MXFPartition.read(kl.key, data, ff.position() - kl.offset, 0L);
                break;
            }
            ff.setPosition(ff.position() + kl.len);
        }
        return header;
    }

    private static MXFMetadata parseMeta(UL ul, ByteBuffer _bb) {
        Class<? extends MXFMetadata> class1 = MXFConst.klMetadataMapping.get(ul);
        if (class1 == null) {
            Logger.warn("Unknown metadata piece: " + ul);
            return null;
        }
        try {
            MXFMetadata meta = class1.getConstructor(UL.class).newInstance(ul);
            meta.readBuf(_bb);
            return meta;
        }
        catch (Exception exception) {
            Logger.warn("Unknown metadata piece: " + ul);
            return null;
        }
    }

    private void findIndex() {
        this.indexSegments = new ArrayList<IndexSegment>();
        for (MXFMetadata meta : this.metadata) {
            if (!(meta instanceof IndexSegment)) continue;
            IndexSegment is = (IndexSegment)meta;
            this.indexSegments.add(is);
            this.totalFrames = (int)((long)this.totalFrames + is.getIndexDuration());
            this.duration += (double)is.getIndexEditRateDen() * (double)is.getIndexDuration() / (double)is.getIndexEditRateNum();
        }
    }

    public MXFDemuxerTrack[] getTracks() {
        return this.tracks;
    }

    public MXFDemuxerTrack getVideoTrack() {
        for (MXFDemuxerTrack track : this.tracks) {
            if (!track.isVideo()) continue;
            return track;
        }
        return null;
    }

    public MXFDemuxerTrack[] getAudioTracks() {
        ArrayList<MXFDemuxerTrack> audio = new ArrayList<MXFDemuxerTrack>();
        for (MXFDemuxerTrack track : this.tracks) {
            if (!track.isAudio()) continue;
            audio.add(track);
        }
        return audio.toArray(new MXFDemuxerTrack[0]);
    }

    public static class Fast
    extends MXFDemuxer {
        public Fast(SeekableByteChannel ch) throws IOException {
            super(ch);
        }

        @Override
        public void parseHeader(SeekableByteChannel ff) throws IOException {
            this.partitions = new ArrayList();
            this.metadata = new ArrayList();
            this.header = Fast.readHeaderPartition(ff);
            this.metadata.addAll(Fast.readPartitionMeta(ff, this.header));
            this.partitions.add(this.header);
            ff.setPosition(this.header.getPack().getFooterPartition());
            KLV kl = KLV.readKL(ff);
            ByteBuffer fetchFrom = NIOUtils.fetchFromChannel(ff, (int)kl.len);
            MXFPartition footer = MXFPartition.read(kl.key, fetchFrom, ff.position() - kl.offset, ff.size());
            this.metadata.addAll(Fast.readPartitionMeta(ff, footer));
        }
    }

    public static class MXFPacket
    extends Packet {
        private long offset;
        private int len;

        public MXFPacket(ByteBuffer data, long pts, int timescale, long duration, long frameNo, Packet.FrameType frameType, TapeTimecode tapeTimecode, long offset, int len) {
            super(data, pts, timescale, duration, frameNo, frameType, tapeTimecode, 0);
            this.offset = offset;
            this.len = len;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getLen() {
            return this.len;
        }
    }

    public static class MXFDemuxerTrack
    implements SeekableDemuxerTrack {
        private UL essenceUL;
        private int dataLen;
        private int indexSegmentIdx;
        private int indexSegmentSubIdx;
        private int frameNo;
        private long pts;
        private int partIdx;
        private long partEssenceOffset;
        private GenericDescriptor descriptor;
        private TimelineTrack track;
        private boolean video;
        private boolean audio;
        private MXFConst.MXFCodecMapping codec;
        private int audioFrameDuration;
        private int audioTimescale;
        private MXFDemuxer demuxer;

        public MXFDemuxerTrack(MXFDemuxer demuxer, UL essenceUL, TimelineTrack track, GenericDescriptor descriptor) throws IOException {
            this.demuxer = demuxer;
            this.essenceUL = essenceUL;
            this.track = track;
            this.descriptor = descriptor;
            if (descriptor instanceof GenericPictureEssenceDescriptor) {
                this.video = true;
            } else if (descriptor instanceof GenericSoundEssenceDescriptor) {
                this.audio = true;
            }
            this.codec = this.resolveCodec();
            if (this.codec != null || descriptor instanceof WaveAudioDescriptor) {
                Logger.warn("Track type: " + this.video + ", " + this.audio);
                if (this.audio && descriptor instanceof WaveAudioDescriptor) {
                    WaveAudioDescriptor wave = (WaveAudioDescriptor)descriptor;
                    this.cacheAudioFrameSizes(demuxer.ch);
                    this.audioFrameDuration = this.dataLen / ((wave.getQuantizationBits() >> 3) * wave.getChannelCount());
                    this.audioTimescale = (int)wave.getAudioSamplingRate().scalar();
                }
            }
        }

        public boolean isAudio() {
            return this.audio;
        }

        public boolean isVideo() {
            return this.video;
        }

        public double getDuration() {
            return this.demuxer.duration;
        }

        public int getNumFrames() {
            return this.demuxer.totalFrames;
        }

        public String getName() {
            return this.track.getName();
        }

        private void cacheAudioFrameSizes(SeekableByteChannel ch) throws IOException {
            for (MXFPartition mxfPartition : this.demuxer.partitions) {
                KLV kl;
                if (mxfPartition.getEssenceLength() <= 0L) continue;
                ch.setPosition(mxfPartition.getEssenceFilePos());
                while ((kl = KLV.readKL(ch)) != null) {
                    ch.setPosition(ch.position() + kl.len);
                    if (!this.essenceUL.equals(kl.key)) continue;
                }
                if (kl == null || !this.essenceUL.equals(kl.key)) continue;
                this.dataLen = (int)kl.len;
                break;
            }
        }

        @Override
        public Packet nextFrame() throws IOException {
            MXFPacket result;
            boolean kf;
            if (this.indexSegmentIdx >= this.demuxer.indexSegments.size()) {
                return null;
            }
            IndexSegment seg = this.demuxer.indexSegments.get(this.indexSegmentIdx);
            long[] off = seg.getIe().getFileOff();
            int erDen = seg.getIndexEditRateNum();
            int erNum = seg.getIndexEditRateDen();
            long frameEssenceOffset = off[this.indexSegmentSubIdx];
            byte toff = seg.getIe().getDisplayOff()[this.indexSegmentSubIdx];
            boolean bl = kf = seg.getIe().getKeyFrameOff()[this.indexSegmentSubIdx] == 0;
            while (frameEssenceOffset >= this.partEssenceOffset + this.demuxer.partitions.get(this.partIdx).getEssenceLength() && this.partIdx < this.demuxer.partitions.size() - 1) {
                this.partEssenceOffset += this.demuxer.partitions.get(this.partIdx).getEssenceLength();
                ++this.partIdx;
            }
            long frameFileOffset = frameEssenceOffset - this.partEssenceOffset + this.demuxer.partitions.get(this.partIdx).getEssenceFilePos();
            if (!this.audio) {
                result = this.readPacket(frameFileOffset, this.dataLen, this.pts + (long)(erNum * toff), erDen, erNum, this.frameNo++, kf);
                this.pts += (long)erNum;
            } else {
                result = this.readPacket(frameFileOffset, this.dataLen, this.pts, this.audioTimescale, this.audioFrameDuration, this.frameNo++, kf);
                this.pts += (long)this.audioFrameDuration;
            }
            ++this.indexSegmentSubIdx;
            if (this.indexSegmentSubIdx >= off.length) {
                ++this.indexSegmentIdx;
                this.indexSegmentSubIdx = 0;
                if (this.dataLen == 0 && this.indexSegmentIdx < this.demuxer.indexSegments.size()) {
                    IndexSegment nseg = this.demuxer.indexSegments.get(this.indexSegmentIdx);
                    this.pts = this.pts * (long)nseg.getIndexEditRateNum() / (long)erDen;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MXFPacket readPacket(long off, int len, long pts, int timescale, int duration, int frameNo, boolean kf) throws IOException {
            SeekableByteChannel ch;
            SeekableByteChannel seekableByteChannel = ch = this.demuxer.ch;
            synchronized (seekableByteChannel) {
                ch.setPosition(off);
                KLV kl = KLV.readKL(ch);
                while (kl != null && !this.essenceUL.equals(kl.key)) {
                    ch.setPosition(ch.position() + kl.len);
                    kl = KLV.readKL(ch);
                }
                return kl != null && this.essenceUL.equals(kl.key) ? new MXFPacket(NIOUtils.fetchFromChannel(ch, (int)kl.len), pts, timescale, duration, frameNo, kf ? Packet.FrameType.KEY : Packet.FrameType.INTER, null, off, len) : null;
            }
        }

        @Override
        public boolean gotoFrame(long frameNo) {
            if (frameNo == (long)this.frameNo) {
                return true;
            }
            this.indexSegmentSubIdx = (int)frameNo;
            this.indexSegmentIdx = 0;
            while (this.indexSegmentIdx < this.demuxer.indexSegments.size() && (long)this.indexSegmentSubIdx >= this.demuxer.indexSegments.get(this.indexSegmentIdx).getIndexDuration()) {
                this.indexSegmentSubIdx = (int)((long)this.indexSegmentSubIdx - this.demuxer.indexSegments.get(this.indexSegmentIdx).getIndexDuration());
                ++this.indexSegmentIdx;
            }
            this.indexSegmentSubIdx = Math.min(this.indexSegmentSubIdx, (int)this.demuxer.indexSegments.get(this.indexSegmentIdx).getIndexDuration());
            return true;
        }

        @Override
        public boolean gotoSyncFrame(long frameNo) {
            if (!this.gotoFrame(frameNo)) {
                return false;
            }
            IndexSegment seg = this.demuxer.indexSegments.get(this.indexSegmentIdx);
            byte kfOff = seg.getIe().getKeyFrameOff()[this.indexSegmentSubIdx];
            return this.gotoFrame(frameNo + (long)kfOff);
        }

        @Override
        public long getCurFrame() {
            return this.frameNo;
        }

        @Override
        public void seek(double second) {
            throw new NotSupportedException(new String[0]);
        }

        public UL getEssenceUL() {
            return this.essenceUL;
        }

        public GenericDescriptor getDescriptor() {
            return this.descriptor;
        }

        public MXFConst.MXFCodecMapping getCodec() {
            return this.codec;
        }

        private MXFConst.MXFCodecMapping resolveCodec() {
            UL codecUL;
            if (this.video) {
                codecUL = ((GenericPictureEssenceDescriptor)this.descriptor).getPictureEssenceCoding();
            } else if (this.audio) {
                codecUL = ((GenericSoundEssenceDescriptor)this.descriptor).getSoundEssenceCompression();
            } else {
                return null;
            }
            MXFConst.MXFCodecMapping[] values = MXFConst.MXFCodecMapping.values();
            for (int i = 0; i < values.length; ++i) {
                MXFConst.MXFCodecMapping codec = values[i];
                if (!codec.getUl().maskEquals(codecUL, 65407)) continue;
                return codec;
            }
            Logger.warn("Unknown codec: " + codecUL);
            return null;
        }

        public int getTrackId() {
            return this.track.getTrackId();
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            Size size = null;
            if (this.video) {
                GenericPictureEssenceDescriptor pd = (GenericPictureEssenceDescriptor)this.descriptor;
                size = new Size(pd.getStoredWidth(), pd.getStoredHeight());
            }
            TrackType t = this.video ? TrackType.VIDEO : (this.audio ? TrackType.AUDIO : TrackType.OTHER);
            return new DemuxerTrackMeta(t, this.getCodec().getCodec(), this.demuxer.duration, null, this.demuxer.totalFrames, null, new VideoCodecMeta(size, ColorSpace.YUV420), null);
        }
    }

    public static final class OP {
        public static final OP OP1a = new OP(1, 1);
        public static final OP OP1b = new OP(1, 2);
        public static final OP OP1c = new OP(1, 3);
        public static final OP OP2a = new OP(2, 1);
        public static final OP OP2b = new OP(2, 2);
        public static final OP OP2c = new OP(2, 3);
        public static final OP OP3a = new OP(3, 1);
        public static final OP OP3b = new OP(3, 2);
        public static final OP OP3c = new OP(3, 3);
        public static final OP OPAtom = new OP(16, 0);
        private static final OP[] _values = new OP[]{OP1a, OP1b, OP1c, OP2a, OP2b, OP2c, OP3a, OP3b, OP3c, OPAtom};
        public int major;
        public int minor;

        private OP(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public static OP[] values() {
            return _values;
        }
    }
}

