/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mxf.model;

import java.nio.ByteBuffer;

public class UL {
    private byte[] bytes;

    public UL(byte[] bytes) {
        this.bytes = bytes;
    }

    public static UL newUL(int ... arguments) {
        byte[] bytes = new byte[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            bytes[i] = (byte)arguments[i];
        }
        return new UL(bytes);
    }

    public int hashCode() {
        return (this.bytes[4] & 0xFF) << 24 | (this.bytes[5] & 0xFF) << 16 | (this.bytes[6] & 0xFF) << 8 | this.bytes[7] & 0xFF;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UL)) {
            return false;
        }
        byte[] other = ((UL)obj).bytes;
        for (int i = 4; i < Math.min(this.bytes.length, other.length); ++i) {
            if (this.bytes[i] == other[i]) continue;
            return false;
        }
        return true;
    }

    public boolean maskEquals(UL o, int mask) {
        if (o == null) {
            return false;
        }
        byte[] other = o.bytes;
        mask >>= 4;
        int i = 4;
        while (i < Math.min(this.bytes.length, other.length)) {
            if ((mask & 1) == 1 && this.bytes[i] != other[i]) {
                return false;
            }
            ++i;
            mask >>= 1;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("06:0E:2B:34:");
        for (int i = 4; i < this.bytes.length; ++i) {
            sb.append(this.hex(this.bytes[i] >> 4 & 0xF));
            sb.append(this.hex(this.bytes[i] & 0xF));
            if (i >= this.bytes.length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    private char hex(int i) {
        return (char)(i < 10 ? 48 + i : 65 + (i - 10));
    }

    public int get(int i) {
        return this.bytes[i];
    }

    public static UL read(ByteBuffer _bb) {
        byte[] umid = new byte[16];
        _bb.get(umid);
        return new UL(umid);
    }
}

