/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mxf.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Label;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Rational;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mxf.MXFConst;
import org.jcodec.containers.mxf.MXFDemuxer;
import org.jcodec.containers.mxf.model.GenericDescriptor;
import org.jcodec.containers.mxf.model.GenericPictureEssenceDescriptor;
import org.jcodec.containers.mxf.model.GenericSoundEssenceDescriptor;
import org.jcodec.containers.mxf.model.KLV;
import org.jcodec.containers.mxf.model.TimelineTrack;
import org.jcodec.containers.mxf.model.UL;
import org.jcodec.movtool.streaming.AudioCodecMeta;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VideoCodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.ByteChannelPool;

public class MXFVirtualTrack
implements VirtualTrack {
    private MXFDemuxer.MXFDemuxerTrack track;
    private ByteChannelPool fp;
    private UL essenceUL;

    public MXFVirtualTrack(MXFDemuxer.MXFDemuxerTrack track, ByteChannelPool fp) throws IOException {
        this.fp = fp;
        this.track = track;
        this.essenceUL = track.getEssenceUL();
    }

    public static MXFDemuxer createDemuxer(SeekableByteChannel channel) throws IOException {
        return new PatchedMXFDemuxer(channel);
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        MXFDemuxer.MXFPacket nextFrame = (MXFDemuxer.MXFPacket)this.track.nextFrame();
        if (nextFrame == null) {
            return null;
        }
        return new MXFVirtualPacket(this, nextFrame);
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.toSampleEntry(this.track.getDescriptor());
    }

    private CodecMeta toSampleEntry(GenericDescriptor d) {
        if (this.track.isVideo()) {
            GenericPictureEssenceDescriptor ped = (GenericPictureEssenceDescriptor)d;
            Rational ar = ped.getAspectRatio();
            VideoCodecMeta se = VideoCodecMeta.createVideoCodecMeta(MP4Util.getFourcc(this.track.getCodec().getCodec()), null, new Size(ped.getDisplayWidth(), ped.getDisplayHeight()), new Rational(1000 * ar.getNum() * ped.getDisplayHeight() / (ar.getDen() * ped.getDisplayWidth()), 1000));
            return se;
        }
        if (this.track.isAudio()) {
            GenericSoundEssenceDescriptor sed = (GenericSoundEssenceDescriptor)d;
            int sampleSize = sed.getQuantizationBits() >> 3;
            MXFConst.MXFCodecMapping codec = this.track.getCodec();
            Object[] labels = new Label[sed.getChannelCount()];
            Arrays.fill(labels, Label.Mono);
            return AudioCodecMeta.createAudioCodecMeta(sampleSize == 3 ? "in24" : "sowt", sampleSize, sed.getChannelCount(), (int)sed.getAudioSamplingRate().scalar(), codec == MXFConst.MXFCodecMapping.PCM_S16BE ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN, true, (Label[])labels, null);
        }
        throw new RuntimeException("Can't get sample entry");
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return null;
    }

    @Override
    public int getPreferredTimescale() {
        return -1;
    }

    @Override
    public void close() {
        this.fp.close();
    }

    public int getTrackId() {
        return this.track.getTrackId();
    }

    public static class PatchedMXFDemuxer
    extends MXFDemuxer {
        public PatchedMXFDemuxer(SeekableByteChannel ch) throws IOException {
            super(ch);
        }

        @Override
        protected MXFDemuxer.MXFDemuxerTrack createTrack(UL ul, TimelineTrack track, GenericDescriptor descriptor) throws IOException {
            return new MXFDemuxer.MXFDemuxerTrack(this, ul, track, descriptor){

                @Override
                public MXFDemuxer.MXFPacket readPacket(long off, int len, long pts, int timescale, int duration, int frameNo, boolean kf) throws IOException {
                    return new MXFDemuxer.MXFPacket(null, pts, timescale, duration, frameNo, kf ? Packet.FrameType.KEY : Packet.FrameType.INTER, null, off, len);
                }
            };
        }
    }

    public static class MXFVirtualPacket
    implements VirtualPacket {
        private MXFDemuxer.MXFPacket pkt;
        private MXFVirtualTrack track;

        public MXFVirtualPacket(MXFVirtualTrack track, MXFDemuxer.MXFPacket pkt) {
            this.track = track;
            this.pkt = pkt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer byteBuffer;
            SeekableByteChannel ch = null;
            try {
                ch = this.track.fp.getChannel();
                ch.setPosition(this.pkt.getOffset());
                KLV kl = KLV.readKL(ch);
                while (kl != null && !this.track.essenceUL.equals(kl.key)) {
                    ch.setPosition(ch.position() + kl.len);
                    kl = KLV.readKL(ch);
                }
                byteBuffer = kl != null && this.track.essenceUL.equals(kl.key) ? NIOUtils.fetchFromChannel(ch, (int)kl.len) : null;
            }
            catch (Throwable throwable) {
                NIOUtils.closeQuietly(ch);
                throw throwable;
            }
            NIOUtils.closeQuietly(ch);
            return byteBuffer;
        }

        @Override
        public int getDataLen() throws IOException {
            return this.pkt.getLen();
        }

        @Override
        public double getPts() {
            return this.pkt.getPtsD();
        }

        @Override
        public double getDuration() {
            return this.pkt.getDurationD();
        }

        @Override
        public boolean isKeyframe() {
            return this.pkt.isKeyFrame();
        }

        @Override
        public int getFrameNo() {
            return (int)this.pkt.getFrameNo();
        }
    }
}

