/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.movtool.streaming.MovieRange;
import org.jcodec.movtool.streaming.MovieSegment;
import org.jcodec.movtool.streaming.VirtualMovie;
import org.jcodec.platform.BaseInputStream;

public class ConcurrentMovieRangeService {
    private ExecutorService exec;
    private VirtualMovie movie;

    public ConcurrentMovieRangeService(VirtualMovie movie, int nThreads) {
        this.exec = Executors.newFixedThreadPool(nThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.movie = movie;
    }

    public void shutdown() {
        this.exec.shutdown();
    }

    public InputStream getRange(long from, long to) throws IOException {
        return new ConcurrentMovieRange(this, from, to);
    }

    public static class ConcurrentMovieRange
    extends BaseInputStream {
        private static final int READ_AHEAD_SEGMENTS = 10;
        private List<Future<ByteBuffer>> segments = new ArrayList<Future<ByteBuffer>>();
        private int nextReadAheadNo;
        private long remaining;
        private long to;
        private ConcurrentMovieRangeService svc;

        public ConcurrentMovieRange(ConcurrentMovieRangeService svc, long from, long to) throws IOException {
            this.svc = svc;
            if (to < from) {
                throw new IllegalArgumentException("from < to");
            }
            this.remaining = to - from + 1L;
            this.to = to;
            MovieSegment segment = svc.movie.getPacketAt(from);
            if (segment != null) {
                this.nextReadAheadNo = segment.getNo();
                this.scheduleSegmentRetrieve(segment);
                for (int i = 0; i < 10; ++i) {
                    this.tryReadAhead();
                }
                ByteBuffer data = this.segmentData();
                NIOUtils.skip(data, (int)(from - segment.getPos()));
            }
        }

        @Override
        protected int readBuffer(byte[] b, int from, int len) throws IOException {
            if (this.segments.size() == 0 || this.remaining == 0L) {
                return -1;
            }
            len = (int)Math.min((long)len, this.remaining);
            int totalRead = 0;
            while (len > 0 && this.segments.size() > 0) {
                ByteBuffer segmentData = this.segmentData();
                int toRead = Math.min(segmentData.remaining(), len);
                segmentData.get(b, from, toRead);
                totalRead += toRead;
                len -= toRead;
                from += toRead;
                this.disposeReadAhead(segmentData);
            }
            this.remaining -= (long)totalRead;
            return totalRead;
        }

        private void disposeReadAhead(ByteBuffer segmentData) {
            if (!segmentData.hasRemaining()) {
                this.segments.remove(0);
                this.tryReadAhead();
            }
        }

        private void tryReadAhead() {
            MovieSegment segment = this.svc.movie.getPacketByNo(this.nextReadAheadNo);
            if (segment != null && segment.getPos() < this.to) {
                this.scheduleSegmentRetrieve(segment);
            }
        }

        private void scheduleSegmentRetrieve(MovieSegment segment) {
            Future<ByteBuffer> submit = this.svc.exec.submit(new GetCallable(segment));
            this.segments.add(submit);
            ++this.nextReadAheadNo;
        }

        private ByteBuffer segmentData() throws IOException {
            ByteBuffer segmentData;
            try {
                segmentData = this.segments.get(0).get();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return segmentData;
        }

        @Override
        public void close() throws IOException {
            for (Future<ByteBuffer> future : this.segments) {
                future.cancel(false);
            }
        }

        @Override
        protected int readByte() throws IOException {
            if (this.segments.size() == 0 || this.remaining == 0L) {
                return -1;
            }
            ByteBuffer segmentData = this.segmentData();
            int ret = segmentData.get() & 0xFF;
            this.disposeReadAhead(segmentData);
            --this.remaining;
            return ret;
        }
    }

    static class GetCallable
    implements Callable<ByteBuffer> {
        private MovieSegment segment;

        public GetCallable(MovieSegment segment) {
            this.segment = segment;
        }

        @Override
        public ByteBuffer call() throws Exception {
            return MovieRange.checkDataLen(this.segment.getData() == null ? null : this.segment.getData().duplicate(), this.segment.getDataLen());
        }
    }
}

