/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.jcodec.common.io.IOUtils;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.movtool.streaming.ConcurrentMovieRangeService;
import org.jcodec.movtool.streaming.MovieRange;
import org.jcodec.movtool.streaming.VirtualMP4Movie;
import org.jcodec.movtool.streaming.VirtualMovie;
import org.jcodec.movtool.streaming.tracks.FilePool;
import org.jcodec.movtool.streaming.tracks.RealTrack;

public class ConcurrentMovieRangeServiceMain {
    public static void main1(String[] args) throws IOException {
        int i;
        if (args.length < 1) {
            System.out.println("Syntax: <movie.mov>");
            return;
        }
        File file = new File(args[0]);
        FilePool fp = new FilePool(file, 10);
        MovieBox movie = MP4Util.parseMovie(file);
        RealTrack vt = new RealTrack(movie, movie.getVideoTrack(), fp);
        VirtualMP4Movie vm = new VirtualMP4Movie(vt);
        MovieRange is = new MovieRange(vm, 0L, vm.size());
        File ref = File.createTempFile("cool", "super");
        ref.deleteOnExit();
        FileOutputStream tmpOs = new FileOutputStream(ref);
        IOUtils.copy(is, tmpOs);
        is.close();
        tmpOs.close();
        ConcurrentMovieRangeService cmrs = new ConcurrentMovieRangeService(vm, 2);
        ExecutorService tp = Executors.newFixedThreadPool(20, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        });
        Future[] ff = new Future[1000];
        for (i = 0; i < 1000; ++i) {
            ff[i] = tp.submit(new OneTest(vm, ref, cmrs));
        }
        for (i = 0; i < 1000; ++i) {
            try {
                ff[i].get();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class OneTest
    implements Runnable {
        private VirtualMovie vm;
        private File ref;
        private ConcurrentMovieRangeService cmrs;

        public OneTest(VirtualMovie vm, File ref, ConcurrentMovieRangeService cmrs) {
            this.vm = vm;
            this.ref = ref;
            this.cmrs = cmrs;
        }

        @Override
        public void run() {
            try {
                int b;
                long size = this.vm.size();
                long from = (long)(Math.random() * (double)size);
                long to = from + (long)(Math.random() * (double)(size - from));
                System.out.println("RANGE: " + from + " - " + to);
                InputStream is1 = this.cmrs.getRange(from, to);
                FileChannel _in = new FileInputStream(this.ref).getChannel();
                _in.position(from);
                InputStream is2 = Channels.newInputStream(_in);
                byte[] buf1 = new byte[4096];
                byte[] buf2 = new byte[4096];
                int ii = 0;
                do {
                    b = is1.read(buf1);
                    int b2 = is2.read(buf2);
                    if (b == -1) continue;
                    for (int k = 0; k < b; ++k) {
                        if (buf1[k] == buf2[k]) continue;
                        throw new RuntimeException("[" + (ii + k) + "]" + buf1[k] + ":" + buf2[k]);
                    }
                    ii += b;
                } while (b != -1);
                if ((long)ii != to - from + 1L) {
                    throw new RuntimeException("Read less [" + ii + " < " + (to - from + 1L));
                }
                is1.close();
                is2.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

