/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jcodec.api.UnhandledStateException;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.common.IntArrayList;
import org.jcodec.common.LongArrayList;
import org.jcodec.common.model.Rational;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.containers.mp4.MP4TrackType;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.ChannelBox;
import org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import org.jcodec.containers.mp4.boxes.ClearApertureBox;
import org.jcodec.containers.mp4.boxes.CompositionOffsetsBox;
import org.jcodec.containers.mp4.boxes.DataInfoBox;
import org.jcodec.containers.mp4.boxes.DataRefBox;
import org.jcodec.containers.mp4.boxes.Edit;
import org.jcodec.containers.mp4.boxes.EncodedPixelBox;
import org.jcodec.containers.mp4.boxes.GenericMediaInfoBox;
import org.jcodec.containers.mp4.boxes.HandlerBox;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.MediaBox;
import org.jcodec.containers.mp4.boxes.MediaHeaderBox;
import org.jcodec.containers.mp4.boxes.MediaInfoBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.MovieHeaderBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.PixelAspectExt;
import org.jcodec.containers.mp4.boxes.ProductionApertureBox;
import org.jcodec.containers.mp4.boxes.SampleDescriptionBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.SampleToChunkBox;
import org.jcodec.containers.mp4.boxes.SoundMediaHeaderBox;
import org.jcodec.containers.mp4.boxes.SyncSamplesBox;
import org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import org.jcodec.containers.mp4.boxes.TimecodeMediaInfoBox;
import org.jcodec.containers.mp4.boxes.TrackHeaderBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.boxes.VideoMediaHeaderBox;
import org.jcodec.containers.mp4.muxer.FramesMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.MP4Muxer;
import org.jcodec.movtool.streaming.AudioCodecMeta;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VideoCodecMeta;
import org.jcodec.movtool.streaming.VirtualMP4Movie;
import org.jcodec.movtool.streaming.VirtualTrack;

public class MovieHelper {
    private static final int MEBABYTE = 0x100000;
    private static int[] timescales = new int[]{10000, 12000, 15000, 24000, 25000, 30000, 50000, 41000, 48000, 96000};

    public static ByteBuffer produceHeader(VirtualMP4Movie.PacketChunk[] chunks, VirtualTrack[] tracks, long dataSize, Brand brand) throws IOException {
        int defaultTimescale = 1000;
        ByteBuffer buf = ByteBuffer.allocate(0x600000);
        MovieBox movie = MovieBox.createMovieBox();
        double[] trackDurations = MovieHelper.calcTrackDurations(chunks, tracks);
        long movieDur = MovieHelper.calcMovieDuration(tracks, defaultTimescale, trackDurations);
        movie.add(MovieHelper.movieHeader(movie, tracks.length, movieDur, defaultTimescale));
        for (int trackId = 0; trackId < tracks.length; ++trackId) {
            MP4TrackType tt;
            VirtualTrack track = tracks[trackId];
            CodecMeta codecMeta = track.getCodecMeta();
            boolean pcm = codecMeta instanceof AudioCodecMeta && ((AudioCodecMeta)codecMeta).isPCM();
            int trackTimescale = track.getPreferredTimescale();
            if (trackTimescale <= 0) {
                trackTimescale = pcm ? MovieHelper.getPCMTs((AudioCodecMeta)codecMeta, chunks, trackId) : MovieHelper.chooseTimescale(chunks, trackId);
            } else if (trackTimescale < 100) {
                trackTimescale *= 1000;
            } else if (trackTimescale < 1000) {
                trackTimescale *= 100;
            } else if (trackTimescale < 10000) {
                trackTimescale *= 10;
            }
            long totalDur = (long)((double)trackTimescale * trackDurations[trackId]);
            TrakBox trak = TrakBox.createTrakBox();
            Size dd = new Size(0, 0);
            Size sd = new Size(0, 0);
            if (codecMeta instanceof VideoCodecMeta) {
                VideoCodecMeta meta = (VideoCodecMeta)codecMeta;
                Rational pasp = meta.getPasp();
                if (pasp == null) {
                    sd = dd = meta.getSize();
                } else {
                    sd = meta.getSize();
                    dd = new Size(pasp.multiplyS(sd.getWidth()), sd.getHeight());
                }
            }
            TrackHeaderBox tkhd = TrackHeaderBox.createTrackHeaderBox(trackId + 1, movieDur, dd.getWidth(), dd.getHeight(), new Date().getTime(), new Date().getTime(), 1.0f, (short)0, 0L, new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000});
            tkhd.setFlags(15);
            trak.add(tkhd);
            MediaBox media = MediaBox.createMediaBox();
            trak.add(media);
            media.add(MediaHeaderBox.createMediaHeaderBox(trackTimescale, totalDur, 0, new Date().getTime(), new Date().getTime(), 0));
            MP4TrackType mP4TrackType = tt = codecMeta instanceof AudioCodecMeta ? MP4TrackType.SOUND : MP4TrackType.VIDEO;
            if (tt == MP4TrackType.VIDEO) {
                NodeBox tapt = new NodeBox(new Header("tapt"));
                tapt.add(ClearApertureBox.createClearApertureBox(dd.getWidth(), dd.getHeight()));
                tapt.add(ProductionApertureBox.createProductionApertureBox(dd.getWidth(), dd.getHeight()));
                tapt.add(EncodedPixelBox.createEncodedPixelBox(sd.getWidth(), sd.getHeight()));
                trak.add(tapt);
            }
            HandlerBox hdlr = HandlerBox.createHandlerBox("mhlr", tt.getHandler(), "appl", 0, 0);
            media.add(hdlr);
            MediaInfoBox minf = MediaInfoBox.createMediaInfoBox();
            media.add(minf);
            MovieHelper.mediaHeader(minf, tt);
            minf.add(HandlerBox.createHandlerBox("dhlr", "url ", "appl", 0, 0));
            MovieHelper.addDref(minf);
            NodeBox stbl = new NodeBox(new Header("stbl"));
            minf.add(stbl);
            stbl.add(SampleDescriptionBox.createSampleDescriptionBox(MovieHelper.toSampleEntry(codecMeta)));
            if (pcm) {
                MovieHelper.populateStblPCM(stbl, chunks, trackId, codecMeta);
            } else {
                MovieHelper.populateStblGeneric(stbl, chunks, trackId, codecMeta, trackTimescale);
            }
            MovieHelper.addEdits(trak, track, defaultTimescale, trackTimescale);
            movie.add(trak);
        }
        brand.getFileTypeBox().write(buf);
        movie.write(buf);
        Header.createHeader("mdat", dataSize).write(buf);
        buf.flip();
        return buf;
    }

    private static SampleEntry toSampleEntry(CodecMeta se) {
        SampleEntry vse;
        Rational pasp = null;
        if ("avc1".equals(se.getFourcc())) {
            vse = H264Utils.createMOVSampleEntryFromBytes(se.getCodecPrivate().duplicate());
            pasp = ((VideoCodecMeta)se).getPasp();
        } else if (se instanceof VideoCodecMeta) {
            VideoCodecMeta ss = (VideoCodecMeta)se;
            pasp = ss.getPasp();
            vse = MP4Muxer.videoSampleEntry(se.getFourcc(), ss.getSize(), "JCodec");
        } else {
            AudioCodecMeta ss = (AudioCodecMeta)se;
            vse = ss.isPCM() ? MP4Muxer.audioSampleEntry(se.getFourcc(), 1, ss.getSampleSize(), ss.getChannelCount(), ss.getSampleRate(), ss.getEndian()) : FramesMP4MuxerTrack.compressedAudioSampleEntry(se.getFourcc(), 1, ss.getSampleSize(), ss.getChannelCount(), ss.getSampleRate(), ss.getSamplesPerPacket(), ss.getBytesPerPacket(), ss.getBytesPerFrame());
            ChannelBox chan = ChannelBox.createChannelBox();
            AudioSampleEntry.setLabels(ss.getChannelLabels(), chan);
            vse.add(chan);
        }
        if (pasp != null) {
            vse.add(PixelAspectExt.createPixelAspectExt(pasp));
        }
        return vse;
    }

    private static int chooseTimescale(VirtualMP4Movie.PacketChunk[] chunks, int trackId) {
        for (int ch = 0; ch < chunks.length; ++ch) {
            if (chunks[ch].getTrackNo() != trackId) continue;
            double dur = chunks[ch].getPacket().getDuration();
            double min = Double.MAX_VALUE;
            int minTs = -1;
            for (int ts = 0; ts < timescales.length; ++ts) {
                double dd = (double)timescales[ts] * dur;
                double diff = dd - (double)((int)dd);
                if (!(diff < min)) continue;
                minTs = ts;
                min = diff;
            }
            return timescales[minTs];
        }
        return 0;
    }

    private static void addEdits(TrakBox trak, VirtualTrack track, int defaultTimescale, int trackTimescale) {
        VirtualTrack.VirtualEdit[] edits = track.getEdits();
        if (edits == null) {
            return;
        }
        ArrayList<Edit> result = new ArrayList<Edit>();
        for (VirtualTrack.VirtualEdit virtualEdit : edits) {
            result.add(new Edit((int)(virtualEdit.getDuration() * (double)defaultTimescale), (int)(virtualEdit.getIn() * (double)trackTimescale), 1.0f));
        }
        trak.setEdits(result);
    }

    private static long calcMovieDuration(VirtualTrack[] tracks, int defaultTimescale, double[] dur) {
        long movieDur = 0L;
        for (int trackId = 0; trackId < tracks.length; ++trackId) {
            movieDur = Math.max(movieDur, (long)((double)defaultTimescale * dur[trackId]));
        }
        return movieDur;
    }

    private static double[] calcTrackDurations(VirtualMP4Movie.PacketChunk[] chunks, VirtualTrack[] tracks) {
        double[] dur = new double[tracks.length];
        Arrays.fill(dur, -1.0);
        int n = 0;
        for (int chunkId = chunks.length - 1; chunkId >= 0 && n < dur.length; --chunkId) {
            VirtualMP4Movie.PacketChunk chunk = chunks[chunkId];
            int track = chunk.getTrackNo();
            if (dur[track] != -1.0) continue;
            dur[track] = chunk.getPacket().getPts() + chunk.getPacket().getDuration();
            ++n;
        }
        return dur;
    }

    private static void populateStblGeneric(NodeBox stbl, VirtualMP4Movie.PacketChunk[] chunks, int trackId, CodecMeta se, int timescale) throws IOException {
        LongArrayList stco = new LongArrayList(256000);
        IntArrayList stsz = new IntArrayList(256000);
        ArrayList<TimeToSampleBox.TimeToSampleEntry> stts = new ArrayList<TimeToSampleBox.TimeToSampleEntry>();
        IntArrayList stss = new IntArrayList(4096);
        int prevDur = 0;
        int prevCount = -1;
        boolean allKey = true;
        ArrayList<CompositionOffsetsBox.Entry> compositionOffsets = new ArrayList<CompositionOffsetsBox.Entry>();
        long ptsEstimate = 0L;
        int lastCompositionSamples = 0;
        int lastCompositionOffset = 0;
        for (int chunkNo = 0; chunkNo < chunks.length; ++chunkNo) {
            long pts;
            int compositionOffset;
            VirtualMP4Movie.PacketChunk chunk = chunks[chunkNo];
            if (chunk.getTrackNo() != trackId) continue;
            stco.add(chunk.getPos());
            stsz.add(Math.max(0, chunk.getDataLen()));
            int dur = (int)Math.round(chunk.getPacket().getDuration() * (double)timescale);
            if (dur != prevDur) {
                if (prevCount != -1) {
                    stts.add(new TimeToSampleBox.TimeToSampleEntry(prevCount, prevDur));
                }
                prevDur = dur;
                prevCount = 0;
            }
            ++prevCount;
            boolean key = chunk.getPacket().isKeyframe();
            allKey &= key;
            if (key) {
                stss.add(chunk.getPacket().getFrameNo() + 1);
            }
            if ((compositionOffset = (int)((pts = Math.round(chunk.getPacket().getPts() * (double)timescale)) - ptsEstimate)) != lastCompositionOffset) {
                if (lastCompositionSamples > 0) {
                    compositionOffsets.add(new CompositionOffsetsBox.Entry(lastCompositionSamples, lastCompositionOffset));
                }
                lastCompositionOffset = compositionOffset;
                lastCompositionSamples = 0;
            }
            ++lastCompositionSamples;
            ptsEstimate += (long)dur;
        }
        if (compositionOffsets.size() > 0) {
            compositionOffsets.add(new CompositionOffsetsBox.Entry(lastCompositionSamples, lastCompositionOffset));
        }
        if (prevCount > 0) {
            stts.add(new TimeToSampleBox.TimeToSampleEntry(prevCount, prevDur));
        }
        if (!allKey) {
            stbl.add(SyncSamplesBox.createSyncSamplesBox(stss.toArray()));
        }
        stbl.add(ChunkOffsets64Box.createChunkOffsets64Box(stco.toArray()));
        stbl.add(SampleToChunkBox.createSampleToChunkBox(new SampleToChunkBox.SampleToChunkEntry[]{new SampleToChunkBox.SampleToChunkEntry(1L, 1, 1)}));
        stbl.add(SampleSizesBox.createSampleSizesBox2(stsz.toArray()));
        stbl.add(TimeToSampleBox.createTimeToSampleBox(stts.toArray(new TimeToSampleBox.TimeToSampleEntry[0])));
        MovieHelper.compositionOffsets(compositionOffsets, stbl);
    }

    private static void compositionOffsets(List<CompositionOffsetsBox.Entry> compositionOffsets, NodeBox stbl) {
        if (compositionOffsets.size() > 0) {
            int min = FramesMP4MuxerTrack.minOffset(compositionOffsets);
            for (CompositionOffsetsBox.Entry entry : compositionOffsets) {
                entry.offset -= min;
            }
            stbl.add(CompositionOffsetsBox.createCompositionOffsetsBox(compositionOffsets.toArray(new CompositionOffsetsBox.Entry[0])));
        }
    }

    private static void populateStblPCM(NodeBox stbl, VirtualMP4Movie.PacketChunk[] chunks, int trackId, CodecMeta se) throws IOException {
        AudioCodecMeta ase = (AudioCodecMeta)se;
        int frameSize = ase.getFrameSize();
        LongArrayList stco = new LongArrayList(256000);
        ArrayList<SampleToChunkBox.SampleToChunkEntry> stsc = new ArrayList<SampleToChunkBox.SampleToChunkEntry>();
        int stscCount = -1;
        int stscFirstChunk = -1;
        int totalFrames = 0;
        int stscCurChunk = 1;
        for (int chunkNo = 0; chunkNo < chunks.length; ++chunkNo) {
            VirtualMP4Movie.PacketChunk chunk = chunks[chunkNo];
            if (chunk.getTrackNo() != trackId) continue;
            stco.add(chunk.getPos());
            int framesPerChunk = chunk.getDataLen() / frameSize;
            if (framesPerChunk != stscCount) {
                if (stscCount != -1) {
                    stsc.add(new SampleToChunkBox.SampleToChunkEntry(stscFirstChunk, stscCount, 1));
                }
                stscFirstChunk = stscCurChunk;
                stscCount = framesPerChunk;
            }
            ++stscCurChunk;
            totalFrames += framesPerChunk;
        }
        if (stscCount != -1) {
            stsc.add(new SampleToChunkBox.SampleToChunkEntry(stscFirstChunk, stscCount, 1));
        }
        stbl.add(ChunkOffsets64Box.createChunkOffsets64Box(stco.toArray()));
        stbl.add(SampleToChunkBox.createSampleToChunkBox(stsc.toArray(new SampleToChunkBox.SampleToChunkEntry[0])));
        stbl.add(SampleSizesBox.createSampleSizesBox(ase.getFrameSize(), totalFrames));
        stbl.add(TimeToSampleBox.createTimeToSampleBox(new TimeToSampleBox.TimeToSampleEntry[]{new TimeToSampleBox.TimeToSampleEntry(totalFrames, 1)}));
    }

    private static int getPCMTs(AudioCodecMeta se, VirtualMP4Movie.PacketChunk[] chunks, int trackId) throws IOException {
        for (int chunkNo = 0; chunkNo < chunks.length; ++chunkNo) {
            if (chunks[chunkNo].getTrackNo() != trackId) continue;
            return (int)Math.round((double)chunks[chunkNo].getDataLen() / ((double)se.getFrameSize() * chunks[chunkNo].getPacket().getDuration()));
        }
        throw new RuntimeException("Crap");
    }

    private static void mediaHeader(MediaInfoBox minf, MP4TrackType type) {
        if (MP4TrackType.VIDEO == type) {
            VideoMediaHeaderBox vmhd = VideoMediaHeaderBox.createVideoMediaHeaderBox(0, 0, 0, 0);
            vmhd.setFlags(1);
            minf.add(vmhd);
        } else if (MP4TrackType.SOUND == type) {
            SoundMediaHeaderBox smhd = SoundMediaHeaderBox.createSoundMediaHeaderBox();
            smhd.setFlags(1);
            minf.add(smhd);
        } else if (MP4TrackType.TIMECODE == type) {
            NodeBox gmhd = new NodeBox(new Header("gmhd"));
            gmhd.add(GenericMediaInfoBox.createGenericMediaInfoBox());
            NodeBox tmcd = new NodeBox(new Header("tmcd"));
            gmhd.add(tmcd);
            tmcd.add(TimecodeMediaInfoBox.createTimecodeMediaInfoBox((short)0, (short)0, (short)12, new short[]{0, 0, 0}, new short[]{255, 255, 255}, "Lucida Grande"));
            minf.add(gmhd);
        } else {
            throw new UnhandledStateException("Handler " + type.getHandler() + " not supported");
        }
    }

    private static void addDref(NodeBox minf) {
        DataInfoBox dinf = DataInfoBox.createDataInfoBox();
        minf.add(dinf);
        DataRefBox dref = DataRefBox.createDataRefBox();
        dinf.add(dref);
        dref.add(Box.LeafBox.createLeafBox(Header.createHeader("alis", 0L), ByteBuffer.wrap(new byte[]{0, 0, 0, 1})));
    }

    private static MovieHeaderBox movieHeader(NodeBox movie, int nTracks, long duration, int timescale) {
        return MovieHeaderBox.createMovieHeaderBox(timescale, duration, 1.0f, 1.0f, new Date().getTime(), new Date().getTime(), new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000}, nTracks + 1);
    }
}

