/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.movtool.streaming.MovieHelper;
import org.jcodec.movtool.streaming.MovieSegment;
import org.jcodec.movtool.streaming.VirtualMovie;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;

public class VirtualMP4Movie
extends VirtualMovie {
    private Brand brand = Brand.MP4;

    public VirtualMP4Movie(VirtualTrack ... arguments) throws IOException {
        super(arguments);
        this.muxTracks();
    }

    @Override
    protected MovieSegment headerChunk(List<MovieSegment> ch, VirtualTrack[] tracks, long dataSize) throws IOException {
        PacketChunk[] chunks = ch.toArray(new PacketChunk[0]);
        int headerSize = MovieHelper.produceHeader(chunks, tracks, dataSize, this.brand).remaining();
        for (PacketChunk chunk : chunks) {
            chunk.offset(headerSize);
        }
        final ByteBuffer header = MovieHelper.produceHeader(chunks, tracks, dataSize, this.brand);
        return new MovieSegment(){

            @Override
            public ByteBuffer getData() {
                return header.duplicate();
            }

            @Override
            public int getNo() {
                return 0;
            }

            @Override
            public long getPos() {
                return 0L;
            }

            @Override
            public int getDataLen() {
                return header.remaining();
            }
        };
    }

    @Override
    protected MovieSegment packetChunk(VirtualTrack track, VirtualPacket pkt, int chunkNo, int trackNo, long pos) {
        return new PacketChunk(pkt, trackNo, chunkNo, pos, track.getCodecMeta().getFourcc());
    }

    public static class PacketChunk
    implements MovieSegment {
        private VirtualPacket packet;
        private int track;
        private int no;
        private long pos;
        private String fourcc;

        public PacketChunk(VirtualPacket packet, int track, int no, long pos, String fourcc) {
            this.packet = packet;
            this.track = track;
            this.no = no;
            this.pos = pos;
            this.fourcc = fourcc;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer buf = this.packet.getData().duplicate();
            H264Utils.encodeMOVPacketInplace(buf);
            return buf;
        }

        @Override
        public int getNo() {
            return this.no;
        }

        @Override
        public long getPos() {
            return this.pos;
        }

        public void offset(int off) {
            this.pos += (long)off;
        }

        @Override
        public int getDataLen() throws IOException {
            return this.packet.getDataLen();
        }

        public VirtualPacket getPacket() {
            return this.packet;
        }

        public int getTrackNo() {
            return this.track;
        }
    }
}

