/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.containers.mkv.MKVStreamingMuxer;
import org.jcodec.movtool.streaming.MovieSegment;
import org.jcodec.movtool.streaming.VirtualMovie;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;

public class VirtualWebmMovie
extends VirtualMovie {
    private MKVStreamingMuxer muxer = new MKVStreamingMuxer();

    public VirtualWebmMovie(VirtualTrack ... arguments) throws IOException {
        super(arguments);
        this.muxTracks();
    }

    @Override
    protected void muxTracks() throws IOException {
        ArrayList<MovieSegment> chch = new ArrayList<MovieSegment>();
        VirtualPacket[] heads = new VirtualPacket[this.tracks.length];
        VirtualPacket[] tails = new VirtualPacket[this.tracks.length];
        long currentlyAddedContentSize = 0L;
        int curChunk = 1;
        while (true) {
            int min = -1;
            for (int i = 0; i < heads.length; ++i) {
                if (heads[i] == null) {
                    heads[i] = this.tracks[i].nextPacket();
                    if (heads[i] == null) continue;
                }
                min = min == -1 || heads[i].getPts() < heads[min].getPts() ? i : min;
            }
            if (min == -1) break;
            MovieSegment packetChunk = this.packetChunk(this.tracks[min], heads[min], curChunk, min, currentlyAddedContentSize);
            chch.add(packetChunk);
            currentlyAddedContentSize += (long)packetChunk.getDataLen();
            tails[min] = heads[min];
            heads[min] = this.tracks[min].nextPacket();
            ++curChunk;
        }
        this._headerChunk = this.headerChunk(chch, this.tracks, this._size);
        this._size += (long)this._headerChunk.getDataLen() + currentlyAddedContentSize;
        this.chunks = chch.toArray(new MovieSegment[0]);
    }

    @Override
    protected MovieSegment packetChunk(VirtualTrack track, VirtualPacket pkt, int chunkNo, int trackNo, long previousClustersSize) {
        return this.muxer.preparePacket(track, pkt, chunkNo, trackNo, previousClustersSize);
    }

    @Override
    protected MovieSegment headerChunk(List<MovieSegment> chunks, VirtualTrack[] tracks, long dataSize) throws IOException {
        return this.muxer.prepareHeader(chunks, tracks);
    }
}

