/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.VirtualPacketWrapper;

public class CachingTrack
implements VirtualTrack {
    private VirtualTrack src;
    private List<CachingPacket> cachedPackets = Collections.synchronizedList(new ArrayList());
    private ScheduledFuture<?> policyFuture;

    public CachingTrack(VirtualTrack src, final int policy, ScheduledExecutorService policyExecutor) {
        if (policy < 1) {
            throw new IllegalArgumentException("Caching track with less then 1 entry.");
        }
        this.src = src;
        final CachingTrack self = this;
        this.policyFuture = policyExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                while (self.cachedPackets.size() > policy) {
                    ((CachingPacket)self.cachedPackets.get(0)).wipe();
                }
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.src.getCodecMeta();
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        VirtualPacket pkt = this.src.nextPacket();
        if (pkt == null) {
            return null;
        }
        return new CachingPacket(this, pkt);
    }

    @Override
    public void close() throws IOException {
        if (this.policyFuture != null) {
            this.policyFuture.cancel(false);
        }
        this.cachedPackets.clear();
        this.src.close();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return this.src.getEdits();
    }

    @Override
    public int getPreferredTimescale() {
        return this.src.getPreferredTimescale();
    }

    public static class CachingPacket
    extends VirtualPacketWrapper {
        private ByteBuffer cache;
        private CachingTrack track;

        public CachingPacket(CachingTrack track, VirtualPacket src) {
            super(src);
            this.track = track;
        }

        public synchronized void wipe() {
            if (this.track.cachedPackets.indexOf(this) == 0) {
                this.track.cachedPackets.remove(0);
                this.cache = null;
            }
        }

        @Override
        public synchronized ByteBuffer getData() throws IOException {
            this.track.cachedPackets.remove(this);
            if (this.cache == null) {
                this.cache = this.src.getData();
            }
            this.track.cachedPackets.add(this);
            return this.cache == null ? null : this.cache.duplicate();
        }
    }
}

