/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.movtool.streaming.AudioCodecMeta;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;

public class EditedPCMTrack
implements VirtualTrack {
    private VirtualTrack src;
    private List<VirtualPacket>[] buckets;
    private VirtualTrack.VirtualEdit[] edits;
    private int curEdit;
    private int curPkt;
    private int frameNo;
    private double pts;
    private int frameSize;
    private float sampleRate;

    public EditedPCMTrack(VirtualTrack src) throws IOException {
        VirtualPacket pkt;
        this.src = src;
        this.edits = src.getEdits();
        this.buckets = new List[this.edits.length];
        for (int i = 0; i < this.edits.length; ++i) {
            this.buckets[i] = new ArrayList<VirtualPacket>();
        }
        while ((pkt = src.nextPacket()) != null) {
            for (int e = 0; e < this.edits.length; ++e) {
                VirtualTrack.VirtualEdit ed = this.edits[e];
                if (!(pkt.getPts() < ed.getIn() + ed.getDuration()) || !(pkt.getPts() + pkt.getDuration() > ed.getIn())) continue;
                this.buckets[e].add(pkt);
            }
        }
        AudioCodecMeta ase = (AudioCodecMeta)src.getCodecMeta();
        this.frameSize = ase.getFrameSize();
        this.sampleRate = ase.getSampleRate();
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        if (this.curEdit >= this.edits.length) {
            return null;
        }
        VirtualPacket pkt = this.buckets[this.curEdit].get(this.curPkt);
        VirtualTrack.VirtualEdit edt = this.edits[this.curEdit];
        double start = Math.max(pkt.getPts(), edt.getIn());
        double end = Math.min(pkt.getPts() + pkt.getDuration(), edt.getIn() + edt.getDuration());
        double duration = end - start;
        double lead = start - pkt.getPts();
        EditedPCMPacket ret = new EditedPCMPacket(pkt, (int)(Math.round(lead * (double)this.sampleRate) * (long)this.frameSize), (int)(Math.round(duration * (double)this.sampleRate) * (long)this.frameSize), this.pts, duration, this.frameNo);
        ++this.curPkt;
        if (this.curPkt >= this.buckets[this.curEdit].size()) {
            ++this.curEdit;
            this.curPkt = 0;
        }
        ++this.frameNo;
        this.pts += duration;
        return ret;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.src.getCodecMeta();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    @Override
    public int getPreferredTimescale() {
        return this.src.getPreferredTimescale();
    }

    public static class EditedPCMPacket
    implements VirtualPacket {
        private VirtualPacket src;
        private int inBytes;
        private int dataLen;
        private double pts;
        private double duration;
        private int frameNo;

        public EditedPCMPacket(VirtualPacket src, int inBytes, int dataLen, double pts, double duration, int frameNo) {
            this.src = src;
            this.inBytes = inBytes;
            this.dataLen = dataLen;
            this.pts = pts;
            this.duration = duration;
            this.frameNo = frameNo;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer data = this.src.getData();
            NIOUtils.skip(data, this.inBytes);
            return NIOUtils.read(data, this.dataLen);
        }

        @Override
        public int getDataLen() {
            return this.dataLen;
        }

        @Override
        public double getPts() {
            return this.pts;
        }

        @Override
        public double getDuration() {
            return this.duration;
        }

        @Override
        public boolean isKeyframe() {
            return true;
        }

        @Override
        public int getFrameNo() {
            return this.frameNo;
        }
    }
}

