/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.movtool.streaming.tracks.ByteChannelPool;
import org.jcodec.movtool.streaming.tracks.SeekableByteChannelWrapper;

public class FilePool
implements ByteChannelPool {
    private BlockingQueue<SeekableByteChannel> channels;
    private List<SeekableByteChannel> allChannels;
    private File file;
    private int max;

    public FilePool(File file, int max) {
        this.file = file;
        this.max = max;
        this.channels = new LinkedBlockingQueue<SeekableByteChannel>();
        this.allChannels = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public SeekableByteChannel getChannel() throws IOException {
        SeekableByteChannel channel = (SeekableByteChannel)this.channels.poll();
        if (channel == null) {
            if (this.allChannels.size() < this.max) {
                channel = this.newChannel(this.file);
                this.allChannels.add(channel);
            } else {
                while (true) {
                    try {
                        channel = this.channels.take();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
        return new PoolChannel(this, channel);
    }

    protected SeekableByteChannel newChannel(File file) throws FileNotFoundException {
        return NIOUtils.readableChannel(file);
    }

    @Override
    public void close() {
        while (!this.allChannels.isEmpty()) {
            SeekableByteChannel channel = this.allChannels.remove(0);
            if (channel == null) continue;
            try {
                channel.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static class PoolChannel
    extends SeekableByteChannelWrapper {
        private FilePool pool;

        public PoolChannel(FilePool pool, SeekableByteChannel src) throws IOException {
            super(src);
            this.pool = pool;
            src.setPosition(0L);
        }

        @Override
        public boolean isOpen() {
            return this.src != null;
        }

        @Override
        public void close() throws IOException {
            SeekableByteChannel ret = this.src;
            this.src = null;
            while (true) {
                try {
                    this.pool.channels.put(ret);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

