/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.encode.H264FixedRateControl;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.codecs.mpeg12.MPEGDecoder;
import org.jcodec.codecs.mpeg12.Mpeg2Thumb2x2;
import org.jcodec.codecs.mpeg12.Mpeg2Thumb4x4;
import org.jcodec.common.VideoDecoder;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.common.model.Rect;
import org.jcodec.common.model.Size;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform8Bit;

public class MPEGToAVCTranscoder {
    public static final int TARGET_RATE = 1024;
    private VideoDecoder decoder;
    private H264Encoder encoder;
    private Picture8Bit pic0;
    private Picture8Bit pic1;
    private Transform8Bit transform;
    private H264FixedRateControl rc;
    private int scaleFactor;
    private int thumbWidth;
    private int thumbHeight;

    public MPEGToAVCTranscoder(int scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.rc = new H264FixedRateControl(1024);
        this.decoder = this.getDecoder(scaleFactor);
        this.encoder = new H264Encoder(this.rc);
    }

    protected VideoDecoder getDecoder(int scaleFactor) {
        switch (scaleFactor) {
            case 2: {
                return new Mpeg2Thumb2x2();
            }
            case 1: {
                return new Mpeg2Thumb4x4();
            }
            case 0: {
                return new MPEGDecoder();
            }
        }
        throw new IllegalArgumentException("Unsupported scale factor: " + scaleFactor);
    }

    public ByteBuffer transcodeFrame(ByteBuffer src, ByteBuffer dst, boolean iframe, int poc) throws IOException {
        Picture8Bit toEnc;
        if (src == null) {
            return null;
        }
        if (this.pic0 == null) {
            Size size = new MPEGDecoder().getCodecMeta(src.duplicate()).getSize();
            this.thumbWidth = size.getWidth() >> this.scaleFactor;
            this.thumbHeight = size.getHeight() >> this.scaleFactor;
            int mbW = this.thumbWidth + 8 >> 4;
            int mbH = this.thumbHeight + 8 >> 4;
            this.pic0 = Picture8Bit.create(mbW << 4, mbH + 1 << 4, ColorSpace.YUV444);
        }
        Picture8Bit decoded = this.decoder.decodeFrame8Bit(src, this.pic0.getData());
        if (this.pic1 == null) {
            this.pic1 = Picture8Bit.create(decoded.getWidth(), decoded.getHeight(), this.encoder.getSupportedColorSpaces()[0]);
            this.transform = ColorUtil.getTransform8Bit(decoded.getColor(), this.encoder.getSupportedColorSpaces()[0]);
        }
        if (this.transform != null) {
            this.transform.transform(decoded, this.pic1);
            toEnc = this.pic1;
        } else {
            toEnc = decoded;
        }
        this.pic1.setCrop(new Rect(0, 0, this.thumbWidth, this.thumbHeight));
        int rate = 1024;
        while (true) {
            try {
                this.encoder.doEncodeFrame8Bit(toEnc, dst, iframe, poc, SliceType.I);
            }
            catch (BufferOverflowException ex) {
                Logger.warn("Abandon frame, buffer too small: " + dst.capacity());
                this.rc.setRate(rate -= 10);
                if (rate > 10) continue;
            }
            break;
        }
        this.rc.setRate(1024);
        H264Utils.encodeMOVPacketInplace(dst);
        return dst;
    }

    protected static MPEGToAVCTranscoder createTranscoder(int scaleFactor) {
        return new MPEGToAVCTranscoder(scaleFactor);
    }
}

