/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcodec.common.RunLength;
import org.jcodec.common.io.FileChannelWrapper;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Rational;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mps.MPSUtils;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VideoCodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.FilePool;
import org.jcodec.platform.Platform;

public class MPSTrackFactory {
    private Map<Integer, Stream> tracks;
    private FilePool fp;
    private long[] pesTokens;
    private int[] streams;

    public MPSTrackFactory(ByteBuffer index, FilePool fp) throws IOException {
        this.fp = fp;
        this.tracks = new HashMap<Integer, Stream>();
        this.readIndex(index);
    }

    protected void readIndex(ByteBuffer index) throws IOException {
        int nTokens = index.getInt();
        this.pesTokens = new long[nTokens];
        for (int i = 0; i < this.pesTokens.length; ++i) {
            this.pesTokens[i] = index.getLong();
        }
        this.streams = RunLength.Integer.parse(index).flattern();
        while (index.hasRemaining()) {
            int stream = index.get() & 0xFF;
            this.getStream(this.tracks, stream).parseIndex(index);
        }
    }

    private Stream getStream(Map<Integer, Stream> streams, int streamId) {
        Stream stream = streams.get(streamId);
        if (stream == null) {
            stream = this.createStream(streamId);
            streams.put(streamId, stream);
        }
        return stream;
    }

    protected Stream createStream(int streamId) {
        return new Stream(streamId, this);
    }

    public List<Stream> getVideoStreams() {
        ArrayList<Stream> ret = new ArrayList<Stream>();
        Set<Map.Entry<Integer, Stream>> entrySet = this.tracks.entrySet();
        for (Map.Entry<Integer, Stream> entry : entrySet) {
            if (!MPSUtils.videoStream(entry.getKey())) continue;
            ret.add(entry.getValue());
        }
        return ret;
    }

    public List<Stream> getAudioStreams() {
        ArrayList<Stream> ret = new ArrayList<Stream>();
        Set<Map.Entry<Integer, Stream>> entrySet = this.tracks.entrySet();
        for (Map.Entry<Integer, Stream> entry : entrySet) {
            if (!MPSUtils.audioStream(entry.getKey())) continue;
            ret.add(entry.getValue());
        }
        return ret;
    }

    public List<Stream> getStreams() {
        return new ArrayList<Stream>(this.tracks.values());
    }

    public static void main1(String[] args) throws IOException {
        FilePool fp = new FilePool(new File(args[0]), 10);
        MPSTrackFactory factory = new MPSTrackFactory(NIOUtils.fetchFromFile(new File(args[1])), fp);
        Stream stream = factory.getVideoStreams().get(0);
        FileChannelWrapper ch = NIOUtils.writableChannel(new File(args[2]));
        ArrayList<VirtualPacket> pkt = new ArrayList<VirtualPacket>();
        for (int i = 0; i < 2000; ++i) {
            pkt.add(stream.nextPacket());
        }
        for (VirtualPacket virtualPacket : pkt) {
            ch.write(virtualPacket.getData());
        }
        ch.close();
    }

    public static class Stream
    implements VirtualTrack {
        private int siLen;
        private int[] fsizes;
        private long[] fpts;
        private int[] sync;
        private long duration;
        private int streamId;
        private long fileOff;
        private int pesIdx;
        private int curFrame;
        private int offInPayload;
        private ByteBuffer si;
        private MPSTrackFactory factory;

        public Stream(int streamId, MPSTrackFactory factory) {
            this.streamId = streamId;
            this.factory = factory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parseIndex(ByteBuffer index) throws IOException {
            int i;
            this.siLen = index.getInt();
            int fCnt = index.getInt();
            this.fsizes = new int[fCnt];
            this.fpts = new long[fCnt];
            for (int i2 = 0; i2 < fCnt; ++i2) {
                int size;
                this.fsizes[i2] = size = index.getInt();
            }
            int syncCount = index.getInt();
            this.sync = new int[syncCount];
            for (i = 0; i < syncCount; ++i) {
                this.sync[i] = index.getInt();
            }
            for (i = 0; i < fCnt; ++i) {
                this.fpts[i] = (long)index.getInt() & 0xFFFFFFFFL;
            }
            long[] seg0 = Platform.copyOfLong(this.fpts, 10);
            Arrays.sort(seg0);
            long[] seg1 = new long[10];
            System.arraycopy(this.fpts, this.fpts.length - 10, seg1, 0, 10);
            Arrays.sort(seg1);
            this.duration = (seg1[9] - seg0[0] + (long)(this.fpts.length >> 1)) / (long)this.fpts.length;
            this.offInPayload = this.siLen;
            this.fileOff = 0L;
            while (this.factory.streams[this.pesIdx] != this.streamId) {
                this.fileOff += (long)(this.pesLen(this.factory.pesTokens[this.pesIdx]) + this.leadingSize(this.factory.pesTokens[this.pesIdx]));
                ++this.pesIdx;
            }
            this.fileOff += (long)this.leadingSize(this.factory.pesTokens[this.pesIdx]);
            SeekableByteChannel ch = null;
            try {
                ch = this.factory.fp.getChannel();
                ByteBuffer firstPes = this.readPes(ch, this.fileOff, this.pesLen(this.factory.pesTokens[this.pesIdx]), this.payloadLen(this.factory.pesTokens[this.pesIdx]), this.pesIdx);
                this.si = NIOUtils.read(firstPes, this.siLen);
            }
            catch (Throwable throwable) {
                NIOUtils.closeQuietly(ch);
                throw throwable;
            }
            NIOUtils.closeQuietly(ch);
        }

        protected ByteBuffer readPes(SeekableByteChannel ch, long pesPosition, int pesSize, int payloadSize, int pesIdx) throws IOException {
            ch.setPosition(pesPosition);
            ByteBuffer pes = NIOUtils.fetchFromChannel(ch, pesSize);
            MPSUtils.readPESHeader(pes, 0L);
            return pes;
        }

        private int pesLen(long token) {
            return (int)(token >>> 24 & 0xFFFFFFL);
        }

        private int payloadLen(long token) {
            return (int)(token & 0xFFFFFFL);
        }

        private int leadingSize(long token) {
            return (int)(token >>> 48 & 0xFFFFL);
        }

        @Override
        public VirtualPacket nextPacket() throws IOException {
            if (this.curFrame >= this.fsizes.length) {
                return null;
            }
            MPSPacket pkt = new MPSPacket(this, this.offInPayload, this.fileOff, this.curFrame, this.pesIdx);
            this.offInPayload += this.fsizes[this.curFrame];
            while (this.pesIdx < this.factory.streams.length && this.offInPayload >= this.payloadLen(this.factory.pesTokens[this.pesIdx])) {
                int ps = this.payloadLen(this.factory.pesTokens[this.pesIdx]);
                this.offInPayload -= ps;
                this.fileOff += (long)this.pesLen(this.factory.pesTokens[this.pesIdx]);
                ++this.pesIdx;
                if (this.pesIdx >= this.factory.streams.length) continue;
                long posShift = 0L;
                while (this.factory.streams[this.pesIdx] != this.streamId) {
                    posShift += (long)(this.pesLen(this.factory.pesTokens[this.pesIdx]) + this.leadingSize(this.factory.pesTokens[this.pesIdx]));
                    ++this.pesIdx;
                }
                this.fileOff += posShift + (long)this.leadingSize(this.factory.pesTokens[this.pesIdx]);
            }
            ++this.curFrame;
            return pkt;
        }

        @Override
        public CodecMeta getCodecMeta() {
            return VideoCodecMeta.createVideoCodecMeta("m2v1", ByteBuffer.allocate(0), new Size(1920, 1080), new Rational(1, 1));
        }

        @Override
        public VirtualTrack.VirtualEdit[] getEdits() {
            return null;
        }

        @Override
        public int getPreferredTimescale() {
            return 90000;
        }

        @Override
        public void close() throws IOException {
            this.factory.fp.close();
        }

        protected static class MPSPacket
        implements VirtualPacket {
            private long fileOff;
            private int curFrame;
            private int pesOff;
            private int pesIdx;
            private Stream s;

            public MPSPacket(Stream stream, int pesOff, long fileOff, int curFrame, int pesIdx) {
                this.s = stream;
                this.pesOff = pesOff;
                this.fileOff = fileOff;
                this.curFrame = curFrame;
                this.pesIdx = pesIdx;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ByteBuffer getData() throws IOException {
                ByteBuffer byteBuffer;
                ByteBuffer result = ByteBuffer.allocate(this.s.siLen + this.s.fsizes[this.curFrame]);
                result.put(this.s.si.duplicate());
                SeekableByteChannel ch = null;
                try {
                    ch = this.s.factory.fp.getChannel();
                    long curOff = this.fileOff;
                    ByteBuffer pesBuf = this.s.readPes(ch, curOff, this.s.pesLen(this.s.factory.pesTokens[this.pesIdx]), this.s.payloadLen(this.s.factory.pesTokens[this.pesIdx]), this.pesIdx);
                    curOff += (long)this.s.pesLen(this.s.factory.pesTokens[this.pesIdx]);
                    NIOUtils.skip(pesBuf, this.pesOff);
                    result.put(NIOUtils.read(pesBuf, Math.min(pesBuf.remaining(), result.remaining())));
                    int idx = this.pesIdx;
                    while (result.hasRemaining()) {
                        long posShift = 0L;
                        ++idx;
                        while (this.s.factory.streams[idx] != this.s.streamId && idx < this.s.factory.pesTokens.length) {
                            posShift += (long)(this.s.pesLen(this.s.factory.pesTokens[idx]) + this.s.leadingSize(this.s.factory.pesTokens[idx]));
                            ++idx;
                        }
                        pesBuf = this.s.readPes(ch, curOff + posShift + (long)this.s.leadingSize(this.s.factory.pesTokens[idx]), this.s.pesLen(this.s.factory.pesTokens[idx]), this.s.payloadLen(this.s.factory.pesTokens[idx]), idx);
                        curOff += posShift + (long)this.s.leadingSize(this.s.factory.pesTokens[idx]) + (long)this.s.pesLen(this.s.factory.pesTokens[idx]);
                        result.put(NIOUtils.read(pesBuf, Math.min(pesBuf.remaining(), result.remaining())));
                    }
                    result.flip();
                    byteBuffer = result;
                }
                catch (Throwable throwable) {
                    NIOUtils.closeQuietly(ch);
                    throw throwable;
                }
                NIOUtils.closeQuietly(ch);
                return byteBuffer;
            }

            @Override
            public int getDataLen() throws IOException {
                return this.s.siLen + this.s.fsizes[this.curFrame];
            }

            @Override
            public double getPts() {
                return (double)(this.s.fpts[this.curFrame] - this.s.fpts[0]) / 90000.0;
            }

            @Override
            public double getDuration() {
                return (double)this.s.duration / 90000.0;
            }

            @Override
            public boolean isKeyframe() {
                return this.s.sync.length == 0 || Arrays.binarySearch(this.s.sync, this.curFrame) >= 0;
            }

            @Override
            public int getFrameNo() {
                return this.curFrame;
            }
        }
    }
}

