/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.common.Assert;
import org.jcodec.common.io.FileChannelWrapper;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.containers.mps.MPSUtils;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.tracks.FilePool;
import org.jcodec.movtool.streaming.tracks.MPSTrackFactory;

public class MTSTrackFactory {
    private List<MTSProgram> programs = new ArrayList<MTSProgram>();

    public MTSTrackFactory(ByteBuffer index, FilePool fp) throws IOException {
        while (index.remaining() >= 6) {
            int len = index.getInt() - 4;
            ByteBuffer sub = NIOUtils.read(index, len);
            this.programs.add(new MTSProgram(sub, fp));
        }
    }

    public List<MPSTrackFactory.Stream> getVideoStreams() {
        ArrayList<MPSTrackFactory.Stream> ret = new ArrayList<MPSTrackFactory.Stream>();
        for (MTSProgram mtsProgram : this.programs) {
            ret.addAll(mtsProgram.getVideoStreams());
        }
        return ret;
    }

    public List<MPSTrackFactory.Stream> getAudioStreams() {
        ArrayList<MPSTrackFactory.Stream> ret = new ArrayList<MPSTrackFactory.Stream>();
        for (MTSProgram mtsProgram : this.programs) {
            ret.addAll(mtsProgram.getAudioStreams());
        }
        return ret;
    }

    public List<MPSTrackFactory.Stream> getStreams() {
        ArrayList<MPSTrackFactory.Stream> ret = new ArrayList<MPSTrackFactory.Stream>();
        for (MTSProgram mtsProgram : this.programs) {
            ret.addAll(mtsProgram.getStreams());
        }
        return ret;
    }

    public static void main1(String[] args) throws IOException {
        FilePool fp = new FilePool(new File(args[0]), 10);
        MTSTrackFactory factory = new MTSTrackFactory(NIOUtils.fetchFromFile(new File(args[1])), fp);
        MPSTrackFactory.Stream stream = factory.getVideoStreams().get(0);
        FileChannelWrapper ch = NIOUtils.writableChannel(new File(args[2]));
        ArrayList<VirtualPacket> pkt = new ArrayList<VirtualPacket>();
        for (int i = 0; i < 2000; ++i) {
            pkt.add(stream.nextPacket());
        }
        for (VirtualPacket virtualPacket : pkt) {
            ch.write(virtualPacket.getData());
        }
        ch.close();
    }

    public static class MTSProgram
    extends MPSTrackFactory {
        private int targetGuid;

        public MTSProgram(ByteBuffer index, FilePool fp) throws IOException {
            super(index, fp);
        }

        @Override
        protected void readIndex(ByteBuffer index) throws IOException {
            this.targetGuid = index.getShort() & 0xFFFF;
            super.readIndex(index);
        }

        @Override
        protected MPSTrackFactory.Stream createStream(int streamId) {
            return new MTSStream(streamId, this);
        }

        public static class MTSStream
        extends MPSTrackFactory.Stream {
            private MTSProgram program;

            public MTSStream(int streamId, MTSProgram program) {
                super(streamId, program);
                this.program = program;
            }

            @Override
            protected ByteBuffer readPes(SeekableByteChannel ch, long pesPosition, int pesSize, int payloadSize, int pesAbsIdx) throws IOException {
                ch.setPosition(pesPosition * 188L);
                ByteBuffer buf = NIOUtils.fetchFromChannel(ch, pesSize * 188);
                ByteBuffer dst = buf.duplicate();
                while (buf.hasRemaining()) {
                    ByteBuffer tsBuf = NIOUtils.read(buf, 188);
                    Assert.assertEquals(71, tsBuf.get() & 0xFF);
                    int guidFlags = (tsBuf.get() & 0xFF) << 8 | tsBuf.get() & 0xFF;
                    int guid = guidFlags & 0x1FFF;
                    if (guid != this.program.targetGuid) continue;
                    int b0 = tsBuf.get() & 0xFF;
                    int counter = b0 & 0xF;
                    if ((b0 & 0x20) != 0) {
                        NIOUtils.skip(tsBuf, tsBuf.get() & 0xFF);
                    }
                    dst.put(tsBuf);
                }
                dst.flip();
                MPSUtils.readPESHeader(dst, 0L);
                dst.limit(dst.position() + payloadSize);
                return dst;
            }
        }
    }
}

