/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.codecs.pcmdvd.PCMDVDDecoder;
import org.jcodec.common.AudioFormat;
import org.jcodec.common.model.AudioBuffer;
import org.jcodec.common.model.Label;
import org.jcodec.containers.mp4.muxer.PCMMP4MuxerTrack;
import org.jcodec.movtool.streaming.AudioCodecMeta;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.VirtualPacketWrapper;

public class PCMDVDTrack
implements VirtualTrack {
    private VirtualTrack src;
    private AudioFormat format;
    private VirtualPacket prevPkt;
    private PCMDVDDecoder decoder;
    private int nFrames;

    public PCMDVDTrack(VirtualTrack src) throws IOException {
        this.src = src;
        this.prevPkt = src.nextPacket();
        this.decoder = new PCMDVDDecoder();
        if (this.prevPkt != null) {
            AudioBuffer decodeFrame = this.decoder.decodeFrame(this.prevPkt.getData(), ByteBuffer.allocate(this.prevPkt.getData().remaining()));
            this.format = decodeFrame.getFormat();
            this.nFrames = decodeFrame.getNFrames();
        }
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        if (this.prevPkt == null) {
            return null;
        }
        VirtualPacket ret = this.prevPkt;
        this.prevPkt = this.src.nextPacket();
        return new PCMDVDPkt(this, ret);
    }

    @Override
    public CodecMeta getCodecMeta() {
        return AudioCodecMeta.createAudioCodecMeta3(PCMMP4MuxerTrack.lookupFourcc(this.format), ByteBuffer.allocate(0), this.format, true, new Label[]{Label.Left, Label.Right});
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return null;
    }

    @Override
    public int getPreferredTimescale() {
        return this.format.getSampleRate();
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    private static class PCMDVDPkt
    extends VirtualPacketWrapper {
        private PCMDVDTrack track;

        public PCMDVDPkt(PCMDVDTrack track, VirtualPacket src) {
            super(src);
            this.track = track;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer data = super.getData();
            AudioBuffer decodeFrame = this.track.decoder.decodeFrame(data, data);
            return decodeFrame.getData();
        }

        @Override
        public int getDataLen() throws IOException {
            return this.track.nFrames * this.track.format.getChannels() << 1;
        }
    }
}

