/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.movtool.streaming.AudioCodecMeta;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;

public class PCMFlatternTrack
implements VirtualTrack {
    private static final VirtualPacket[] EMPTY = new VirtualPacket[0];
    private int framesPerPkt;
    private VirtualTrack src;
    private AudioCodecMeta se;
    private int dataLen;
    private double packetDur;
    private VirtualPacket leftover;
    private int leftoverOffset;
    private int frameNo;
    private List<VirtualPacket> pktBuffer = new ArrayList<VirtualPacket>();

    public PCMFlatternTrack(VirtualTrack src, int samplesPerPkt) {
        this.framesPerPkt = samplesPerPkt;
        this.src = src;
        this.se = (AudioCodecMeta)src.getCodecMeta();
        this.dataLen = this.se.getFrameSize() * this.framesPerPkt;
        this.packetDur = (double)this.framesPerPkt / (double)this.se.getSampleRate();
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        VirtualPacket pkt;
        this.pktBuffer.clear();
        VirtualPacket virtualPacket = pkt = this.leftover == null ? this.src.nextPacket() : this.leftover;
        if (pkt == null) {
            return null;
        }
        int rem = this.dataLen + this.leftoverOffset;
        do {
            this.pktBuffer.add(pkt);
            if ((rem -= pkt.getDataLen()) <= 0) continue;
            pkt = this.src.nextPacket();
        } while (rem > 0 && pkt != null);
        FlatternPacket result = new FlatternPacket(this, this.frameNo, this.pktBuffer.toArray(EMPTY), this.leftoverOffset, this.dataLen - Math.max(rem, 0));
        this.frameNo += this.framesPerPkt;
        if (rem < 0) {
            this.leftover = this.pktBuffer.get(this.pktBuffer.size() - 1);
            this.leftoverOffset = this.leftover.getDataLen() + rem;
        } else {
            this.leftover = null;
            this.leftoverOffset = 0;
        }
        return result;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.se;
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return this.src.getEdits();
    }

    @Override
    public int getPreferredTimescale() {
        return this.src.getPreferredTimescale();
    }

    private static class FlatternPacket
    implements VirtualPacket {
        private int frameNo;
        private int leading;
        private VirtualPacket[] pN;
        private int dataLen;
        private PCMFlatternTrack track;

        public FlatternPacket(PCMFlatternTrack track, int frameNo, VirtualPacket[] pN, int lead, int dataLen) {
            this.track = track;
            this.frameNo = frameNo;
            this.leading = lead;
            this.pN = pN;
            this.dataLen = dataLen;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer result = ByteBuffer.allocate(this.dataLen);
            ByteBuffer d0 = this.pN[0].getData();
            NIOUtils.skip(d0, this.leading);
            NIOUtils.write(result, d0);
            for (int i = 1; i < this.pN.length && result.hasRemaining(); ++i) {
                ByteBuffer dN = this.pN[i].getData();
                int toWrite = Math.min(dN.remaining(), result.remaining());
                NIOUtils.writeL(result, dN, toWrite);
            }
            result.flip();
            return result;
        }

        @Override
        public int getDataLen() {
            return this.dataLen;
        }

        @Override
        public double getPts() {
            return (double)this.frameNo * (double)this.track.framesPerPkt / (double)this.track.se.getSampleRate();
        }

        @Override
        public double getDuration() {
            return this.track.packetDur;
        }

        @Override
        public boolean isKeyframe() {
            return true;
        }

        @Override
        public int getFrameNo() {
            return this.frameNo;
        }
    }
}

