/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import org.jcodec.codecs.prores.ProresDecoder;
import org.jcodec.codecs.prores.ProresEncoder;
import org.jcodec.codecs.prores.ProresToThumb2x2;
import org.jcodec.codecs.prores.ProresToThumb4x4;
import org.jcodec.common.VideoDecoder;
import org.jcodec.common.model.Size;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.Transcode2AVCTrack;

public class Prores2AVCTrack
extends Transcode2AVCTrack {
    public Prores2AVCTrack(VirtualTrack proresTrack, Size frameDim) {
        super(proresTrack, frameDim);
    }

    @Override
    protected void checkFourCC(VirtualTrack proresTrack) {
        String fourcc = proresTrack.getCodecMeta().getFourcc();
        if ("ap4h".equals(fourcc)) {
            return;
        }
        ProresEncoder.Profile[] values = ProresEncoder.Profile.values();
        for (int i = 0; i < values.length; ++i) {
            ProresEncoder.Profile profile = values[i];
            if (!profile.fourcc.equals(fourcc)) continue;
            return;
        }
        throw new IllegalArgumentException("Input track is not ProRes");
    }

    @Override
    protected int selectScaleFactor(Size frameDim) {
        return frameDim.getWidth() >= 960 ? 2 : (frameDim.getWidth() > 480 ? 1 : 0);
    }

    @Override
    protected VideoDecoder getDecoder(int scaleFactor) {
        switch (scaleFactor) {
            case 2: {
                return new ProresToThumb2x2();
            }
            case 1: {
                return new ProresToThumb4x4();
            }
            case 0: {
                return new ProresDecoder();
            }
        }
        throw new IllegalArgumentException("Unsupported scale factor: " + scaleFactor);
    }
}

