/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.encode.H264FixedRateControl;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.VideoDecoder;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.common.model.Rect;
import org.jcodec.common.model.Size;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VideoCodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.VirtualPacketWrapper;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform8Bit;

public abstract class Transcode2AVCTrack
implements VirtualTrack {
    private static final int TARGET_RATE = 1024;
    private int frameSize;
    protected VirtualTrack src;
    private CodecMeta se;
    private ThreadLocal<Transcoder> transcoders = new ThreadLocal();
    private int mbW;
    private int mbH;
    private int scaleFactor;
    private int thumbWidth;
    private int thumbHeight;

    protected abstract int selectScaleFactor(Size var1);

    protected abstract VideoDecoder getDecoder(int var1);

    protected abstract void checkFourCC(VirtualTrack var1);

    public Transcode2AVCTrack(VirtualTrack src, Size frameDim) {
        this.checkFourCC(src);
        this.src = src;
        H264FixedRateControl rc = new H264FixedRateControl(1024);
        H264Encoder encoder = new H264Encoder(rc);
        this.scaleFactor = this.selectScaleFactor(frameDim);
        this.thumbWidth = frameDim.getWidth() >> this.scaleFactor;
        this.thumbHeight = frameDim.getHeight() >> this.scaleFactor & 0xFFFFFFFE;
        this.mbW = this.thumbWidth + 15 >> 4;
        this.mbH = this.thumbHeight + 15 >> 4;
        this.se = Transcode2AVCTrack.createCodecMeta(src, encoder, this.thumbWidth, this.thumbHeight);
        this.frameSize = rc.calcFrameSize(this.mbW * this.mbH);
        this.frameSize += this.frameSize >> 4;
    }

    public static VideoCodecMeta createCodecMeta(VirtualTrack src, H264Encoder encoder, int thumbWidth, int thumbHeight) {
        VideoCodecMeta codecMeta = (VideoCodecMeta)src.getCodecMeta();
        AvcCBox createAvcC = H264Utils.createAvcC(encoder.initSPS(new Size(thumbWidth, thumbHeight)), encoder.initPPS(), 4);
        return VideoCodecMeta.createVideoCodecMeta("avc1", H264Utils.getAvcCData(createAvcC), new Size(thumbWidth, thumbHeight), codecMeta.getPasp());
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.se;
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        VirtualPacket nextPacket = this.src.nextPacket();
        if (nextPacket == null) {
            return null;
        }
        return new TranscodePacket(this, nextPacket);
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return this.src.getEdits();
    }

    @Override
    public int getPreferredTimescale() {
        return this.src.getPreferredTimescale();
    }

    static class Transcoder {
        private VideoDecoder decoder;
        private H264Encoder encoder;
        private Picture8Bit pic0;
        private Picture8Bit pic1;
        private Transform8Bit transform;
        private H264FixedRateControl rc;
        private Transcode2AVCTrack track;

        public Transcoder(Transcode2AVCTrack track) {
            this.track = track;
            this.rc = new H264FixedRateControl(1024);
            this.decoder = track.getDecoder(track.scaleFactor);
            this.encoder = new H264Encoder(this.rc);
            this.pic0 = Picture8Bit.create(track.mbW << 4, track.mbH + 1 << 4, ColorSpace.YUV444);
        }

        public ByteBuffer transcodeFrame(ByteBuffer src, ByteBuffer dst) throws IOException {
            if (src == null) {
                return null;
            }
            Picture8Bit decoded = this.decoder.decodeFrame8Bit(src, this.pic0.getData());
            if (this.pic1 == null) {
                this.pic1 = Picture8Bit.create(decoded.getWidth(), decoded.getHeight(), this.encoder.getSupportedColorSpaces()[0]);
                this.transform = ColorUtil.getTransform8Bit(decoded.getColor(), this.encoder.getSupportedColorSpaces()[0]);
            }
            this.transform.transform(decoded, this.pic1);
            this.pic1.setCrop(new Rect(0, 0, this.track.thumbWidth, this.track.thumbHeight));
            int rate = 1024;
            while (true) {
                try {
                    this.encoder.encodeFrame8Bit(this.pic1, dst);
                }
                catch (BufferOverflowException ex) {
                    Logger.warn("Abandon frame, buffer too small: " + dst.capacity());
                    this.rc.setRate(rate -= 10);
                    if (rate > 10) continue;
                }
                break;
            }
            this.rc.setRate(1024);
            H264Utils.encodeMOVPacketInplace(dst);
            return dst;
        }
    }

    private static class TranscodePacket
    extends VirtualPacketWrapper {
        private Transcode2AVCTrack track;

        public TranscodePacket(Transcode2AVCTrack track, VirtualPacket nextPacket) {
            super(nextPacket);
            this.track = track;
        }

        @Override
        public int getDataLen() {
            return this.track.frameSize;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            Transcoder t = (Transcoder)this.track.transcoders.get();
            if (t == null) {
                t = new Transcoder(this.track);
                this.track.transcoders.set(t);
            }
            ByteBuffer buf = ByteBuffer.allocate(this.track.frameSize);
            ByteBuffer data = this.src.getData();
            return t.transcodeFrame(data, buf);
        }
    }
}

