/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.jcodec.common.VideoDecoder;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.common.model.Rational;
import org.jcodec.common.model.Rect;
import org.jcodec.common.model.Size;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VideoCodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.VirtualPacketWrapper;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform8Bit;

public abstract class TranscodeTrack
implements VirtualTrack {
    private static final int TARGET_RATE = 1024;
    private int frameSize;
    private VirtualTrack src;
    private CodecMeta se;
    private ThreadLocal<Transcoder> transcoders = new ThreadLocal();
    private int mbW;
    private int mbH;
    private int scaleFactor;
    private int thumbWidth;
    private int thumbHeight;

    protected abstract int getFrameSize(int var1, int var2);

    protected abstract VideoDecoder getDecoder(int var1);

    protected abstract VideoEncoder getEncoder(int var1);

    protected abstract void getCodecPrivate(ByteBuffer var1, Size var2);

    public TranscodeTrack(VirtualTrack proresTrack, Size frameDim) {
        this.src = proresTrack;
        this.scaleFactor = frameDim.getWidth() >= 960 ? 2 : 1;
        this.thumbWidth = frameDim.getWidth() >> this.scaleFactor;
        this.thumbHeight = frameDim.getHeight() >> this.scaleFactor & 0xFFFFFFFE;
        this.mbW = this.thumbWidth + 15 >> 4;
        this.mbH = this.thumbHeight + 15 >> 4;
        Size size = new Size(this.thumbWidth, this.thumbHeight);
        Rational pasp = ((VideoCodecMeta)proresTrack.getCodecMeta()).getPasp();
        ByteBuffer codecPrivate = ByteBuffer.allocate(1024);
        this.getCodecPrivate(codecPrivate, size);
        this.se = VideoCodecMeta.createVideoCodecMeta("avc1", codecPrivate, size, pasp);
        this.frameSize = this.getFrameSize(this.mbW * this.mbH, 1024);
        this.frameSize += this.frameSize >> 4;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.se;
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        VirtualPacket nextPacket = this.src.nextPacket();
        if (nextPacket == null) {
            return null;
        }
        return new TranscodePacket(this, nextPacket);
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return this.src.getEdits();
    }

    @Override
    public int getPreferredTimescale() {
        return this.src.getPreferredTimescale();
    }

    static class Transcoder {
        private VideoDecoder decoder;
        private VideoEncoder[] encoder = new VideoEncoder[3];
        private Picture8Bit pic0;
        private Picture8Bit pic1;
        private Transform8Bit transform;
        private TranscodeTrack track;

        public Transcoder(TranscodeTrack track) {
            this.track = track;
            this.decoder = track.getDecoder(track.scaleFactor);
            this.encoder[0] = track.getEncoder(1024);
            this.encoder[1] = track.getEncoder(921);
            this.encoder[2] = track.getEncoder(819);
            this.pic0 = Picture8Bit.create(track.mbW << 4, track.mbH << 4, ColorSpace.YUV444);
        }

        public ByteBuffer transcodeFrame(ByteBuffer src, ByteBuffer dst) {
            Picture8Bit decoded = this.decoder.decodeFrame8Bit(src, this.pic0.getData());
            if (this.pic1 == null) {
                this.pic1 = Picture8Bit.create(decoded.getWidth(), decoded.getHeight(), ColorSpace.YUV420);
                this.transform = ColorUtil.getTransform8Bit(decoded.getColor(), ColorSpace.YUV420);
            }
            this.transform.transform(decoded, this.pic1);
            this.pic1.setCrop(new Rect(0, 0, this.track.thumbWidth, this.track.thumbHeight));
            for (int i = 0; i < this.encoder.length; ++i) {
                try {
                    dst.clear();
                    VideoEncoder.EncodedFrame out = this.encoder[i].encodeFrame8Bit(this.pic1, dst);
                    break;
                }
                catch (BufferOverflowException ex) {
                    System.out.println("Abandon frame!!!");
                    continue;
                }
            }
            return dst;
        }
    }

    private static class TranscodePacket
    extends VirtualPacketWrapper {
        private TranscodeTrack track;

        public TranscodePacket(TranscodeTrack track, VirtualPacket nextPacket) {
            super(nextPacket);
            this.track = track;
        }

        @Override
        public int getDataLen() {
            return this.track.frameSize;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            Transcoder t = (Transcoder)this.track.transcoders.get();
            if (t == null) {
                t = new Transcoder(this.track);
                this.track.transcoders.set(t);
            }
            ByteBuffer buf = ByteBuffer.allocate(this.track.frameSize);
            ByteBuffer data = this.src.getData();
            return t.transcodeFrame(data, buf);
        }
    }
}

