/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks.avc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.codecs.h264.H264Decoder;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.encode.H264FixedRateControl;
import org.jcodec.codecs.h264.io.model.Frame;
import org.jcodec.codecs.h264.io.model.NALUnit;
import org.jcodec.codecs.h264.io.model.NALUnitType;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VideoCodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.ClipTrack;
import org.jcodec.movtool.streaming.tracks.VirtualPacketWrapper;

public class AVCClipTrack
extends ClipTrack {
    private H264FixedRateControl rc;
    private int mbW;
    private int mbH;
    private VideoCodecMeta se;
    private final int frameSize;
    private SeqParameterSet encSPS;
    private PictureParameterSet encPPS;
    private ByteBuffer codecPrivate;

    public AVCClipTrack(VirtualTrack src, int frameFrom, int frameTo) {
        super(src, frameFrom, frameTo);
        VideoCodecMeta codecMeta = (VideoCodecMeta)src.getCodecMeta();
        if (!"avc1".equals(codecMeta.getFourcc())) {
            throw new RuntimeException("Not an AVC source track");
        }
        this.rc = new H264FixedRateControl(1024);
        H264Encoder encoder = this.getEncoder();
        ByteBuffer codecPrivate = codecMeta.getCodecPrivate();
        codecPrivate.reset();
        this.codecPrivate = codecPrivate;
        List<ByteBuffer> rawSPS = H264Utils.getRawSPS(codecPrivate);
        List<ByteBuffer> rawPPS = H264Utils.getRawPPS(codecPrivate);
        SeqParameterSet sps = H264Utils.readSPS(rawSPS.get(0));
        this.mbW = sps.pic_width_in_mbs_minus1 + 1;
        this.mbH = SeqParameterSet.getPicHeightInMbs(sps);
        this.encSPS = encoder.initSPS(H264Utils.getPicSize(sps));
        this.encSPS.seq_parameter_set_id = 1;
        this.encPPS = encoder.initPPS();
        this.encPPS.seq_parameter_set_id = 1;
        this.encPPS.pic_parameter_set_id = 1;
        this.encSPS.profile_idc = sps.profile_idc;
        this.encSPS.level_idc = sps.level_idc;
        this.encSPS.frame_mbs_only_flag = sps.frame_mbs_only_flag;
        this.encSPS.frame_crop_bottom_offset = sps.frame_crop_bottom_offset;
        this.encSPS.frame_crop_left_offset = sps.frame_crop_left_offset;
        this.encSPS.frame_crop_right_offset = sps.frame_crop_right_offset;
        this.encSPS.frame_crop_top_offset = sps.frame_crop_top_offset;
        this.encSPS.vuiParams = sps.vuiParams;
        rawSPS.add(H264Utils.writeSPS(this.encSPS, 128));
        rawPPS.add(H264Utils.writePPS(this.encPPS, 20));
        this.se = VideoCodecMeta.createVideoCodecMeta("avc1", H264Utils.saveCodecPrivate(rawSPS, rawPPS), codecMeta.getSize(), codecMeta.getPasp());
        int _frameSize = this.rc.calcFrameSize(this.mbW * this.mbH);
        _frameSize += _frameSize >> 4;
        this.frameSize = _frameSize;
    }

    private H264Encoder getEncoder() {
        H264Encoder encoder = new H264Encoder(this.rc);
        encoder.setKeyInterval(1);
        return encoder;
    }

    @Override
    protected List<VirtualPacket> getGop(VirtualTrack src, int from) throws IOException {
        VirtualPacket packet = src.nextPacket();
        ArrayList<VirtualPacket> head = new ArrayList<VirtualPacket>();
        while (packet != null && packet.getFrameNo() < from) {
            if (packet.isKeyframe()) {
                head.clear();
            }
            head.add(packet);
            packet = src.nextPacket();
        }
        ArrayList<VirtualPacket> tail = new ArrayList<VirtualPacket>();
        while (packet != null && !packet.isKeyframe()) {
            tail.add(packet);
            packet = src.nextPacket();
        }
        ArrayList<VirtualPacket> gop = new ArrayList<VirtualPacket>();
        GopTranscoder tr = new GopTranscoder(this, head, tail, this.getEncoder());
        for (int i = 0; i < tail.size(); ++i) {
            gop.add(new TranscodePacket((VirtualPacket)tail.get(i), tr, i, this.frameSize));
        }
        gop.add(packet);
        return gop;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.se;
    }

    public static class TranscodePacket
    extends VirtualPacketWrapper {
        private GopTranscoder tr;
        private int off;
        private int frameSize;

        public TranscodePacket(VirtualPacket src, GopTranscoder tr, int off, int frameSize) {
            super(src);
            this.tr = tr;
            this.off = off;
            this.frameSize = frameSize;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            return NIOUtils.duplicate(this.tr.getResult().get(this.off));
        }

        @Override
        public int getDataLen() throws IOException {
            return this.frameSize;
        }

        @Override
        public boolean isKeyframe() {
            return true;
        }
    }

    public static class GopTranscoder {
        private List<VirtualPacket> tail;
        private List<VirtualPacket> head;
        private List<ByteBuffer> result;
        private AVCClipTrack track;
        private H264Encoder encoder;

        public GopTranscoder(AVCClipTrack track, List<VirtualPacket> head, List<VirtualPacket> tail, H264Encoder encoder) {
            this.track = track;
            this.head = head;
            this.tail = tail;
            this.encoder = encoder;
        }

        public List<ByteBuffer> transcode() throws IOException {
            H264Decoder decoder = H264Decoder.createH264DecoderFromCodecPrivate(this.track.codecPrivate);
            Picture8Bit buf = Picture8Bit.create(this.track.mbW << 4, this.track.mbH << 4, ColorSpace.YUV420J);
            Frame dec = null;
            for (VirtualPacket virtualPacket : this.head) {
                dec = decoder.decodeFrame8Bit(virtualPacket.getData(), buf.getData());
            }
            ByteBuffer tmp = ByteBuffer.allocate(this.track.frameSize);
            ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
            for (VirtualPacket pkt : this.tail) {
                dec = decoder.decodeFrame8Bit(pkt.getData(), buf.getData());
                tmp.clear();
                VideoEncoder.EncodedFrame res = this.encoder.encodeFrame8Bit(dec, tmp);
                ByteBuffer out = ByteBuffer.allocate(this.track.frameSize);
                this.processFrame(res.getData(), out);
                result.add(out);
            }
            return result;
        }

        private void processFrame(ByteBuffer _in, ByteBuffer out) {
            ByteBuffer buf;
            H264Utils.SliceHeaderTweaker st = new H264Utils.SliceHeaderTweaker(){

                @Override
                protected void tweak(SliceHeader sh) {
                    sh.pic_parameter_set_id = 1;
                }
            };
            ByteBuffer dup = _in.duplicate();
            while (dup.hasRemaining() && (buf = H264Utils.nextNALUnit(dup)) != null) {
                NALUnit nu = NALUnit.read(buf);
                if (nu.type != NALUnitType.IDR_SLICE && nu.type != NALUnitType.NON_IDR_SLICE) continue;
                out.putInt(1);
                nu.write(out);
                st.runSpsPps(buf, out, nu, this.track.encSPS, this.track.encPPS);
            }
            if (out.remaining() >= 5) {
                out.putInt(1);
                new NALUnit(NALUnitType.FILLER_DATA, 0).write(out);
            }
            out.clear();
        }

        public synchronized List<ByteBuffer> getResult() throws IOException {
            if (this.result == null) {
                this.result = this.transcode();
            }
            return this.result;
        }
    }
}

