/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks.avc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.io.model.NALUnit;
import org.jcodec.codecs.h264.io.model.NALUnitType;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.Rational;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VideoCodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;

public class AVCConcatTrack
implements VirtualTrack {
    private VirtualTrack[] tracks;
    private int idx = 0;
    private VirtualPacket lastPacket;
    private double offsetPts = 0.0;
    private int offsetFn = 0;
    private CodecMeta se;
    private Map<Integer, Integer> map;
    private List<PictureParameterSet> allPps;
    private List<SeqParameterSet> allSps;
    private H264Utils.SliceHeaderTweaker[] tweakers;

    public AVCConcatTrack(VirtualTrack ... arguments) {
        this.tracks = arguments;
        Rational pasp = null;
        this.allPps = new ArrayList<PictureParameterSet>();
        this.allSps = new ArrayList<SeqParameterSet>();
        this.tweakers = new H264Utils.SliceHeaderTweaker[arguments.length];
        this.map = new HashMap<Integer, Integer>();
        for (int i = 0; i < arguments.length; ++i) {
            CodecMeta se = arguments[i].getCodecMeta();
            if (!(se instanceof VideoCodecMeta)) {
                throw new RuntimeException("Not a video track.");
            }
            if (!"avc1".equals(se.getFourcc())) {
                throw new RuntimeException("Not an AVC track.");
            }
            VideoCodecMeta vcm = (VideoCodecMeta)se;
            Rational paspL = vcm.getPasp();
            if (pasp != null && paspL != null && !pasp.equalsRational(paspL)) {
                throw new RuntimeException("Can not concat video tracks with different Pixel Aspect Ratio.");
            }
            pasp = paspL;
            List<ByteBuffer> rawPPSs = H264Utils.getRawPPS(se.getCodecPrivate());
            for (ByteBuffer byteBuffer : rawPPSs) {
                PictureParameterSet pps = H264Utils.readPPS(NIOUtils.duplicate(byteBuffer));
                pps.pic_parameter_set_id |= i << 8;
                pps.seq_parameter_set_id |= i << 8;
                this.allPps.add(pps);
            }
            List<ByteBuffer> rawSPSs = H264Utils.getRawSPS(se.getCodecPrivate());
            for (ByteBuffer spsBuffer : rawSPSs) {
                SeqParameterSet sps = H264Utils.readSPS(NIOUtils.duplicate(spsBuffer));
                sps.seq_parameter_set_id |= i << 8;
                this.allSps.add(sps);
            }
            int n = i;
            this.tweakers[i] = new AvccTweaker(rawSPSs, rawPPSs, n, this);
        }
        this.mergePS(this.allSps, this.allPps, this.map);
        VideoCodecMeta codecMeta = (VideoCodecMeta)arguments[0].getCodecMeta();
        this.se = VideoCodecMeta.createVideoCodecMeta("avc1", H264Utils.saveCodecPrivate(H264Utils.saveSPS(this.allSps), H264Utils.savePPS(this.allPps)), codecMeta.getSize(), codecMeta.getPasp());
    }

    /*
     * WARNING - void declaration
     */
    private void mergePS(List<SeqParameterSet> allSps, List<PictureParameterSet> allPps, Map<Integer, Integer> map) {
        void var6_11;
        void var6_9;
        ArrayList<ByteBuffer> spsRef = new ArrayList<ByteBuffer>();
        for (SeqParameterSet seqParameterSet : allSps) {
            int spsId = seqParameterSet.seq_parameter_set_id;
            seqParameterSet.seq_parameter_set_id = 0;
            ByteBuffer serial = H264Utils.writeSPS(seqParameterSet, 32);
            int idx = NIOUtils.find(spsRef, serial);
            if (idx == -1) {
                idx = spsRef.size();
                spsRef.add(serial);
            }
            for (PictureParameterSet pps : allPps) {
                if (pps.seq_parameter_set_id != spsId) continue;
                pps.seq_parameter_set_id = idx;
            }
        }
        ArrayList<ByteBuffer> ppsRef = new ArrayList<ByteBuffer>();
        for (PictureParameterSet pps : allPps) {
            int ppsId = pps.pic_parameter_set_id;
            pps.pic_parameter_set_id = 0;
            ByteBuffer serial = H264Utils.writePPS(pps, 128);
            int idx = NIOUtils.find(ppsRef, serial);
            if (idx == -1) {
                idx = ppsRef.size();
                ppsRef.add(serial);
            }
            map.put(ppsId, idx);
        }
        allSps.clear();
        boolean bl = false;
        while (var6_9 < spsRef.size()) {
            SeqParameterSet sps = H264Utils.readSPS((ByteBuffer)spsRef.get((int)var6_9));
            sps.seq_parameter_set_id = var6_9++;
            allSps.add(sps);
        }
        allPps.clear();
        boolean bl2 = false;
        while (var6_11 < ppsRef.size()) {
            PictureParameterSet pps = H264Utils.readPPS((ByteBuffer)ppsRef.get((int)var6_11));
            pps.pic_parameter_set_id = var6_11++;
            allPps.add(pps);
        }
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        while (this.idx < this.tracks.length) {
            VirtualTrack track = this.tracks[this.idx];
            VirtualPacket nextPacket = track.nextPacket();
            if (nextPacket == null) {
                ++this.idx;
                this.offsetPts += this.lastPacket.getPts() + this.lastPacket.getDuration();
                this.offsetFn += this.lastPacket.getFrameNo() + 1;
                continue;
            }
            this.lastPacket = nextPacket;
            return new AVCConcatPacket(this, nextPacket, this.offsetPts, this.offsetFn, this.idx);
        }
        return null;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.se;
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return null;
    }

    @Override
    public int getPreferredTimescale() {
        return this.tracks[0].getPreferredTimescale();
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.tracks.length; ++i) {
            this.tracks[i].close();
        }
    }

    private ByteBuffer patchPacket(int idx2, ByteBuffer data) {
        ByteBuffer out = ByteBuffer.allocate(data.remaining() + 8);
        for (ByteBuffer nal : H264Utils.splitFrame(data)) {
            NALUnit nu = NALUnit.read(nal);
            if (nu.type == NALUnitType.IDR_SLICE || nu.type == NALUnitType.NON_IDR_SLICE) {
                out.putInt(1);
                nu.write(out);
                this.tweakers[idx2].run(nal, out, nu);
                continue;
            }
            Logger.warn("Skipping NAL unit: " + nu.type);
        }
        if (out.remaining() >= 5) {
            out.putInt(1);
            new NALUnit(NALUnitType.FILLER_DATA, 0).write(out);
        }
        out.clear();
        return out;
    }

    public static class AVCConcatPacket
    implements VirtualPacket {
        private VirtualPacket packet;
        private double ptsOffset;
        private int fnOffset;
        private int idx;
        private AVCConcatTrack track;

        public AVCConcatPacket(AVCConcatTrack track, VirtualPacket packet, double ptsOffset, int fnOffset, int idx) {
            this.track = track;
            this.packet = packet;
            this.ptsOffset = ptsOffset;
            this.fnOffset = fnOffset;
            this.idx = idx;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            return this.track.patchPacket(this.idx, this.packet.getData());
        }

        @Override
        public int getDataLen() throws IOException {
            return this.packet.getDataLen() + 8;
        }

        @Override
        public double getPts() {
            return this.ptsOffset + this.packet.getPts();
        }

        @Override
        public double getDuration() {
            return this.packet.getDuration();
        }

        @Override
        public boolean isKeyframe() {
            return this.packet.isKeyframe();
        }

        @Override
        public int getFrameNo() {
            return this.fnOffset + this.packet.getFrameNo();
        }
    }

    private static final class AvccTweaker
    extends H264Utils.SliceHeaderTweaker {
        private final int idx2;
        private AVCConcatTrack track;

        private AvccTweaker(List<ByteBuffer> spsList, List<ByteBuffer> ppsList, int idx2, AVCConcatTrack track) {
            this.sps = H264Utils.readSPSFromBufferList(spsList);
            this.pps = H264Utils.readPPSFromBufferList(ppsList);
            this.idx2 = idx2;
            this.track = track;
        }

        @Override
        protected void tweak(SliceHeader sh) {
            sh.pic_parameter_set_id = (Integer)this.track.map.get(this.idx2 << 8 | sh.pic_parameter_set_id);
        }
    }
}

