/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import org.jcodec.common.model.Picture8Bit;
import org.jcodec.scale.Transform8Bit;

public class Yuv420pToRgb8Bit
implements Transform8Bit {
    @Override
    public final void transform(Picture8Bit src, Picture8Bit dst) {
        int j;
        byte[] y = src.getPlaneData(0);
        byte[] u = src.getPlaneData(1);
        byte[] v = src.getPlaneData(2);
        byte[] data = dst.getPlaneData(0);
        int offLuma = 0;
        int offChroma = 0;
        int stride = dst.getWidth();
        for (int i = 0; i < dst.getHeight() >> 1; ++i) {
            for (int k = 0; k < dst.getWidth() >> 1; ++k) {
                int j2 = k << 1;
                Yuv420pToRgb8Bit.YUV420pToRGB(y[offLuma + j2], u[offChroma], v[offChroma], data, (offLuma + j2) * 3);
                Yuv420pToRgb8Bit.YUV420pToRGB(y[offLuma + j2 + 1], u[offChroma], v[offChroma], data, (offLuma + j2 + 1) * 3);
                Yuv420pToRgb8Bit.YUV420pToRGB(y[offLuma + j2 + stride], u[offChroma], v[offChroma], data, (offLuma + j2 + stride) * 3);
                Yuv420pToRgb8Bit.YUV420pToRGB(y[offLuma + j2 + stride + 1], u[offChroma], v[offChroma], data, (offLuma + j2 + stride + 1) * 3);
                ++offChroma;
            }
            if ((dst.getWidth() & 1) != 0) {
                j = dst.getWidth() - 1;
                Yuv420pToRgb8Bit.YUV420pToRGB(y[offLuma + j], u[offChroma], v[offChroma], data, (offLuma + j) * 3);
                Yuv420pToRgb8Bit.YUV420pToRGB(y[offLuma + j + stride], u[offChroma], v[offChroma], data, (offLuma + j + stride) * 3);
                ++offChroma;
            }
            offLuma += 2 * stride;
        }
        if ((dst.getHeight() & 1) != 0) {
            for (int k = 0; k < dst.getWidth() >> 1; ++k) {
                j = k << 1;
                Yuv420pToRgb8Bit.YUV420pToRGB(y[offLuma + j], u[offChroma], v[offChroma], data, (offLuma + j) * 3);
                Yuv420pToRgb8Bit.YUV420pToRGB(y[offLuma + j + 1], u[offChroma], v[offChroma], data, (offLuma + j + 1) * 3);
                ++offChroma;
            }
            if ((dst.getWidth() & 1) != 0) {
                int j3 = dst.getWidth() - 1;
                Yuv420pToRgb8Bit.YUV420pToRGB(y[offLuma + j3], u[offChroma], v[offChroma], data, (offLuma + j3) * 3);
                ++offChroma;
            }
        }
    }

    public static final void YUV420pToRGB(byte y, byte u, byte v, byte[] data, int off) {
        int c = y + 112;
        int r = 298 * c + 409 * v + 128 >> 8;
        int g = 298 * c - 100 * u - 208 * v + 128 >> 8;
        int b = 298 * c + 516 * u + 128 >> 8;
        data[off] = (byte)(Yuv420pToRgb8Bit.crop(r) - 128);
        data[off + 1] = (byte)(Yuv420pToRgb8Bit.crop(g) - 128);
        data[off + 2] = (byte)(Yuv420pToRgb8Bit.crop(b) - 128);
    }

    private static int crop(int val) {
        return val < 0 ? 0 : (val > 255 ? 255 : val);
    }
}

