/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import org.jcodec.common.model.Picture8Bit;
import org.jcodec.common.tools.MathUtil;
import org.jcodec.scale.Transform8Bit;

public class Yuv422pToRgb8Bit
implements Transform8Bit {
    @Override
    public void transform(Picture8Bit src, Picture8Bit dst) {
        byte[] y = src.getPlaneData(0);
        byte[] u = src.getPlaneData(1);
        byte[] v = src.getPlaneData(2);
        byte[] data = dst.getPlaneData(0);
        int offLuma = 0;
        int offChroma = 0;
        for (int i = 0; i < dst.getHeight(); ++i) {
            for (int j = 0; j < dst.getWidth(); j += 2) {
                Yuv422pToRgb8Bit.YUV444toRGB888(y[offLuma], u[offChroma], v[offChroma], data, offLuma * 3);
                Yuv422pToRgb8Bit.YUV444toRGB888(y[offLuma + 1], u[offChroma], v[offChroma], data, (offLuma + 1) * 3);
                offLuma += 2;
                ++offChroma;
            }
        }
    }

    public static final void YUV444toRGB888(byte y, byte u, byte v, byte[] data, int off) {
        int c = y + 112;
        byte d = u;
        byte e = v;
        int r = 298 * c + 409 * e + 128 >> 8;
        int g = 298 * c - 100 * d - 208 * e + 128 >> 8;
        int b = 298 * c + 516 * d + 128 >> 8;
        data[off] = (byte)(MathUtil.clip(r, 0, 255) - 128);
        data[off + 1] = (byte)(MathUtil.clip(g, 0, 255) - 128);
        data[off + 2] = (byte)(MathUtil.clip(b, 0, 255) - 128);
    }
}

