/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import vtk.vtkFileOutputWindow;

public enum vtkNativeLibrary {
    vtkViewsInfovis("vtkViewsInfovisJava"),
    vtkCommonColor("vtkCommonColorJava"),
    vtkViewsContext2D("vtkViewsContext2DJava"),
    vtkTestingRendering("vtkTestingRenderingJava"),
    vtkRenderingVolumeOpenGL2("vtkRenderingVolumeOpenGL2Java"),
    vtkRenderingLabel("vtkRenderingLabelJava"),
    vtkRenderingLOD("vtkRenderingLODJava"),
    vtkRenderingImage("vtkRenderingImageJava"),
    vtkRenderingContextOpenGL2("vtkRenderingContextOpenGL2Java"),
    vtkIOVeraOut("vtkIOVeraOutJava"),
    vtkIOTecplotTable("vtkIOTecplotTableJava"),
    vtkIOSegY("vtkIOSegYJava"),
    vtkIOParallelXML("vtkIOParallelXMLJava"),
    vtkIOParallel("vtkIOParallelJava"),
    vtkIOPLY("vtkIOPLYJava"),
    vtkIOOggTheora("vtkIOOggTheoraJava"),
    vtkIONetCDF("vtkIONetCDFJava"),
    vtkIOMotionFX("vtkIOMotionFXJava"),
    vtkIOMINC("vtkIOMINCJava"),
    vtkIOLSDyna("vtkIOLSDynaJava"),
    vtkIOInfovis("vtkIOInfovisJava"),
    vtkIOImport("vtkIOImportJava"),
    vtkIOIOSS("vtkIOIOSSJava"),
    vtkIOHDF("vtkIOHDFJava"),
    vtkIOVideo("vtkIOVideoJava"),
    vtkIOMovie("vtkIOMovieJava"),
    vtkIOExportPDF("vtkIOExportPDFJava"),
    vtkIOExportGL2PS("vtkIOExportGL2PSJava"),
    vtkRenderingGL2PSOpenGL2("vtkRenderingGL2PSOpenGL2Java"),
    vtkIOExport("vtkIOExportJava"),
    vtkRenderingVtkJS("vtkRenderingVtkJSJava"),
    vtkIOGeometry("vtkIOGeometryJava"),
    vtkRenderingSceneGraph("vtkRenderingSceneGraphJava"),
    vtkIOExodus("vtkIOExodusJava"),
    vtkIOEnSight("vtkIOEnSightJava"),
    vtkIOCityGML("vtkIOCityGMLJava"),
    vtkIOChemistry("vtkIOChemistryJava"),
    vtkIOCONVERGECFD("vtkIOCONVERGECFDJava"),
    vtkIOCGNSReader("vtkIOCGNSReaderJava"),
    vtkIOAsynchronous("vtkIOAsynchronousJava"),
    vtkIOAMR("vtkIOAMRJava"),
    vtkInteractionImage("vtkInteractionImageJava"),
    vtkImagingStencil("vtkImagingStencilJava"),
    vtkImagingStatistics("vtkImagingStatisticsJava"),
    vtkImagingMorphological("vtkImagingMorphologicalJava"),
    vtkImagingMath("vtkImagingMathJava"),
    vtkImagingFourier("vtkImagingFourierJava"),
    vtkIOSQL("vtkIOSQLJava"),
    vtkGeovisCore("vtkGeovisCoreJava"),
    vtkInfovisLayout("vtkInfovisLayoutJava"),
    vtkViewsCore("vtkViewsCoreJava"),
    vtkInteractionWidgets("vtkInteractionWidgetsJava"),
    vtkRenderingVolume("vtkRenderingVolumeJava"),
    vtkRenderingAnnotation("vtkRenderingAnnotationJava"),
    vtkImagingHybrid("vtkImagingHybridJava"),
    vtkImagingColor("vtkImagingColorJava"),
    vtkInteractionStyle("vtkInteractionStyleJava"),
    vtkFiltersTopology("vtkFiltersTopologyJava"),
    vtkFiltersSelection("vtkFiltersSelectionJava"),
    vtkFiltersSMP("vtkFiltersSMPJava"),
    vtkFiltersProgrammable("vtkFiltersProgrammableJava"),
    vtkFiltersPoints("vtkFiltersPointsJava"),
    vtkFiltersVerdict("vtkFiltersVerdictJava"),
    vtkFiltersParallelImaging("vtkFiltersParallelImagingJava"),
    vtkFiltersImaging("vtkFiltersImagingJava"),
    vtkImagingGeneral("vtkImagingGeneralJava"),
    vtkFiltersHyperTree("vtkFiltersHyperTreeJava"),
    vtkFiltersGeneric("vtkFiltersGenericJava"),
    vtkFiltersFlowPaths("vtkFiltersFlowPathsJava"),
    vtkFiltersAMR("vtkFiltersAMRJava"),
    vtkFiltersParallel("vtkFiltersParallelJava"),
    vtkFiltersTexture("vtkFiltersTextureJava"),
    vtkFiltersModeling("vtkFiltersModelingJava"),
    vtkFiltersHybrid("vtkFiltersHybridJava"),
    vtkDomainsChemistryOpenGL2("vtkDomainsChemistryOpenGL2Java"),
    vtkRenderingOpenGL2("vtkRenderingOpenGL2Java"),
    vtkRenderingUI("vtkRenderingUIJava"),
    vtkDomainsChemistry("vtkDomainsChemistryJava"),
    vtkChartsCore("vtkChartsCoreJava"),
    vtkInfovisCore("vtkInfovisCoreJava"),
    vtkFiltersExtraction("vtkFiltersExtractionJava"),
    vtkIOXML("vtkIOXMLJava"),
    vtkIOXMLParser("vtkIOXMLParserJava"),
    vtkParallelCore("vtkParallelCoreJava"),
    vtkIOLegacy("vtkIOLegacyJava"),
    vtkIOCore("vtkIOCoreJava"),
    vtkFiltersStatistics("vtkFiltersStatisticsJava"),
    vtkImagingSources("vtkImagingSourcesJava"),
    vtkIOImage("vtkIOImageJava"),
    vtkRenderingContext2D("vtkRenderingContext2DJava"),
    vtkRenderingFreeType("vtkRenderingFreeTypeJava"),
    vtkRenderingCore("vtkRenderingCoreJava"),
    vtkFiltersSources("vtkFiltersSourcesJava"),
    vtkImagingCore("vtkImagingCoreJava"),
    vtkFiltersGeometry("vtkFiltersGeometryJava"),
    vtkFiltersGeneral("vtkFiltersGeneralJava"),
    vtkCommonComputationalGeometry("vtkCommonComputationalGeometryJava"),
    vtkFiltersCore("vtkFiltersCoreJava"),
    vtkCommonExecutionModel("vtkCommonExecutionModelJava"),
    vtkCommonDataModel("vtkCommonDataModelJava"),
    vtkCommonSystem("vtkCommonSystemJava"),
    vtkCommonMisc("vtkCommonMiscJava"),
    vtkCommonTransforms("vtkCommonTransformsJava"),
    vtkCommonMath("vtkCommonMathJava"),
    vtkCommonCore("vtkCommonCoreJava");

    private String nativeLibraryName;
    private boolean loaded;

    public static boolean LoadAllNativeLibraries() {
        boolean bl = true;
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
            try {
                vtkNativeLibrary2.LoadLibrary();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return bl;
    }

    public static void LoadNativeLibraries(vtkNativeLibrary ... vtkNativeLibraryArray) {
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibraryArray) {
            vtkNativeLibrary2.LoadLibrary();
        }
    }

    public static void DisableOutputWindow(File file) {
        if (file == null) {
            file = new File("vtkError.txt");
        }
        vtkFileOutputWindow vtkFileOutputWindow2 = new vtkFileOutputWindow();
        vtkFileOutputWindow2.SetFileName(file.getAbsolutePath());
        vtkFileOutputWindow2.SetInstance(vtkFileOutputWindow2);
    }

    private vtkNativeLibrary(String string2) {
        this.nativeLibraryName = string2;
        this.loaded = false;
    }

    public void LoadLibrary() throws UnsatisfiedLinkError {
        if (!this.loaded) {
            if (System.getProperty("vtk.lib.dir") != null) {
                File file = new File(System.getProperty("vtk.lib.dir"));
                vtkNativeLibrary.patchJavaLibraryPath(file.getAbsolutePath());
                File file2 = new File(file, System.mapLibraryName(this.nativeLibraryName));
                if (file2.exists()) {
                    try {
                        Runtime.getRuntime().load(file2.getAbsolutePath());
                        this.loaded = true;
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        unsatisfiedLinkError.printStackTrace();
                    }
                }
            }
            System.loadLibrary(this.nativeLibraryName);
        }
        this.loaded = true;
    }

    public boolean IsLoaded() {
        return this.loaded;
    }

    public String GetLibraryName() {
        return this.nativeLibraryName;
    }

    private static void patchJavaLibraryPath(String string) {
        if (string != null) {
            String string2 = System.getProperty("path.separator");
            String string3 = System.getProperty("java.library.path");
            if (!string3.contains(string)) {
                string3 = string3 + string2 + string;
                System.setProperty("java.library.path", string3);
            }
        }
    }
}

