/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.legend;

import com.google.common.base.Preconditions;
import org.scec.vtk.plugins.Plugin;
import vtk.vtkActor2D;

public class LegendItem {
    private vtkActor2D actor;
    private Plugin source;
    private String title;
    private String imagePath;

    public LegendItem(vtkActor2D actor, Plugin source, String title) {
        Preconditions.checkNotNull((Object)actor, (Object)"Legend actor cannot be null");
        Preconditions.checkNotNull((Object)source, (Object)"Legend source cannot be null");
        this.actor = actor;
        this.source = source;
        this.title = title;
        this.imagePath = null;
    }

    public LegendItem(vtkActor2D actor, Plugin source, String title, String imagePath) {
        Preconditions.checkNotNull((Object)actor, (Object)"Legend actor cannot be null");
        Preconditions.checkNotNull((Object)source, (Object)"Legend source cannot be null");
        this.actor = actor;
        this.source = source;
        this.title = title;
        this.imagePath = imagePath;
    }

    public vtkActor2D getActor() {
        return this.actor;
    }

    public Plugin getSource() {
        return this.source;
    }

    public String getTitle() {
        return this.title;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public String toString() {
        return this.source.getMetadata().getShortName() + ": " + this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

