/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.legend;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.scec.vtk.commons.legend.LegendItem;
import org.scec.vtk.plugins.Plugin;
import vtk.vtkActor2D;
import vtk.vtkColorTransferFunction;
import vtk.vtkImageMapper;
import vtk.vtkImageReader2;
import vtk.vtkJPEGReader;
import vtk.vtkLookupTable;
import vtk.vtkMapper2D;
import vtk.vtkPNGReader;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;
import vtk.vtkTIFFReader;
import vtk.vtkTextActor;

public class LegendUtils {
    public static LegendItem buildColorBarLegend(Plugin source, String title, double x, double y, Color minColor, double minValue, Color maxColor, double maxValue) {
        CPT cpt = new CPT(minValue, maxValue, new Color[]{minColor, maxColor});
        return LegendUtils.buildColorBarLegend(source, cpt, title, x, y);
    }

    public static LegendItem buildColorBarLegend(Plugin source, CPT cpt, String title, double x, double y) {
        int i;
        Preconditions.checkNotNull((Object)cpt, (Object)"CPT cannot be null");
        vtkScalarBarActor scalarBar = new vtkScalarBarActor();
        double minValue = cpt.getMinValue();
        double maxValue = cpt.getMaxValue();
        Color minColor = cpt.getMinColor();
        Color maxColor = cpt.getMaxColor();
        int numTicks = cpt.size() + 1;
        if (title != null && !title.isEmpty()) {
            scalarBar.SetTitle(title);
        }
        scalarBar.SetNumberOfLabels(numTicks);
        vtkLookupTable hue = new vtkLookupTable();
        hue.SetTableRange(minValue, maxValue);
        hue.SetNumberOfColors(256L);
        vtkColorTransferFunction ctf = new vtkColorTransferFunction();
        ctf.SetColorSpaceToRGB();
        for (i = 0; i < cpt.size(); ++i) {
            CPTVal str = (CPTVal)cpt.get(i);
            ctf.AddRGBPoint((double)((float)i / (float)cpt.size()), (double)str.minColor.getRed() / 255.0, (double)str.minColor.getGreen() / 255.0, (double)str.minColor.getBlue() / 255.0);
        }
        ctf.AddRGBPoint(1.0, (double)maxColor.getRed() / 255.0, (double)maxColor.getGreen() / 255.0, (double)maxColor.getBlue() / 255.0);
        hue.Build();
        for (i = 0; i < 256; ++i) {
            double[] color = ctf.GetColor((double)i / 256.0);
            hue.SetTableValue((long)i, color[0], color[1], color[2], 1.0);
        }
        scalarBar.SetLookupTable((vtkScalarsToColors)hue);
        scalarBar.SetOrientationToHorizontal();
        scalarBar.SetWidth(0.4);
        scalarBar.SetHeight(0.07);
        scalarBar.SetPosition(x, y);
        scalarBar.Modified();
        return new LegendItem((vtkActor2D)scalarBar, source, title);
    }

    public static LegendItem buildTextLegend(Plugin source, String text, Font font, Color color, double x, double y) {
        return LegendUtils.buildTextLegend(source, text, font.getFamily(), font.getSize(), color, x, y);
    }

    public static LegendItem buildTextLegend(Plugin source, String text, String fontFamily, int fontSize, Color color, double x, double y) {
        Preconditions.checkNotNull((Object)text, (Object)"Text cannot be null when building text legend");
        vtkTextActor textActor = new vtkTextActor();
        textActor.SetInput(text);
        textActor.SetPosition(x, y);
        textActor.GetTextProperty().SetFontSize(fontSize);
        textActor.GetTextProperty().SetFontFamilyAsString(fontFamily);
        textActor.GetTextProperty().SetColor((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
        textActor.Modified();
        return new LegendItem((vtkActor2D)textActor, source, text);
    }

    public static LegendItem buildImageLegend(Plugin source, File imageFile, double x, double y) throws IOException {
        vtkImageReader2 imageReader = new vtkImageReader2();
        if (imageFile.getName().toLowerCase().endsWith(".jpg") || imageFile.getName().toLowerCase().endsWith(".jpeg")) {
            imageReader = new vtkJPEGReader();
        } else if (imageFile.getName().toLowerCase().endsWith(".png")) {
            imageReader = new vtkPNGReader();
        } else if (imageFile.getName().toLowerCase().endsWith(".tiff")) {
            imageReader = new vtkTIFFReader();
        } else {
            throw new NullPointerException();
        }
        imageReader.SetFileName(imageFile.getAbsolutePath());
        imageReader.Update();
        vtkImageMapper mapper = new vtkImageMapper();
        mapper.SetInputData(imageReader.GetOutput());
        mapper.SetColorWindow(256.0);
        mapper.SetColorLevel(128.0);
        vtkActor2D vtkImage = new vtkActor2D();
        vtkImage.SetMapper((vtkMapper2D)mapper);
        vtkImage.SetPosition(x, y);
        return new LegendItem(vtkImage, source, imageFile.getName(), imageFile.getAbsolutePath());
    }
}

