/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.faults;

import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.params.FaultSurfaceTypeParam;
import org.scec.vtk.commons.opensha.faults.params.GridSpacingFitParam;
import org.scec.vtk.commons.opensha.faults.params.GridSpacingParam;
import org.scec.vtk.commons.opensha.surfaces.FaultSurfaceType;

public abstract class AbstractSimpleFaultDataFaultSection
extends AbstractFaultSection {
    public AbstractSimpleFaultDataFaultSection(String name, int id) {
        super(name, id);
    }

    protected abstract SimpleFaultData getSimpleFaultData(ParameterList var1);

    public RuptureSurface createSurface(ParameterList faultRepresentationParams) {
        SimpleFaultData data = this.getSimpleFaultData(faultRepresentationParams);
        if (data == null) {
            return null;
        }
        AbstractSimpleFaultDataFaultSection.checkHasParam(faultRepresentationParams, "Surface Type");
        FaultSurfaceTypeParam typeParam = (FaultSurfaceTypeParam)faultRepresentationParams.getParameter("Surface Type");
        FaultSurfaceType type = typeParam.getFaultSurfaceType();
        AbstractSimpleFaultDataFaultSection.checkHasParam(faultRepresentationParams, "Grid Spacing");
        GridSpacingParam spacingParam = (GridSpacingParam)faultRepresentationParams.getParameter("Grid Spacing");
        AbstractSimpleFaultDataFaultSection.checkHasParam(faultRepresentationParams, "Fit Grid Spacing Exactly");
        GridSpacingFitParam spacingFitParam = (GridSpacingFitParam)faultRepresentationParams.getParameter("Fit Grid Spacing Exactly");
        if (type == FaultSurfaceType.DEFAULT) {
            type = FaultSurfaceType.STIRLING;
        }
        double spacing = (Double)spacingParam.getValue();
        if (((Boolean)spacingFitParam.getValue()).booleanValue()) {
            if (type == FaultSurfaceType.FRANKEL) {
                return new FrankelGriddedSurface(data, spacing);
            }
            if (type == FaultSurfaceType.STIRLING) {
                return new StirlingGriddedSurface(data, spacing);
            }
            throw new RuntimeException("Unkown fault sufrace type: " + type.getName());
        }
        if (type == FaultSurfaceType.FRANKEL) {
            return new FrankelGriddedSurface(data, spacing, spacing);
        }
        if (type == FaultSurfaceType.STIRLING) {
            return new StirlingGriddedSurface(data, spacing, spacing);
        }
        throw new RuntimeException("Unkown fault sufrace type: " + type.getName());
    }

    public static ParameterList createSimpleFaultDataParams() {
        ParameterList params = new ParameterList();
        params.addParameter((Parameter)new FaultSurfaceTypeParam());
        params.addParameter((Parameter)new GridSpacingParam());
        params.addParameter((Parameter)new GridSpacingFitParam());
        return params;
    }
}

