/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.faults.anim;

import java.awt.Color;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.cpt.CPT;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;

public class AnimMultiColorerWrapper
extends CPTBasedColorer {
    private FaultColorer colorer;
    private String name;

    public AnimMultiColorerWrapper(String name, FaultColorer colorer) {
        super(null, false);
        this.name = name;
        this.setAnimColorer(colorer);
    }

    public void setAnimColorer(FaultColorer colorer) {
        this.colorer = colorer;
        this.fireColorerChangeEvent();
    }

    public String getName() {
        return this.name;
    }

    private boolean isCPTBased() {
        return this.colorer instanceof CPTBasedColorer;
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        throw new UnsupportedOperationException("can't get get value for custom multi colorer");
    }

    @Override
    public CPT getCPT() {
        if (this.isCPTBased()) {
            return ((CPTBasedColorer)this.colorer).getCPT();
        }
        return null;
    }

    @Override
    public void setCPT(CPT cpt) {
        if (this.isCPTBased()) {
            ((CPTBasedColorer)this.colorer).setCPT(cpt);
        }
    }

    @Override
    public boolean isCPTLog() {
        if (this.isCPTBased()) {
            return ((CPTBasedColorer)this.colorer).isCPTLog();
        }
        return false;
    }

    @Override
    public void setCPTLog(boolean newCPTLog) {
        if (this.isCPTBased()) {
            ((CPTBasedColorer)this.colorer).setCPTLog(newCPTLog);
        }
    }

    @Override
    public Color getColor(AbstractFaultSection fault) {
        return this.colorer.getColor(fault);
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.colorer.getColorerParameters();
    }
}

