/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.faults.colorers;

import java.awt.Color;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.cpt.CPT;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.ColorerChangeListener;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;

public abstract class CPTBasedColorer
implements FaultColorer {
    private static final long serialVersionUID = 1L;
    private ColorerChangeListener l;
    private CPT cpt;
    private boolean cptLog;

    public CPTBasedColorer(CPT cpt, boolean cptLog) {
        this.cpt = cpt;
        this.cptLog = cptLog;
    }

    public CPT getCPT() {
        return this.cpt;
    }

    public void setCPT(CPT cpt) {
        this.cpt = cpt;
    }

    public void setCPT(CPT cpt, boolean isLog) {
        this.cpt = cpt;
        this.cptLog = isLog;
    }

    public boolean isCPTLog() {
        return this.cptLog;
    }

    public void setCPTLog(boolean newCPTLog) {
        if (this.cptLog != newCPTLog) {
            this.cptLog = newCPTLog;
            this.cpt = this.cptLog ? this.cpt.asLog10() : this.cpt.asPow10();
        }
    }

    @Override
    public Color getColor(AbstractFaultSection fault) {
        return this.getColorForValue(this.getValue(fault));
    }

    public abstract double getValue(AbstractFaultSection var1);

    public Color getColorForValue(double value) {
        if (this.isCPTLog()) {
            if (value <= 0.0) {
                return this.getCPT().getBelowMinColor();
            }
            value = Math.log10(value);
        }
        return this.getCPT().getColor((float)value);
    }

    @Override
    public ParameterList getColorerParameters() {
        return null;
    }

    @Override
    public void setColorerChangeListener(ColorerChangeListener l) {
        this.l = l;
    }

    protected void fireColorerChangeEvent() {
        if (this.l != null) {
            this.l.colorerChanged(this);
        }
    }

    public int getParamColCount() {
        return 2;
    }

    @Override
    public String getLegendLabel() {
        return this.getName();
    }
}

