/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.faults.faultSectionImpl;

import org.opensha.commons.param.ParameterList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;

public class ObsEqkRupSection
extends AbstractFaultSection {
    private ObsEqkRupture rup;
    private RuptureSurface finiteSurf;

    public ObsEqkRupSection(String name, int id, ObsEqkRupture rup) {
        super(name, id);
        this.rup = rup;
        this.finiteSurf = rup.getRuptureSurface();
        if (this.finiteSurf == null) {
            this.finiteSurf = new PointSurface(rup.getHypocenterLocation());
        }
    }

    public RuptureSurface createSurface(ParameterList faultRepresentationParams) {
        return this.finiteSurf;
    }

    @Override
    public double getSlipRate() {
        return Double.NaN;
    }

    @Override
    public double getAvgRake() {
        return this.rup.getAveRake();
    }

    @Override
    public double getAvgStrike() {
        if (this.finiteSurf == null) {
            return Double.NaN;
        }
        return this.finiteSurf.getAveStrike();
    }

    @Override
    public double getAvgDip() {
        if (this.finiteSurf == null) {
            return Double.NaN;
        }
        try {
            return this.finiteSurf.getAveDip();
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public ObsEqkRupture getRup() {
        return this.rup;
    }
}

