/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.faults.faultSectionImpl;

import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.scec.vtk.commons.opensha.faults.AbstractSimpleFaultDataFaultSection;
import org.scec.vtk.commons.opensha.faults.attributeInterfaces.AseismicityFaultSection;
import org.scec.vtk.commons.opensha.faults.attributeInterfaces.CouplingCoefficientFaultSection;
import org.scec.vtk.commons.opensha.faults.params.AseismicityParam;
import org.scec.vtk.commons.opensha.faults.params.FaultSurfaceTypeParam;
import org.scec.vtk.commons.opensha.faults.params.GridSpacingFitParam;
import org.scec.vtk.commons.opensha.faults.params.GridSpacingParam;
import org.scec.vtk.commons.opensha.surfaces.FaultSurfaceType;

public class PrefDataSection
extends AbstractSimpleFaultDataFaultSection
implements AseismicityFaultSection,
CouplingCoefficientFaultSection {
    private static final long serialVersionUID = 1L;
    private FaultSection prefData;

    public PrefDataSection(FaultSection prefData) {
        this(prefData.getName(), prefData);
    }

    public PrefDataSection(String name, FaultSection prefData) {
        super(name, prefData.getSectionId());
        this.prefData = prefData;
    }

    @Override
    public RuptureSurface createSurface(ParameterList faultRepresentationParams) {
        PrefDataSection.checkHasParam(faultRepresentationParams, "Surface Type");
        FaultSurfaceTypeParam typeParam = (FaultSurfaceTypeParam)faultRepresentationParams.getParameter("Surface Type");
        FaultSurfaceType type = typeParam.getFaultSurfaceType();
        if (type == FaultSurfaceType.DEFAULT) {
            PrefDataSection.checkHasParam(faultRepresentationParams, "Grid Spacing");
            GridSpacingParam spacingParam = (GridSpacingParam)faultRepresentationParams.getParameter("Grid Spacing");
            PrefDataSection.checkHasParam(faultRepresentationParams, "Fit Grid Spacing Exactly");
            GridSpacingFitParam spacingFitParam = (GridSpacingFitParam)faultRepresentationParams.getParameter("Fit Grid Spacing Exactly");
            PrefDataSection.checkHasParam(faultRepresentationParams, "Aseis Reduces Area");
            BooleanParameter aseisParam = (BooleanParameter)faultRepresentationParams.getParameter("Aseis Reduces Area");
            return this.prefData.getFaultSurface(((Double)spacingParam.getValue()).doubleValue(), ((Boolean)spacingFitParam.getValue()).booleanValue(), ((Boolean)aseisParam.getValue()).booleanValue());
        }
        return super.createSurface(faultRepresentationParams);
    }

    @Override
    protected SimpleFaultData getSimpleFaultData(ParameterList faultRepresentationParams) {
        PrefDataSection.checkHasParam(faultRepresentationParams, "Aseis Reduces Area");
        BooleanParameter aseisParam = (BooleanParameter)faultRepresentationParams.getParameter("Aseis Reduces Area");
        return this.prefData.getSimpleFaultData(((Boolean)aseisParam.getValue()).booleanValue());
    }

    @Override
    public double getAvgDip() {
        return this.prefData.getAveDip();
    }

    @Override
    public double getAvgRake() {
        return this.prefData.getAveRake();
    }

    @Override
    public double getAvgStrike() {
        return this.prefData.getFaultTrace().getAveStrike();
    }

    @Override
    public double getSlipRate() {
        return this.prefData.getOrigAveSlipRate();
    }

    public FaultSectionSummary getFaultSectionSummary() {
        return new FaultSectionSummary(this.prefData.getSectionId(), this.prefData.getSectionName());
    }

    public FaultSection getFaultSection() {
        return this.prefData;
    }

    public static ParameterList createPrefDataParams() {
        ParameterList params = AbstractSimpleFaultDataFaultSection.createSimpleFaultDataParams();
        params.addParameter((Parameter)new AseismicityParam());
        return params;
    }

    @Override
    public double getCouplingCoeff() {
        return this.getFaultSection().getCouplingCoeff();
    }

    @Override
    public double getAseismicSlipFactor() {
        return this.getFaultSection().getAseismicSlipFactor();
    }
}

