/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.faults.faultSectionImpl;

import org.opensha.commons.param.ParameterList;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.simulators.SimulatorElement;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;

public class SimulatorElementFault
extends AbstractFaultSection {
    private SimulatorElement element;

    public SimulatorElementFault(SimulatorElement element) {
        super(element.getSectionName() + " (" + element.getID() + ")", element.getID());
        this.element = element;
    }

    public RuptureSurface createSurface(ParameterList faultRepresentationParams) {
        return this.getSurface();
    }

    public RuptureSurface getSurface() {
        return this.element.getSurface();
    }

    public int getParentID() {
        return this.element.getSectionID();
    }

    @Override
    public double getSlipRate() {
        return this.element.getSlipRate() * 1000.0;
    }

    @Override
    public double getAvgRake() {
        if (this.element.getFocalMechanism() != null) {
            return this.element.getFocalMechanism().getRake();
        }
        return Double.NaN;
    }

    @Override
    public double getAvgStrike() {
        if (this.element.getFocalMechanism() != null) {
            return this.element.getFocalMechanism().getStrike();
        }
        return Double.NaN;
    }

    @Override
    public double getAvgDip() {
        if (this.element.getFocalMechanism() != null) {
            return this.element.getFocalMechanism().getDip();
        }
        return Double.NaN;
    }

    @Override
    public String getInfo() {
        String info = super.getInfo() + "\nParent: " + this.element.getSectionName() + " (" + this.element.getSectionID() + ")";
        if (this.element.getFaultID() >= 0) {
            info = info + "\nFault ID: " + this.element.getFaultID();
        }
        return info;
    }

    public SimulatorElement getElement() {
        return this.element;
    }
}

