/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.geoDataSet;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.siteData.impl.SRTM30PlusTopography;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.scec.vtk.tools.Transform;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkDataObject;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolygon;
import vtk.vtkUnsignedCharArray;
import vtk.vtkVertexGlyphFilter;

public class GeoDataSetGeometryGenerator {
    public static vtkActor buildPolygonSurface(GriddedGeoDataSet dataset, CPT cpt) {
        return GeoDataSetGeometryGenerator.buildPolygonSurface(dataset, cpt, false);
    }

    public static vtkActor buildPolygonSurface(GriddedGeoDataSet dataset, CPT cpt, boolean topo) {
        vtkPoints pts = new vtkPoints();
        vtkCellArray polygons = new vtkCellArray();
        vtkUnsignedCharArray colors = new vtkUnsignedCharArray();
        vtkPolyData polydata = new vtkPolyData();
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        vtkActor actor = new vtkActor();
        colors.SetNumberOfComponents(3);
        colors.SetName("Colors");
        int ptCount = 0;
        int width = (int)Math.floor((dataset.getMaxLon() - dataset.getMinLon()) / dataset.getRegion().getLonSpacing()) + 1;
        ArrayList topoVals = null;
        if (topo) {
            try {
                topoVals = new SRTM30PlusTopography().getValues(dataset.getRegion().getNodeList());
                for (int i = 0; i < topoVals.size(); ++i) {
                    topoVals.set(i, (Double)topoVals.get(i) / 1000.0);
                }
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        for (int j = 0; j < dataset.getRegion().getNodeCount() - width - 1; ++j) {
            if ((j + 1) % width == 0) continue;
            Location loc = dataset.getLocation(j + width);
            double z = topo ? (Double)topoVals.get(j + width) : -loc.getDepth();
            double[] currentPoint = Transform.transformLatLonHeight(loc.getLatitude(), loc.getLongitude(), z);
            pts.InsertNextPoint(currentPoint);
            Color color3 = cpt.getColor((float)dataset.get(loc));
            colors.InsertNextTuple3((double)color3.getRed(), (double)color3.getGreen(), (double)color3.getBlue());
            loc = dataset.getLocation(j + width + 1);
            z = topo ? (Double)topoVals.get(j + width + 1) : -loc.getDepth();
            currentPoint = Transform.transformLatLonHeight(loc.getLatitude(), loc.getLongitude(), z);
            pts.InsertNextPoint(currentPoint);
            color3 = cpt.getColor((float)dataset.get(loc));
            colors.InsertNextTuple3((double)color3.getRed(), (double)color3.getGreen(), (double)color3.getBlue());
            loc = dataset.getLocation(j + 1);
            z = topo ? (Double)topoVals.get(j + 1) : -loc.getDepth();
            currentPoint = Transform.transformLatLonHeight(loc.getLatitude(), loc.getLongitude(), z);
            pts.InsertNextPoint(currentPoint);
            color3 = cpt.getColor((float)dataset.get(loc));
            colors.InsertNextTuple3((double)color3.getRed(), (double)color3.getGreen(), (double)color3.getBlue());
            loc = dataset.getLocation(j);
            z = topo ? (Double)topoVals.get(j) : -loc.getDepth();
            currentPoint = Transform.transformLatLonHeight(loc.getLatitude(), loc.getLongitude(), z);
            pts.InsertNextPoint(currentPoint);
            color3 = cpt.getColor((float)dataset.get(loc));
            colors.InsertNextTuple3((double)color3.getRed(), (double)color3.getGreen(), (double)color3.getBlue());
            vtkPolygon polygon = new vtkPolygon();
            polygon.GetPointIds().SetNumberOfIds(4L);
            polygon.GetPointIds().SetId(0L, (long)ptCount);
            polygon.GetPointIds().SetId(1L, (long)(ptCount + 1));
            polygon.GetPointIds().SetId(2L, (long)(ptCount + 2));
            polygon.GetPointIds().SetId(3L, (long)(ptCount + 3));
            polygons.InsertNextCell((vtkCell)polygon);
            ptCount += 4;
        }
        polydata.SetPoints(pts);
        polydata.SetPolys(polygons);
        polydata.GetPointData().AddArray((vtkAbstractArray)colors);
        mapper.SetInputData(polydata);
        mapper.ScalarVisibilityOn();
        mapper.SetScalarModeToUsePointFieldData();
        mapper.SelectColorArray("Colors");
        actor.SetMapper((vtkMapper)mapper);
        actor.GetProperty().SetAmbient(1.0);
        actor.GetProperty().SetSpecular(0.0);
        actor.GetProperty().SetDiffuse(0.0);
        return actor;
    }

    public static vtkActor buildPointSurface(GeoDataSet dataset, CPT cpt, double pointSize) {
        vtkPoints pts = new vtkPoints();
        vtkUnsignedCharArray colors = new vtkUnsignedCharArray();
        vtkPolyData polydata = new vtkPolyData();
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        vtkActor actor = new vtkActor();
        colors.SetNumberOfComponents(3);
        colors.SetName("Colors");
        for (int j = 0; j < dataset.getLocationList().size(); ++j) {
            Location loc = dataset.getLocation(j);
            double[] currentPoint = Transform.transformLatLonHeight(loc.getLatitude(), loc.getLongitude(), loc.getDepth());
            pts.InsertNextPoint(currentPoint);
            Color color3 = cpt.getColor((float)dataset.get(loc));
            colors.InsertNextTuple3((double)color3.getRed(), (double)color3.getGreen(), (double)color3.getBlue());
        }
        polydata.SetPoints(pts);
        polydata.GetPointData().AddArray((vtkAbstractArray)colors);
        vtkVertexGlyphFilter vertexGlyphFilter = new vtkVertexGlyphFilter();
        vertexGlyphFilter.AddInputData((vtkDataObject)polydata);
        vertexGlyphFilter.Update();
        mapper.SetInputConnection(vertexGlyphFilter.GetOutputPort());
        mapper.ScalarVisibilityOn();
        mapper.SetScalarModeToUsePointFieldData();
        mapper.SelectColorArray("Colors");
        actor.SetMapper((vtkMapper)mapper);
        actor.GetProperty().SetAmbient(1.0);
        actor.GetProperty().SetSpecular(0.0);
        actor.GetProperty().SetDiffuse(0.0);
        actor.GetProperty().SetPointSize((float)pointSize);
        return actor;
    }

    public static vtkActor buildPixelSurface(GeoDataSet dataset, CPT cpt, boolean skipNaN) {
        double lonSpacing;
        double latSpacing;
        if (dataset instanceof GriddedGeoDataSet) {
            GriddedGeoDataSet gridded = (GriddedGeoDataSet)dataset;
            latSpacing = gridded.getRegion().getLatSpacing();
            lonSpacing = gridded.getRegion().getLonSpacing();
        } else {
            latSpacing = Double.POSITIVE_INFINITY;
            lonSpacing = Double.POSITIVE_INFINITY;
            for (int i = 0; i < dataset.size(); ++i) {
                Location loc1 = dataset.getLocation(i);
                for (int j = i + 1; j < dataset.size(); ++j) {
                    Location loc2 = dataset.getLocation(j);
                    double latDelta = Math.abs(loc1.getLatitude() - loc2.getLatitude());
                    double lonDelta = Math.abs(loc1.getLongitude() - loc2.getLongitude());
                    latSpacing = Math.min(latSpacing, latDelta);
                    lonSpacing = Math.min(lonDelta, lonDelta);
                }
            }
        }
        return GeoDataSetGeometryGenerator.buildPixelSurface(dataset, cpt, skipNaN, latSpacing, lonSpacing);
    }

    public static vtkActor buildPixelSurface(GeoDataSet dataset, CPT cpt, boolean skipNaN, double latSpacing, double lonSpacing) {
        vtkPoints pts = new vtkPoints();
        vtkCellArray polygons = new vtkCellArray();
        vtkUnsignedCharArray colors = new vtkUnsignedCharArray();
        vtkPolyData polydata = new vtkPolyData();
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        vtkActor actor = new vtkActor();
        colors.SetNumberOfComponents(3);
        colors.SetName("Colors");
        int ptCount = 0;
        double halfLatSpacing = 0.5 * latSpacing;
        double halfLonSpacing = 0.5 * lonSpacing;
        for (int i = 0; i < dataset.size(); ++i) {
            Location center = dataset.getLocation(i);
            double val = dataset.get(i);
            if (skipNaN && Double.isNaN(val)) continue;
            Color color3 = cpt.getColor((float)val);
            double lat = center.getLatitude();
            double lon = center.getLongitude();
            double depth = center.getDepth();
            Location topLeft = new Location(lat + halfLatSpacing, lon - halfLonSpacing, depth);
            double[] currentPoint = Transform.transformLatLonHeight(topLeft.getLatitude(), topLeft.getLongitude(), topLeft.getDepth());
            pts.InsertNextPoint(currentPoint);
            colors.InsertNextTuple3((double)color3.getRed(), (double)color3.getGreen(), (double)color3.getBlue());
            Location topRight = new Location(lat + halfLatSpacing, lon + halfLonSpacing, depth);
            currentPoint = Transform.transformLatLonHeight(topRight.getLatitude(), topRight.getLongitude(), topRight.getDepth());
            pts.InsertNextPoint(currentPoint);
            colors.InsertNextTuple3((double)color3.getRed(), (double)color3.getGreen(), (double)color3.getBlue());
            Location botRight = new Location(lat - halfLatSpacing, lon + halfLonSpacing, depth);
            currentPoint = Transform.transformLatLonHeight(botRight.getLatitude(), botRight.getLongitude(), botRight.getDepth());
            pts.InsertNextPoint(currentPoint);
            colors.InsertNextTuple3((double)color3.getRed(), (double)color3.getGreen(), (double)color3.getBlue());
            Location botLeft = new Location(lat - halfLatSpacing, lon - halfLonSpacing, depth);
            currentPoint = Transform.transformLatLonHeight(botLeft.getLatitude(), botLeft.getLongitude(), botLeft.getDepth());
            pts.InsertNextPoint(currentPoint);
            colors.InsertNextTuple3((double)color3.getRed(), (double)color3.getGreen(), (double)color3.getBlue());
            vtkPolygon polygon = new vtkPolygon();
            polygon.GetPointIds().SetNumberOfIds(4L);
            polygon.GetPointIds().SetId(0L, (long)ptCount);
            polygon.GetPointIds().SetId(1L, (long)(ptCount + 1));
            polygon.GetPointIds().SetId(2L, (long)(ptCount + 2));
            polygon.GetPointIds().SetId(3L, (long)(ptCount + 3));
            polygons.InsertNextCell((vtkCell)polygon);
            ptCount += 4;
        }
        polydata.SetPoints(pts);
        polydata.SetPolys(polygons);
        polydata.GetPointData().AddArray((vtkAbstractArray)colors);
        mapper.SetInputData(polydata);
        mapper.ScalarVisibilityOn();
        mapper.SetScalarModeToUsePointFieldData();
        mapper.SelectColorArray("Colors");
        actor.SetMapper((vtkMapper)mapper);
        actor.GetProperty().SetAmbient(1.0);
        actor.GetProperty().SetSpecular(0.0);
        actor.GetProperty().SetDiffuse(0.0);
        return actor;
    }
}

