/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.geoDataSet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.util.cpt.CPT;
import org.scec.vtk.commons.opensha.geoDataSet.GeoDataSetGeometryGenerator;
import vtk.vtkActor;

public class XYZToColorPalette {
    private static final long serialVersionUID = 1L;
    CPT cpt;
    GriddedRegion region;
    boolean latitudeX;
    GeoDataSet geoDataSet;
    GriddedGeoDataSet griddedGeoDataSet;

    public XYZToColorPalette(CPT cpt, GriddedRegion region, boolean latitudeX) {
        this.cpt = cpt;
        this.region = region;
        this.latitudeX = latitudeX;
        this.griddedGeoDataSet = new GriddedGeoDataSet(region, latitudeX);
    }

    public XYZToColorPalette(String filePath) {
        this.loadCPTFromFile(filePath);
    }

    public GriddedGeoDataSet getGriddedGeoDataSet() {
        return this.griddedGeoDataSet;
    }

    public void loadCPTFromFile(String dataPath) {
        try {
            this.cpt = CPT.loadFromFile((File)new File(dataPath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadFromFileToGriddedGeoDataSet(String dP) {
        System.out.println("Loading file...");
        File file = new File(dP);
        try {
            this.griddedGeoDataSet = GriddedGeoDataSet.loadXYZFile((File)file, (int)1, (int)0, (int)-1, (int)4);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadOpenSHAFileToGriddedGeoDataSet(String dP) {
        System.out.println("Loading file...");
        File file = new File(dP);
        try {
            this.griddedGeoDataSet = GriddedGeoDataSet.loadXYZFile((File)file, (int)0, (int)1, (int)-1, (int)2);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public vtkActor builtPolygonSurface() {
        return GeoDataSetGeometryGenerator.buildPolygonSurface(this.griddedGeoDataSet, this.cpt);
    }

    public CPT getCPT() {
        return this.cpt;
    }
}

