/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.commons.mapping.gmt.gui.CPTPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.GriddedParameterListEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ListUtils;
import org.opensha.commons.util.cpt.CPT;
import org.scec.vtk.commons.legend.LegendItem;
import org.scec.vtk.commons.legend.LegendUtils;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.colorers.ColorerChangeListener;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.faults.colorers.SlipRateColorer;
import org.scec.vtk.commons.opensha.tree.gui.FaultTreeTable;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.utils.components.ColorButton;
import org.scec.vtk.plugins.utils.components.ShowButton;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;
import vtk.vtkActor2D;

public class ColorerPanel
extends JPanel
implements ParameterChangeListener,
ActionListener,
ColorerChangeListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<ColorerChangeListener> listeners = new ArrayList();
    private static final String COLORER_SELECTOR_PARAM_NAME = "Color Faults By";
    public static final String COLORER_SELECTOR_CUSTOM = "(custom)";
    private Plugin plugin;
    private StringParameter colorerParam;
    private List<FaultColorer> colorers;
    private JButton browseButton = new JButton("Load CPT");
    private JButton rescaleButton = new JButton("Rescale CPT");
    private ShowButton visibilityButton = new ShowButton(this, "Visibility");
    private ColorButton colorButton = new ColorButton(this, "Colors");
    private JCheckBox logCheck = new JCheckBox("Log10 Scale");
    private JCheckBox legendCheckbox = new JCheckBox("Add Legend");
    private JFileChooser chooser;
    private SingleColorChooser colorChooser = new SingleColorChooser(this);
    private FaultTreeTable faultTable;
    private CPTPanel cptPanel;
    private ParameterListEditor rangeSelectEditor;
    private DoubleParameter rangeSelectMin;
    private DoubleParameter rangeSelectMax;
    private static int cpt_width = 350;
    private static int cpt_height = 70;
    private static int cpt_image_width = 300;
    private static int cpt_image_height = 20;
    private static int cpt_num_ticks = -1;
    private static int cpt_tick_width = 4;
    private GriddedParameterListEditor paramsEdit;
    private LegendItem legend;

    public ColorerPanel(Plugin plugin, List<FaultColorer> colorers, FaultColorer selected) {
        this.plugin = plugin;
        this.colorers = colorers;
        for (FaultColorer colorer : colorers) {
            colorer.setColorerChangeListener(this);
        }
        ArrayList names = ListUtils.getNamesList(colorers);
        names.add(COLORER_SELECTOR_CUSTOM);
        String selectedName = selected == null ? COLORER_SELECTOR_CUSTOM : selected.getName();
        this.colorerParam = new StringParameter(COLORER_SELECTOR_PARAM_NAME, names, selectedName);
        this.colorerParam.addParameterChangeListener((ParameterChangeListener)this);
        this.browseButton.addActionListener(this);
        this.rescaleButton.addActionListener(this);
        this.logCheck.addActionListener(this);
        this.setLayout(new BoxLayout(this, 1));
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new BoxLayout(selectPanel, 0));
        selectPanel.add(this.colorerParam.getEditor().getComponent());
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        this.legendCheckbox.addActionListener(this);
        JPanel wrapperPanel = new JPanel();
        wrapperPanel.setLayout(new BoxLayout(wrapperPanel, 1));
        wrapperPanel.add(this.logCheck);
        wrapperPanel.add(this.legendCheckbox);
        controlPanel.add(wrapperPanel);
        controlPanel.add(this.visibilityButton);
        controlPanel.add(this.colorButton);
        this.visibilityButton.setEnabled(true);
        this.colorButton.setEnabled(true);
        controlPanel.add(this.rescaleButton);
        controlPanel.add(this.browseButton);
        this.cptPanel = new CPTPanel(null, cpt_width, cpt_image_width, cpt_image_height, cpt_tick_width);
        this.cptPanel.setDecimalFormat(new DecimalFormat("0.###"));
        Dimension cptDims = new Dimension(cpt_width, cpt_height);
        this.cptPanel.setSize(cptDims);
        this.cptPanel.setMinimumSize(cptDims);
        this.cptPanel.setPreferredSize(cptDims);
        this.add(selectPanel);
        this.add(controlPanel);
        JPanel cptPanelWrapper = new JPanel();
        cptPanelWrapper.add((Component)this.cptPanel);
        this.add(cptPanelWrapper);
        ParameterList rangeSelectList = new ParameterList();
        this.rangeSelectMin = new DoubleParameter("Min");
        this.rangeSelectMax = new DoubleParameter("Max");
        rangeSelectList.addParameter((Parameter)this.rangeSelectMin);
        rangeSelectList.addParameter((Parameter)this.rangeSelectMax);
        this.rangeSelectEditor = new ParameterListEditor(rangeSelectList);
        this.rangeSelectEditor.setName("Select Range");
        this.updateForCPT();
    }

    public void setFaultTable(FaultTreeTable faultTable) {
        this.faultTable = faultTable;
    }

    public void addColorerChangeListener(ColorerChangeListener l) {
        this.listeners.add(l);
    }

    public boolean removeColorerChangeListener(ColorerChangeListener l) {
        return this.listeners.remove(l);
    }

    public FaultColorer getSelectedColorer() {
        String selected = (String)this.colorerParam.getValue();
        if (selected.equals(COLORER_SELECTOR_CUSTOM)) {
            return null;
        }
        return this.colorers.get(ListUtils.getIndexByName(this.colorers, (String)selected));
    }

    public List<FaultColorer> getColorers() {
        return Collections.unmodifiableList(this.colorers);
    }

    public void setSelectedColorer(FaultColorer colorer) {
        if (colorer == null) {
            this.colorerParam.setValue((Object)COLORER_SELECTOR_CUSTOM);
        } else {
            this.colorerParam.setValue((Object)colorer.getName());
        }
        this.colorerParam.getEditor().refreshParamEditor();
    }

    private boolean isCPTBasedSelected() {
        FaultColorer selected = this.getSelectedColorer();
        if (selected == null) {
            return false;
        }
        return selected instanceof CPTBasedColorer;
    }

    private void updateForCPT() {
        CPT cpt;
        boolean cptBased = this.isCPTBasedSelected();
        FaultColorer selected = this.getSelectedColorer();
        int paramCols = -1;
        if (cptBased) {
            paramCols = ((CPTBasedColorer)selected).getParamColCount();
        }
        if (paramCols < 1) {
            paramCols = 2;
        }
        if (selected == null) {
            if (this.paramsEdit != null) {
                this.remove((Component)this.paramsEdit);
                this.paramsEdit = null;
            }
        } else {
            ParameterList oldParams;
            ParameterList newParams = selected.getColorerParameters();
            ParameterList parameterList = oldParams = this.paramsEdit == null ? null : this.paramsEdit.getParameterList();
            if (newParams != oldParams || oldParams == null) {
                if (this.paramsEdit != null) {
                    this.remove((Component)this.paramsEdit);
                    this.paramsEdit = null;
                }
                if (newParams != null && newParams.size() > 0) {
                    this.paramsEdit = new GriddedParameterListEditor(selected.getColorerParameters(), paramCols);
                    this.add((Component)this.paramsEdit);
                }
                this.repaint();
            }
        }
        if (cptBased) {
            CPTBasedColorer cptColor = (CPTBasedColorer)selected;
            this.logCheck.setSelected(cptColor.isCPTLog());
            cpt = cptColor.getCPT();
        } else {
            cpt = null;
            cptBased = false;
        }
        this.browseButton.setEnabled(cptBased);
        this.rescaleButton.setEnabled(cptBased);
        this.logCheck.setEnabled(cptBased);
        this.cptPanel.setEnabled(cptBased);
        if (cptBased) {
            this.cptPanel.update(cpt, cpt_image_width, cpt_image_height, cpt_num_ticks, cpt_tick_width);
        } else {
            this.cptPanel.updateCPT(null);
        }
        this.legendCheckbox.setEnabled(cptBased);
        this.cptPanel.repaint();
        this.updateLegendIfVisible();
    }

    public void cptChangedExternally() {
        this.updateForCPT();
        this.fireColorerChangeEvent();
    }

    public void fireColorerChangeEvent() {
        for (ColorerChangeListener l : this.listeners) {
            l.colorerChanged(this.getSelectedColorer());
        }
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.colorerParam) {
            this.updateForCPT();
            this.fireColorerChangeEvent();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseButton) {
            int retVal;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
                String s = File.separator;
                try {
                    File defaultDir = new File(MainGUI.getCWD(), "data");
                    if (defaultDir.exists()) {
                        this.chooser.setCurrentDirectory(defaultDir);
                    }
                }
                catch (Exception defaultDir) {
                    // empty catch block
                }
            }
            if ((retVal = this.chooser.showOpenDialog(this)) == 0) {
                File selectedFile = this.chooser.getSelectedFile();
                try {
                    CPT cpt = CPT.loadFromFile((File)selectedFile);
                    CPTBasedColorer colorer = (CPTBasedColorer)this.getSelectedColorer();
                    int ret = JOptionPane.showConfirmDialog(this, "Is this CPT file already in Log10 Space?", "Log10 CPT?", 0);
                    boolean cptLog = ret == 0;
                    colorer.setCPT(cpt, cptLog);
                    this.updateForCPT();
                    this.fireColorerChangeEvent();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    String title = "Error loading CPT";
                    String msg = "The selected CPT file\ncouldn't be loaded!";
                    JOptionPane.showMessageDialog(this, msg, title, 0);
                }
            }
        } else if (e.getSource() == this.rescaleButton) {
            CPTBasedColorer colorer = (CPTBasedColorer)this.getSelectedColorer();
            CPT newCPT = this.showRescaleDialog(colorer);
            colorer.setCPT(newCPT);
            this.updateForCPT();
            this.fireColorerChangeEvent();
        } else if (e.getSource() == this.logCheck) {
            CPTBasedColorer colorer = (CPTBasedColorer)this.getSelectedColorer();
            boolean log = this.logCheck.isSelected();
            CPT cpt = colorer.getCPT();
            while (log && cpt != null && cpt.getMinValue() <= 0.0f) {
                JOptionPane.showMessageDialog(this, "The currently selected CPT has values <= 0.\nPlease rescale such that all values are >0.", "Invalid CPT for Log Scaling", 1);
                cpt = this.showRescaleDialog(colorer);
            }
            colorer.setCPT(cpt);
            colorer.setCPTLog(log);
            this.updateForCPT();
            this.fireColorerChangeEvent();
        } else if (e.getSource() == this.visibilityButton && this.faultTable != null) {
            this.faultTable.toggleSelectedVisibility();
        } else if (e.getSource() == this.colorButton && this.faultTable != null) {
            Color color = this.colorChooser.getColor();
            if (color != null) {
                this.faultTable.setColorForSelected(color);
            }
        } else if (e.getSource() == this.legendCheckbox) {
            if (this.legendCheckbox.isSelected()) {
                if (this.legendCheckbox.isEnabled()) {
                    this.addLegendScalarBar();
                }
            } else {
                this.removeLegend();
            }
        }
    }

    private CPT showRescaleDialog(CPTBasedColorer colorer) {
        CPT cpt = colorer.getCPT();
        double min = cpt.getMinValue();
        double max = cpt.getMaxValue();
        this.rangeSelectMin.setValue(min);
        this.rangeSelectMin.getEditor().refreshParamEditor();
        this.rangeSelectMax.setValue(max);
        this.rangeSelectMax.getEditor().refreshParamEditor();
        boolean first = true;
        while (first || min >= max) {
            int selection;
            if (!first) {
                JOptionPane.showMessageDialog(this, "min cannot be >= max!", "Error", 0);
            }
            if ((selection = JOptionPane.showConfirmDialog(this, this.rangeSelectEditor, this.rangeSelectEditor.getTitle(), 2)) != 0) {
                return cpt;
            }
            min = (Double)this.rangeSelectMin.getValue();
            max = (Double)this.rangeSelectMax.getValue();
            first = false;
        }
        return cpt.rescale(min, max);
    }

    public static void main(String[] args) throws IOException {
        SlipRateColorer slip = new SlipRateColorer();
        ArrayList<FaultColorer> colorers = new ArrayList<FaultColorer>();
        colorers.add(slip);
        ColorerPanel cp = new ColorerPanel(null, colorers, slip);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 200);
        frame.setContentPane(cp);
        frame.setVisible(true);
    }

    @Override
    public void colorerChanged(FaultColorer newColorer) {
        this.updateForCPT();
        this.fireColorerChangeEvent();
    }

    private void updateLegendIfVisible() {
        if (this.legendCheckbox.isSelected() && this.legendCheckbox.isEnabled()) {
            this.addLegendScalarBar();
        }
    }

    private void addLegendScalarBar() {
        PluginActors actors = this.plugin.getPluginActors();
        vtkActor2D prevActor = null;
        double x = 0.05;
        double y = 0.05;
        if (this.legend != null) {
            prevActor = this.legend.getActor();
            double[] position = prevActor.GetPosition();
            x = position[0];
            y = position[1];
            actors.removeLegend(this.legend);
        }
        FaultColorer fc = this.getSelectedColorer();
        CPTBasedColorer cptColor = (CPTBasedColorer)fc;
        CPT cpt = cptColor.getCPT();
        String title = fc.getLegendLabel();
        if (title == null) {
            title = (String)this.colorerParam.getValue();
        }
        this.legend = LegendUtils.buildColorBarLegend(this.plugin, cpt, title, x, y);
        if (prevActor != null) {
            vtkActor2D newActor = this.legend.getActor();
            newActor.SetWidth(prevActor.GetWidth());
            newActor.SetHeight(prevActor.GetHeight());
            newActor.GetProperty().SetColor(prevActor.GetProperty().GetColor());
        }
        actors.addLegend(this.legend);
        MainGUI.updateRenderWindow();
    }

    private void removeLegend() {
        if (this.legend != null) {
            this.plugin.getPluginActors().removeLegend(this.legend);
            MainGUI.updateRenderWindow();
        }
    }

    public boolean isLegendVisible() {
        return this.legendCheckbox.isSelected();
    }

    public void setLegendVisible(boolean visible) {
        if (visible != this.legendCheckbox.isSelected()) {
            this.legendCheckbox.setSelected(visible);
            if (visible) {
                this.updateLegendIfVisible();
            } else {
                this.removeLegend();
            }
        }
    }
}

