/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.ColorerChangeListener;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.gui.ColorerPanel;
import org.scec.vtk.commons.opensha.gui.GeometryTypeSelectorPanel;
import org.scec.vtk.commons.opensha.gui.anim.AnimationListener;
import org.scec.vtk.commons.opensha.gui.dist.VisibleFaultSurfacesProvider;
import org.scec.vtk.commons.opensha.surfaces.FaultActorBundle;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionActorList;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionBundledActorList;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.commons.opensha.surfaces.events.GeometryGeneratorChangeListener;
import org.scec.vtk.commons.opensha.surfaces.events.GeometrySettingsChangeListener;
import org.scec.vtk.commons.opensha.surfaces.events.GeometrySettingsChangedEvent;
import org.scec.vtk.commons.opensha.surfaces.pickBehavior.FaultSectionPickBehavior;
import org.scec.vtk.commons.opensha.tree.AbstractFaultNode;
import org.scec.vtk.commons.opensha.tree.FaultSectionNode;
import org.scec.vtk.commons.opensha.tree.events.ColorChangeListener;
import org.scec.vtk.commons.opensha.tree.events.CustomColorSelectionListener;
import org.scec.vtk.commons.opensha.tree.events.TreeChangeListener;
import org.scec.vtk.commons.opensha.tree.events.VisibilityChangeListener;
import org.scec.vtk.commons.opensha.tree.gui.FaultTreeTable;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.tools.picking.PointPickEnabledActor;
import vtk.vtkActor;
import vtk.vtkProp;

public class EventManager
implements GeometrySettingsChangeListener,
GeometryGeneratorChangeListener,
ColorChangeListener,
ColorerChangeListener,
CustomColorSelectionListener,
VisibilityChangeListener,
TreeChangeListener,
ParameterChangeListener,
VisibleFaultSurfacesProvider,
AnimationListener {
    private static final boolean D = false;
    private static final boolean queue_renders = true;
    private PluginActors pluginActors;
    private HashMap<AbstractFaultSection, FaultSectionActorList> actorsMap = new HashMap();
    private HashMap<AbstractFaultSection, Surface3D> surfaces = new HashMap();
    private HashMap<AbstractFaultSection, FaultSectionNode> nodes = new HashMap();
    private HashMap<Integer, AbstractFaultSection> idSectionsMap = new HashMap();
    private ColorerPanel colorerPanel;
    private GeometryGenerator geomGen;
    private ParameterList faultParams;
    private Color defaultFaultColor;
    private FaultSectionPickBehavior pickBehavior;
    private LockableUI panelLock;
    private Thread currentCalcThread;
    private long lastRequestedRender = Long.MIN_VALUE;
    private long lastCompletedRender = Long.MIN_VALUE;

    public EventManager(PluginActors pluginActors, FaultTreeTable table, ColorerPanel colorerPanel, GeometryTypeSelectorPanel geomPanel, ParameterList faultParams, Color defaultFaultColor, FaultSectionPickBehavior pickBehavior, LockableUI panelLock, FaultSectionPickBehavior pick) {
        this.pluginActors = pluginActors;
        this.defaultFaultColor = defaultFaultColor;
        this.pickBehavior = pickBehavior;
        this.panelLock = panelLock;
        this.colorerPanel = colorerPanel;
        if (colorerPanel != null) {
            colorerPanel.addColorerChangeListener(this);
            colorerPanel.setFaultTable(table);
        }
        table.addTreeChangeListener(this);
        table.getRowModel().setCustomColorListener(this);
        this.treeChanged(table.getTreeRoot());
        this.geomGen = geomPanel.getSelectedGeomGen();
        for (GeometryGenerator geomGen : geomPanel.getAllGeomGens()) {
            geomGen.addPlotSettingsChangeListener(this);
        }
        geomPanel.addGeometryGeneratorChangeListener(this);
        if (faultParams != null) {
            for (Parameter param : faultParams) {
                param.addParameterChangeListener((ParameterChangeListener)this);
            }
            this.faultParams = faultParams;
        }
    }

    private Surface3D getBuildSurface(AbstractFaultSection fault) {
        Surface3D surface = this.surfaces.get(fault);
        if (surface == null) {
            surface = fault.createSurface(this.faultParams);
            Preconditions.checkNotNull((Object)surface, (Object)"Surface cannot be null!");
            this.surfaces.put(fault, surface);
        }
        return surface;
    }

    private GeometryGenerator getGeomGen(AbstractFaultSection fault) {
        GeometryGenerator geomGen = fault.getCustomGeometryGenerator();
        if (geomGen == null) {
            geomGen = this.geomGen;
        }
        return geomGen;
    }

    private FaultSectionActorList getBuildActors(AbstractFaultSection fault) {
        FaultSectionActorList actors = this.actorsMap.get(fault);
        if (actors == null) {
            FaultSectionNode node = this.nodes.get(fault);
            Surface3D surface = this.getBuildSurface(fault);
            if (surface == null) {
                return null;
            }
            Color color = node.getColor();
            if (color == null) {
                color = this.defaultFaultColor;
            }
            GeometryGenerator geomGen = this.getGeomGen(fault);
            actors = geomGen.createFaultActors(surface, color, fault);
            this.actorsMap.put(fault, actors);
        }
        return actors;
    }

    private void unCacheBranch(AbstractFaultSection fault) {
        PointPickEnabledActor<AbstractFaultSection> actor;
        FaultSectionActorList actors = this.actorsMap.remove(fault);
        for (vtkActor actor2 : actors) {
            if (!this.isActorDisplayed(actor2)) continue;
            this.pluginActors.removeActor((vtkProp)actor2);
        }
        if (actors instanceof FaultSectionBundledActorList && this.isActorDisplayed(actor = ((FaultSectionBundledActorList)actors).getBundle().getActor())) {
            this.pluginActors.removeActor((vtkProp)actor);
        }
        this.updateViewer();
    }

    private void rebuildAllVisibleFaults() {
        for (FaultSectionNode node : this.nodes.values()) {
            AbstractFaultSection fault = node.getFault();
            FaultSectionActorList actors = this.actorsMap.get(fault);
            if (actors != null) {
                this.unCacheBranch(fault);
                if (!node.isVisible()) continue;
                this.displayFault(fault, false);
                continue;
            }
            if (!node.isVisible()) continue;
            this.getBuildActors(fault);
            this.displayFault(fault, false);
        }
        this.updateViewer();
        System.gc();
    }

    private boolean isActorDisplayed(vtkActor actor) {
        return this.pluginActors.containsActor((vtkProp)actor);
    }

    private void displayFault(AbstractFaultSection fault, boolean updateViewer) {
        FaultSectionActorList actors = this.getBuildActors(fault);
        this.displayActors(actors, updateViewer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayActors(FaultSectionActorList actors, boolean updateViewer) {
        for (vtkActor actor : actors) {
            actor.SetVisibility(1);
            actor.SetPickable(1);
            if (this.isActorDisplayed(actor)) {
                actor.Modified();
                continue;
            }
            this.pluginActors.addActor((vtkProp)actor);
        }
        if (actors instanceof FaultSectionBundledActorList) {
            FaultActorBundle bundle;
            FaultSectionBundledActorList bundleList = (FaultSectionBundledActorList)actors;
            FaultActorBundle faultActorBundle = bundle = bundleList.getBundle();
            synchronized (faultActorBundle) {
                PointPickEnabledActor<AbstractFaultSection> actor = bundle.getActor();
                Preconditions.checkNotNull(actor);
                actor.SetVisibility(1);
                this.setBundledOpacity(bundleList, true);
                if (this.isActorDisplayed(actor)) {
                    actor.Modified();
                } else {
                    this.pluginActors.addActor((vtkProp)actor);
                }
            }
        }
        if (updateViewer) {
            this.updateViewer();
        }
    }

    public synchronized void updateViewer() {
        long curTime = System.nanoTime();
        if (curTime > this.lastRequestedRender) {
            this.lastRequestedRender = curTime;
        }
        RenderRunnable updateRunnable = new RenderRunnable();
        SwingUtilities.invokeLater(updateRunnable);
    }

    public static void flushRenders() {
        Preconditions.checkState((!SwingUtilities.isEventDispatchThread() ? 1 : 0) != 0, (Object)"You just tried to deadlock me! Flush must be called outside of the event dispatch thread.");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideFault(AbstractFaultSection fault) {
        FaultSectionActorList actors = this.actorsMap.get(fault);
        if (actors == null) {
            return;
        }
        for (vtkActor actor : actors) {
            actor.SetVisibility(0);
            actor.SetPickable(0);
            actor.Modified();
        }
        if (actors instanceof FaultSectionBundledActorList) {
            FaultActorBundle bundle;
            FaultSectionBundledActorList bundleList = (FaultSectionBundledActorList)actors;
            FaultActorBundle faultActorBundle = bundle = bundleList.getBundle();
            synchronized (faultActorBundle) {
                PointPickEnabledActor<AbstractFaultSection> actor = bundle.getActor();
                Preconditions.checkNotNull(actor);
                actor.SetVisibility(1);
                this.setBundledOpacity(bundleList, false);
                actor.Modified();
            }
        }
        this.updateViewer();
    }

    private void setBundledOpacity(FaultSectionBundledActorList bundleList, boolean visible) {
        FaultActorBundle bundle = bundleList.getBundle();
        bundle.setVisible(bundleList, visible);
        if (visible) {
            bundle.getActor().SetVisibility(1);
            bundle.getActor().SetPickable(1);
        } else if (!bundle.areAnyPointVisible()) {
            bundle.getActor().SetVisibility(0);
            bundle.getActor().SetPickable(0);
        }
    }

    @Override
    public void geometryGeneratorChanged(GeometryGenerator geomGen) {
        if (this.geomGen != null) {
            this.geomGen.clearBundles();
        }
        this.geomGen = geomGen;
        this.rebuildAllVisibleFaults();
    }

    @Override
    public void geometrySettingsChanged(GeometrySettingsChangedEvent e) {
        this.rebuildAllVisibleFaults();
    }

    @Override
    public void colorChanged(AbstractFaultSection fault, Color newColor) {
        if (newColor == null) {
            this.hideFault(fault);
            return;
        }
        FaultSectionActorList actors = this.actorsMap.get(fault);
        if (actors != null) {
            FaultSectionNode node;
            boolean success;
            try {
                success = this.getGeomGen(fault).updateColor(actors, newColor);
            }
            catch (Exception e) {
                System.out.println("Warning: excpetion updating color: " + String.valueOf(e));
                success = false;
            }
            if (!success) {
                this.unCacheBranch(fault);
            }
            if ((node = this.nodes.get(fault)).isVisible()) {
                this.displayFault(fault, true);
            }
        }
    }

    private void lockGUI() {
        this.panelLock.setLocked(true);
    }

    private void unlockGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    EventManager.this.panelLock.setLocked(false);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    System.out.println("TODO: NPE unlocking panel");
                }
            }
        });
    }

    @Override
    public synchronized void colorerChanged(FaultColorer newColorer) {
        if (this.pickBehavior != null) {
            this.pickBehavior.setColorer(null);
        }
        if (newColorer != null) {
            if (this.currentCalcThread != null && this.currentCalcThread.isAlive()) {
                try {
                    this.currentCalcThread.join();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.lockGUI();
            this.currentCalcThread = new ColorChangeThread(newColorer);
            this.currentCalcThread.start();
        }
    }

    public void waitOnCalcThread() throws InterruptedException {
        if (this.currentCalcThread != null && this.currentCalcThread.isAlive()) {
            this.currentCalcThread.join();
        }
    }

    @Override
    public void customColorSelected() {
        if (this.colorerPanel != null) {
            this.colorerPanel.setSelectedColorer(null);
        }
    }

    @Override
    public void visibilityChanged(AbstractFaultSection fault, boolean newVisibility) {
        if (newVisibility) {
            this.displayFault(fault, true);
        } else {
            this.hideFault(fault);
        }
    }

    @Override
    public void treeChanged(TreeNode newRoot) {
        for (AbstractFaultSection fault : new ArrayList<AbstractFaultSection>(this.actorsMap.keySet())) {
            this.unCacheBranch(fault);
        }
        if (this.geomGen != null) {
            this.geomGen.clearBundles();
        }
        this.nodes.clear();
        this.idSectionsMap.clear();
        this.actorsMap.clear();
        this.surfaces.clear();
        System.gc();
        FaultColorer colorer = this.colorerPanel == null ? null : this.colorerPanel.getSelectedColorer();
        if (this.pickBehavior != null) {
            this.pickBehavior.setColorer(colorer);
        }
        this.processAllChildren(newRoot, colorer);
        this.rebuildAllVisibleFaults();
    }

    private void processAllChildren(TreeNode node, FaultColorer colorer) {
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            if (child instanceof FaultSectionNode) {
                FaultSectionNode faultNode = (FaultSectionNode)child;
                AbstractFaultSection fault = faultNode.getFault();
                if (colorer == null) {
                    faultNode.setColor(this.defaultFaultColor);
                } else {
                    faultNode.setColor(colorer.getColor(fault));
                }
                faultNode.setColorChangeListener(this);
                faultNode.setVisibilityChangeListener(this);
                this.nodes.put(fault, faultNode);
                this.idSectionsMap.put(fault.getId(), fault);
            }
            this.processAllChildren(child, colorer);
        }
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (this.faultParams != null && this.faultParams.containsParameter(event.getParameterName())) {
            this.surfaces.clear();
            this.rebuildAllVisibleFaults();
        }
    }

    @Override
    public HashMap<AbstractFaultSection, Surface3D> getVisibleSurfaces() {
        HashMap<AbstractFaultSection, Surface3D> visSurfaces = new HashMap<AbstractFaultSection, Surface3D>();
        for (AbstractFaultSection fault : this.nodes.keySet()) {
            AbstractFaultNode node = this.nodes.get(fault);
            if (!node.isVisible()) continue;
            Surface3D surface = this.surfaces.get(fault);
            if (surface == null) {
                throw new RuntimeException("Surfaces is displayed but null?");
            }
            visSurfaces.put(fault, surface);
        }
        return visSurfaces;
    }

    @Override
    public AbstractFaultNode getNode(AbstractFaultSection fault) {
        return this.nodes.get(fault);
    }

    @Override
    public AbstractFaultSection getFault(int id) {
        return this.idSectionsMap.get(id);
    }

    @Override
    public void animationRangeChanged(FaultAnimation anim) {
        FaultColorer colorer = anim.getFaultColorer();
        if (anim.getNumSteps() > 0 && colorer != null && this.colorerPanel.getSelectedColorer() != colorer) {
            this.colorerPanel.setSelectedColorer(colorer);
        }
    }

    @Override
    public void animationStepChanged(FaultAnimation anim) {
        FaultColorer colorer = anim.getFaultColorer();
        if (colorer != null && this.colorerPanel.getSelectedColorer() != colorer) {
            this.colorerPanel.setSelectedColorer(colorer);
        }
        for (AbstractFaultSection fault : this.nodes.keySet()) {
            Color newColor;
            AbstractFaultNode node = this.nodes.get(fault);
            Boolean newVisibility = anim.getFaultVisibility(fault);
            if (newVisibility != null && !newVisibility.booleanValue() && node.isVisible()) {
                node.setVisible(false);
            }
            if (colorer != null && !(newColor = colorer.getColor(fault)).equals(node.getColor())) {
                node.setColor(newColor);
            }
            if (newVisibility == null || !newVisibility.booleanValue()) continue;
            node.setVisible(true);
        }
    }

    private class RenderRunnable
    implements Runnable {
        private RenderRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Class<RenderRunnable> clazz = RenderRunnable.class;
            synchronized (RenderRunnable.class) {
                if (EventManager.this.lastCompletedRender > EventManager.this.lastRequestedRender) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                long myRenderTime = System.nanoTime();
                MainGUI.updateRenderWindow();
                if (myRenderTime > EventManager.this.lastCompletedRender) {
                    EventManager.this.lastCompletedRender = myRenderTime;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    private class ColorChangeThread
    extends Thread {
        private FaultColorer newColorer;

        public ColorChangeThread(FaultColorer newColorer) {
            this.newColorer = newColorer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (FaultSectionNode node : EventManager.this.nodes.values()) {
                    Color color = this.newColorer.getColor(node.getFault());
                    if (color != null && color.equals(node.getColor())) continue;
                    node.setColor(color);
                }
            }
            finally {
                EventManager.this.unlockGUI();
                if (EventManager.this.pickBehavior != null) {
                    EventManager.this.pickBehavior.setColorer(this.newColorer);
                }
            }
        }
    }
}

