/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.util.ListUtils;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.gui.dist.VisibleFaultSurfacesProvider;
import org.scec.vtk.commons.opensha.tree.AbstractFaultNode;
import org.scec.vtk.commons.opensha.tree.events.CustomColorSelectionListener;

public class FaultHighlighter {
    private ArrayList<AbstractFaultNode> highlightedNodes = new ArrayList();
    private ArrayList<Color> highlightedPrevColors = new ArrayList();
    private ArrayList<Color> highlightColors = new ArrayList();
    private VisibleFaultSurfacesProvider surfaceProv;
    private CustomColorSelectionListener customColorListener;

    public FaultHighlighter(VisibleFaultSurfacesProvider surfaceProv, CustomColorSelectionListener customColorListener) {
        this.surfaceProv = surfaceProv;
        this.customColorListener = customColorListener;
    }

    public void unHilight() {
        for (int i = 0; i < this.highlightedNodes.size(); ++i) {
            this.rollBackColor(this.highlightedNodes.get(i), this.highlightedPrevColors.get(i), this.highlightColors.get(i));
        }
        this.highlightedNodes.clear();
        this.highlightedPrevColors.clear();
        this.highlightColors.clear();
    }

    private void rollBackColor(AbstractFaultNode highlightedNode, Color highlightedNodePrevColor, Color highlightColor) {
        if (highlightedNode != null && highlightedNodePrevColor != null && highlightedNode.getColor().equals(highlightColor)) {
            highlightedNode.setColor(highlightedNodePrevColor);
        }
    }

    public void highlightFaults(List<Integer> faultIDs, Color color) {
        ArrayList<AbstractFaultSection> faults = new ArrayList<AbstractFaultSection>();
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int id : faultIDs) {
            faults.add(this.surfaceProv.getFault(id));
            colors.add(color);
        }
        this.highlightFaults(faults, colors);
    }

    public void highlightFault(AbstractFaultSection fault, Color color) {
        this.highlightFaults(ListUtils.wrapInList((Object)fault), ListUtils.wrapInList((Object)color));
    }

    public void highlightFaults(List<AbstractFaultSection> faults, List<Color> colors) {
        Preconditions.checkArgument((faults.size() == colors.size() ? 1 : 0) != 0, (Object)"faults and colors sizes inconsistant!");
        for (int i = 0; i < faults.size(); ++i) {
            AbstractFaultSection fault = faults.get(i);
            AbstractFaultNode node = this.surfaceProv.getNode(fault);
            Color color = colors.get(i);
            if (this.highlightedNodes.contains(node)) {
                node.setColor(color);
                this.highlightColors.set(this.highlightedNodes.indexOf(node), color);
                continue;
            }
            this.highlightedNodes.add(node);
            this.highlightedPrevColors.add(node.getColor());
            this.highlightColors.add(color);
            node.setColor(color);
            node.setVisible(true);
        }
        this.customColorListener.customColorSelected();
    }
}

