/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opensha.commons.param.editor.impl.GriddedParameterListEditor;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.commons.opensha.surfaces.LineSurfaceGenerator;
import org.scec.vtk.commons.opensha.surfaces.events.GeometryGeneratorChangeListener;

public class GeometryTypeSelectorPanel
extends JPanel
implements ItemListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<GeometryGeneratorChangeListener> listeners = new ArrayList();
    private CardLayout cl = new CardLayout();
    private JPanel cards = new JPanel(this.cl);
    private JComboBox<GeometryGenerator> selector;
    private JCheckBox bundleCheck;
    private ArrayList<GeometryGenerator> geomGens;

    public GeometryTypeSelectorPanel(ArrayList<GeometryGenerator> geomGens) {
        super(new BorderLayout());
        this.geomGens = geomGens;
        this.selector = new JComboBox<GeometryGenerator>(geomGens.toArray(new GeometryGenerator[0]));
        this.selector.addItemListener(this);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        JLabel label = new JLabel("Geometry Type: ");
        label.setFont(new Font("Serif", 1, 14));
        topPanel.add(label);
        topPanel.add(this.selector);
        GeometryGenerator selected = this.getSelectedGeomGen();
        this.bundleCheck = new JCheckBox("Bundle?", selected.isBundlerEnabled());
        this.bundleCheck.setEnabled(selected.getFaultActorBundler() != null);
        this.bundleCheck.setToolTipText("Bundles multiple faults into one VTK actor for better performance. Disabling can fix depth sorting issues with transparency enabled.");
        this.bundleCheck.addActionListener(this);
        topPanel.add(this.bundleCheck);
        this.add((Component)topPanel, "North");
        for (GeometryGenerator geomGen : geomGens) {
            String name = geomGen.toString();
            this.cards.add((Component)new GriddedParameterListEditor(geomGen.getDisplayParams()), name);
        }
        this.cl.show(this.cards, this.selector.getSelectedItem().toString());
        this.add((Component)this.cards, "Center");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.selector) {
            GeometryGenerator selected = this.getSelectedGeomGen();
            this.cl.show(this.cards, selected.toString());
            this.bundleCheck.setSelected(selected.isBundlerEnabled());
            this.bundleCheck.setEnabled(selected.getFaultActorBundler() != null);
            this.firePlotSettingsChangeEvent();
        }
    }

    public GeometryGenerator getSelectedGeomGen() {
        return (GeometryGenerator)this.selector.getSelectedItem();
    }

    public void setSelectedGeomGen(GeometryGenerator geomGen) {
        Preconditions.checkState((boolean)this.geomGens.contains(geomGen));
        this.selector.setSelectedItem(geomGen);
    }

    public ArrayList<GeometryGenerator> getAllGeomGens() {
        return this.geomGens;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 300);
        ArrayList<GeometryGenerator> geomGens = new ArrayList<GeometryGenerator>();
        geomGens.add(new LineSurfaceGenerator());
        frame.setContentPane(new GeometryTypeSelectorPanel(geomGens));
        frame.setVisible(true);
    }

    public void addGeometryGeneratorChangeListener(GeometryGeneratorChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removeGeometryGeneratorChangeListener(GeometryGeneratorChangeListener listener) {
        return this.listeners.remove(listener);
    }

    protected void firePlotSettingsChangeEvent() {
        for (GeometryGeneratorChangeListener l : this.listeners) {
            l.geometryGeneratorChanged(this.getSelectedGeomGen());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bundleCheck) {
            this.getSelectedGeomGen().setBundlerEneabled(this.bundleCheck.isSelected());
        }
    }
}

