/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui.anim;

import com.google.common.base.Preconditions;
import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.gui.EventManager;
import org.scec.vtk.commons.opensha.gui.anim.AnimationPanel;
import org.scec.vtk.commons.opensha.gui.anim.StepTimeCalculator;

public class AnimThread
extends Thread {
    private static final boolean D = false;
    private static final long max_sleep_millis_time_based = 33L;
    private final AnimationPanel animPanel;
    private final FaultAnimation anim;
    private boolean pause = false;
    private boolean loop = false;
    private final boolean timeBased;
    private final double durationSeconds;
    private final StepTimeCalculator timeCalc;

    public AnimThread(AnimationPanel animPanel, FaultAnimation anim, StepTimeCalculator timeCalc, double durationSeconds) {
        Preconditions.checkNotNull((Object)animPanel);
        this.animPanel = animPanel;
        Preconditions.checkNotNull((Object)anim);
        this.anim = anim;
        Preconditions.checkNotNull((Object)timeCalc);
        this.timeCalc = timeCalc;
        this.timeBased = animPanel.isTimeBasedEnabled();
        this.durationSeconds = durationSeconds;
    }

    protected void pause() {
        this.pause = true;
    }

    protected void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean isLoop() {
        return this.loop;
    }

    @Override
    public void run() {
        this.pause = false;
        if (this.animPanel.getCurrentStep() == this.anim.getNumSteps() - 1) {
            this.animPanel.setCurrentStep(0);
        }
        int currentStep = this.animPanel.getCurrentStep();
        long start = System.currentTimeMillis();
        if (currentStep > 0) {
            start -= (long)(this.timeCalc.getAnimTimeUntil(0.0, currentStep) * 1000.0 + 0.5);
        }
        long millisEnd = this.timeBased ? (long)(this.durationSeconds * 1000.0 + 0.5) : (long)(this.timeCalc.getAnimTimeUntil(0.0, this.anim.getNumSteps() - 1) * 1000.0 + 0.5);
        while (!this.pause) {
            boolean stepsLeft;
            long millis = System.currentTimeMillis() - start;
            boolean bl = stepsLeft = currentStep < this.anim.getNumSteps() - 1;
            if (!this.timeBased ? !stepsLeft : !stepsLeft && millis > millisEnd) break;
            int newStep = this.timeCalc.getStepForAnimTime(currentStep, (double)millis / 1000.0);
            if (newStep <= currentStep) {
                if (this.timeBased) {
                    this.animPanel.setCurrentAnimTime((double)millis / 1000.0);
                    EventManager.flushRenders();
                }
                long sleepTime = (long)(this.timeCalc.getAnimTimeUntil(millis, currentStep + 1) * 1000.0 + 0.5);
                if (this.timeBased && sleepTime > 33L) {
                    sleepTime = 33L;
                }
                if (sleepTime > 1L) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                currentStep = newStep;
                this.animPanel.setCurrentStep(currentStep);
                EventManager.flushRenders();
            }
            if (!this.loop || currentStep < this.anim.getNumSteps() - 1) continue;
            this.animPanel.setCurrentStep(0);
            EventManager.flushRenders();
            currentStep = 0;
            start = System.currentTimeMillis();
            if (currentStep <= 0) continue;
            start -= (long)(this.timeCalc.getAnimTimeUntil(0.0, currentStep) * 1000.0 + 0.5);
        }
        this.animPanel.enableAnimControlsAfterAnimThread();
    }
}

