/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui.anim;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.GriddedParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.scec.vtk.commons.legend.LegendItem;
import org.scec.vtk.commons.legend.LegendUtils;
import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.faults.anim.IDBasedFaultAnimation;
import org.scec.vtk.commons.opensha.faults.anim.TimeBasedFaultAnimation;
import org.scec.vtk.commons.opensha.gui.EventManager;
import org.scec.vtk.commons.opensha.gui.anim.AnimThread;
import org.scec.vtk.commons.opensha.gui.anim.AnimationListener;
import org.scec.vtk.commons.opensha.gui.anim.EvenlySpacedCalc;
import org.scec.vtk.commons.opensha.gui.anim.StepTimeCalculator;
import org.scec.vtk.commons.opensha.gui.anim.TimeBasedCalc;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.Plugin;
import vtk.vtkTextActor;

public class AnimationPanel
extends JPanel
implements ChangeListener,
ActionListener,
FocusListener,
ParameterChangeListener {
    private static final long serialVersionUID = 1L;
    private static final boolean D = false;
    private FaultAnimation faultAnim;
    private static final int SLIDER_NUM_TIME_BASED = 10000;
    private JSlider slider = new JSlider();
    private JLabel label = new JLabel();
    private JButton playButton = new JButton("Play");
    private JButton pauseButton = new JButton("Pause");
    private JButton nextButton = new JButton("Next");
    private JButton prevButton = new JButton("Prev");
    private AnimThread animThread;
    private JCheckBox legendCheck = new JCheckBox("Legend", false);
    private JCheckBox legendStepCheck = new JCheckBox("Step", true);
    private JCheckBox legendTimeCheck = new JCheckBox("Time", true);
    private JCheckBox legendRelativeTimeCheck = new JCheckBox("Relative", false);
    private JCheckBox legendIDCheck = new JCheckBox("ID", false);
    private JCheckBox legendLabelCheck = new JCheckBox("Label", false);
    private LegendItem legend;
    private LegendItem graphicLegend;
    private static final String DURATION_PARAM_NAME = "Duration (seconds)";
    private static final Double DURATION_MIN = 1.0;
    private static final Double DURATION_MAX = 720000.0;
    private static final Double DURATION_DEFAULT = 30.0;
    private DoubleParameter durationParam;
    private static final String ANIM_TYPE_PARAM_NAME = "Animation Type";
    private EnumParameter<AnimType> animTypeParam;
    private static final String LOOP_PARAM_NAME = "Loop Animation";
    private static boolean LOOP_PARAM_DEFAULT = false;
    private BooleanParameter loopParam;
    private StepTimeCalculator timeCalc;
    private int curStep;
    private int curSliderVal;
    private double curAnimTime;
    private double curAbsTime;
    private ParameterList generalAnimParams;
    private ParameterList faultAnimParams;
    private JTextField idField = new JTextField(6);
    private JTextField timeField = new JTextField(5);
    private List<AnimationListener> listeners = new ArrayList<AnimationListener>();
    private Plugin plugin;
    private EventManager em;
    private static final DecimalFormat df = new DecimalFormat("0.00");
    private static final double secsPerMin = 60.0;
    private static final double secsPerHour = 3600.0;
    private static final double secsPerDay = 86400.0;
    private static final double secsPerYear = 3.1536E7;
    private Runnable sliderUpdate = new Runnable(){

        @Override
        public void run() {
            AnimationPanel.this.slider.setValue(AnimationPanel.this.curSliderVal);
        }
    };
    private Runnable enableAnimControlsRunnable = new Runnable(){

        @Override
        public void run() {
            boolean playing;
            boolean isFirst = AnimationPanel.this.curStep == 0;
            boolean isLast = AnimationPanel.this.curStep == AnimationPanel.this.faultAnim.getNumSteps() - 1;
            boolean bl = playing = AnimationPanel.this.animThread != null && AnimationPanel.this.animThread.isAlive();
            playing = AnimationPanel.this.isTimeBasedEnabled() ? playing && AnimationPanel.this.slider.getValue() < AnimationPanel.this.slider.getMaximum() : playing && !isLast;
            AnimationPanel.this.slider.setEnabled(!playing);
            AnimationPanel.this.playButton.setEnabled(!playing);
            AnimationPanel.this.pauseButton.setEnabled(playing);
            if (AnimationPanel.this.generalAnimParams != null) {
                for (Parameter param : AnimationPanel.this.generalAnimParams) {
                    param.getEditor().setEnabled(!playing);
                }
            }
            if (AnimationPanel.this.faultAnimParams != null) {
                for (Parameter param : AnimationPanel.this.faultAnimParams) {
                    param.getEditor().setEnabled(!playing);
                }
            }
            AnimationPanel.this.idField.setEnabled(!playing);
            AnimationPanel.this.nextButton.setEnabled(!playing && !isLast);
            AnimationPanel.this.prevButton.setEnabled(!playing && !isFirst);
            AnimationPanel.this.timeField.setEnabled(!playing);
        }
    };
    private static final Joiner legendJoin = Joiner.on((String)"\n");

    public AnimationPanel(Plugin plugin, EventManager em, FaultAnimation faultAnim) {
        GriddedParameterListEditor edit;
        AnimType defaultAnimType;
        EnumSet<AnimType> animTypes;
        super.setLayout(new BoxLayout(this, 1));
        this.plugin = plugin;
        this.em = em;
        this.addAnimationListener(em);
        this.faultAnim = faultAnim;
        faultAnim.addRangeChangeListener(this);
        this.durationParam = new DoubleParameter(DURATION_PARAM_NAME, DURATION_MIN, DURATION_MAX, DURATION_DEFAULT);
        this.durationParam.addParameterChangeListener((ParameterChangeListener)this);
        if (faultAnim instanceof TimeBasedFaultAnimation) {
            animTypes = EnumSet.allOf(AnimType.class);
            defaultAnimType = AnimType.TIME_BASED;
        } else {
            animTypes = EnumSet.of(AnimType.EVENLY_SPACED);
            defaultAnimType = AnimType.EVENLY_SPACED;
        }
        this.animTypeParam = new EnumParameter(ANIM_TYPE_PARAM_NAME, animTypes, (Enum)defaultAnimType, null);
        this.animTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.loopParam = new BooleanParameter(LOOP_PARAM_NAME, Boolean.valueOf(LOOP_PARAM_DEFAULT));
        this.generalAnimParams = new ParameterList();
        this.generalAnimParams.addParameter((Parameter)this.durationParam);
        if (animTypes.size() > 1) {
            this.generalAnimParams.addParameter(this.animTypeParam);
        }
        this.generalAnimParams.addParameter((Parameter)this.loopParam);
        this.faultAnimParams = faultAnim.getAnimationParameters();
        this.slider.addChangeListener(this);
        this.updateSliderRange();
        JPanel labelWrap = new JPanel();
        labelWrap.add(this.label);
        this.label.setAlignmentX(0.5f);
        this.prevButton.setFont(this.prevButton.getFont().deriveFont(10.0f));
        this.playButton.setFont(this.playButton.getFont().deriveFont(10.0f));
        this.pauseButton.setFont(this.pauseButton.getFont().deriveFont(10.0f));
        this.nextButton.setFont(this.nextButton.getFont().deriveFont(10.0f));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.add(this.prevButton);
        controlPanel.add(this.playButton);
        controlPanel.add(this.pauseButton);
        controlPanel.add(this.nextButton);
        controlPanel.setAlignmentX(0.5f);
        this.playButton.addActionListener(this);
        this.pauseButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.prevButton.addActionListener(this);
        if (faultAnim instanceof IDBasedFaultAnimation) {
            this.idField.setMaximumSize(this.idField.getPreferredSize());
            controlPanel.add(new JLabel("  ID: "));
            controlPanel.add(this.idField);
            this.idField.addActionListener(this);
            this.idField.addFocusListener(this);
            this.timeField.setMaximumSize(this.timeField.getPreferredSize());
            controlPanel.add(new JLabel("  Year: "));
            controlPanel.add(this.timeField);
            this.timeField.addActionListener(this);
            this.timeField.addFocusListener(this);
        }
        JPanel legendPanel = new JPanel();
        legendPanel.setLayout(new BoxLayout(legendPanel, 0));
        legendPanel.add(this.legendCheck);
        this.legendCheck.addActionListener(this);
        this.legendStepCheck.setSelected(!(faultAnim instanceof TimeBasedFaultAnimation));
        legendPanel.add(this.legendStepCheck);
        this.legendStepCheck.addActionListener(this);
        if (faultAnim instanceof TimeBasedFaultAnimation) {
            legendPanel.add(this.legendTimeCheck);
            this.legendTimeCheck.addActionListener(this);
            legendPanel.add(this.legendRelativeTimeCheck);
            this.legendRelativeTimeCheck.addActionListener(this);
        }
        if (faultAnim instanceof IDBasedFaultAnimation) {
            legendPanel.add(this.legendIDCheck);
            this.legendIDCheck.addActionListener(this);
        }
        legendPanel.add(this.legendLabelCheck);
        this.legendLabelCheck.addActionListener(this);
        this.setLegendChecksEnabled(this.legendCheck.isSelected());
        this.add(this.slider);
        this.add(controlPanel);
        this.add(labelWrap);
        this.add(legendPanel);
        if (this.generalAnimParams != null && this.generalAnimParams.size() > 0) {
            edit = new GriddedParameterListEditor(this.generalAnimParams);
            edit.setAlignmentX(0.5f);
            this.add((Component)edit);
        }
        if (this.faultAnimParams != null && this.faultAnimParams.size() > 0) {
            edit = new GriddedParameterListEditor(this.faultAnimParams);
            edit.setAlignmentX(0.5f);
            this.add((Component)edit);
        }
    }

    public void addAnimationListener(AnimationListener l) {
        this.listeners.add(l);
    }

    public void removeAnimationListener(AnimationListener l) {
        this.listeners.remove(l);
    }

    private void fireAnimationRangeChanged(FaultAnimation anim) {
        for (AnimationListener l : this.listeners) {
            l.animationRangeChanged(anim);
        }
    }

    private void fireAnimationStepChanged(FaultAnimation anim) {
        for (AnimationListener l : this.listeners) {
            l.animationStepChanged(anim);
        }
    }

    boolean isTimeBasedEnabled() {
        return this.faultAnim instanceof TimeBasedFaultAnimation && this.animTypeParam.getValue() == AnimType.TIME_BASED && ((TimeBasedFaultAnimation)this.faultAnim).getCurrentDuration() > 0.0;
    }

    private void updateSliderRange() {
        this.timeCalc = null;
        int max = this.faultAnim.getNumSteps();
        Preconditions.checkState((max >= 0 ? 1 : 0) != 0, (String)"Num steps must be zero or positive: %s", (int)max);
        if (this.isTimeBasedEnabled()) {
            max = 10000;
        }
        int min = max > 0 ? 1 : 0;
        this.fireAnimationRangeChanged(this.faultAnim);
        this.slider.setMinimum(min);
        this.slider.setMaximum(max);
        this.setCurrentStep(this.faultAnim.getPreferredInitialStep());
    }

    private void updateStep() {
        String custom;
        this.faultAnim.setCurrentStep(this.curStep);
        Object labelStr = "";
        if (this.faultAnim.includeStepInLabel()) {
            labelStr = (String)labelStr + "Frame " + (this.curStep + 1) + "/" + this.faultAnim.getNumSteps();
        }
        if (this.faultAnim instanceof TimeBasedFaultAnimation && !Double.isNaN(this.curAbsTime) && this.curAbsTime >= 0.0) {
            labelStr = (String)labelStr + ": " + AnimationPanel.getLabel(this.curAbsTime);
        }
        if ((custom = this.faultAnim.getCurrentLabel()) != null && custom.length() > 0) {
            if (((String)labelStr).length() > 0 && !custom.startsWith(" ")) {
                labelStr = (String)labelStr + " ";
            }
            labelStr = (String)labelStr + custom;
        }
        if (this.faultAnim instanceof IDBasedFaultAnimation) {
            int id = ((IDBasedFaultAnimation)this.faultAnim).getIDForStep(this.curStep);
            this.idField.setText("" + id);
            labelStr = (String)labelStr + " (ID: " + id + ")";
        }
        this.timeField.setText(df.format(this.curAbsTime / 3.1536E7));
        Object info = labelStr = AnimationPanel.wrapText((String)labelStr, 60);
        ((String)info).replace("<br>MoRate:", "MoRate:");
        labelStr = "<html>" + (String)labelStr + "</html>";
        this.label.setToolTipText((String)labelStr);
        this.label.setText((String)labelStr);
        if (this.faultAnim.getNumSteps() > 0) {
            this.fireAnimationStepChanged(this.faultAnim);
        }
        this.enableAnimControls();
        this.updateLegend();
    }

    private void updateTime() {
        if (this.isTimeBasedEnabled()) {
            boolean fire = ((TimeBasedFaultAnimation)this.faultAnim).timeChanged(this.curAbsTime);
            if (fire) {
                this.fireAnimationStepChanged(this.faultAnim);
            }
            this.updateLegend();
        }
    }

    private static String getLabel(double secs) {
        if (secs < 60.0) {
            return df.format(secs) + " secs";
        }
        if (secs < 3600.0) {
            return df.format(secs / 60.0) + " mins";
        }
        if (secs < 86400.0) {
            return df.format(secs / 3600.0) + " hours";
        }
        if (secs < 3.1536E7) {
            return df.format(secs / 86400.0) + " days";
        }
        return df.format(secs / 3.1536E7) + " years";
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.faultAnim) {
            this.updateSliderRange();
        } else if (e.getSource() == this.slider && this.slider.getValue() != this.curSliderVal) {
            this.updateStepFromSlider();
        }
    }

    private synchronized void updateStepFromSlider() {
        this.curSliderVal = this.slider.getValue();
        if (this.slider.getMinimum() == 0) {
            Preconditions.checkState((this.slider.getMaximum() == 0 ? 1 : 0) != 0);
            this.curStep = -1;
            this.curAnimTime = 0.0;
            this.curAbsTime = Double.NaN;
            return;
        }
        this.curAnimTime = (Double)this.durationParam.getValue() * ((double)this.curSliderVal - 1.0) / ((double)this.slider.getMaximum() - 1.0);
        if (Double.isNaN(this.curAnimTime)) {
            this.curAnimTime = 0.0;
        }
        if (this.isTimeBasedEnabled()) {
            this.curStep = this.getTimeCalc().getStepForAnimTimeSecs(this.curAnimTime);
            this.curAbsTime = this.getTimeCalc().getAbsoluteTime(this.curAnimTime);
        } else {
            this.curStep = this.curSliderVal - 1;
            this.curAbsTime = Double.NaN;
        }
        this.updateStep();
        this.updateTime();
    }

    synchronized void setCurrentAnimTime(double animTime) {
        int calcStep;
        if (this.faultAnim.getNumSteps() == 0) {
            Preconditions.checkState((this.slider.getMaximum() == 0 ? 1 : 0) != 0);
            this.curStep = -1;
            this.curAnimTime = 0.0;
            this.curAbsTime = Double.NaN;
            this.curSliderVal = 0;
            calcStep = -1;
        } else {
            calcStep = this.getTimeCalc().getStepForAnimTime(this.curStep, animTime);
            this.curAnimTime = animTime;
            StepTimeCalculator timeCalc = this.getTimeCalc();
            if (this.isTimeBasedEnabled()) {
                double fractionalAnimTime = this.curAnimTime / (Double)this.durationParam.getValue();
                Preconditions.checkState((this.slider.getMaximum() == 10000 ? 1 : 0) != 0);
                this.curSliderVal = 1 + (int)(fractionalAnimTime * 9999.0);
                this.curAbsTime = timeCalc.getAbsoluteTime(this.curAnimTime);
            } else {
                this.curSliderVal = calcStep + 1;
                this.curAbsTime = Double.NaN;
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.sliderUpdate.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(this.sliderUpdate);
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException((Throwable)e);
            }
        }
        if (this.curStep >= 0) {
            if (calcStep != this.curStep) {
                this.curStep = calcStep;
                this.updateStep();
            }
            this.updateTime();
        }
    }

    double getAnimDuration() {
        return (Double)this.durationParam.getValue();
    }

    synchronized void setCurrentStep(int step) {
        this.curStep = step;
        if (this.faultAnim.getNumSteps() <= 0) {
            Preconditions.checkState((this.slider.getMaximum() == 0 ? 1 : 0) != 0);
            this.curStep = -1;
            this.curAnimTime = 0.0;
            this.curAbsTime = Double.NaN;
            this.curSliderVal = 0;
        } else {
            StepTimeCalculator timeCalc = this.getTimeCalc();
            this.curAnimTime = timeCalc.getAnimTimeUntil(0.0, step);
            if (this.isTimeBasedEnabled()) {
                double fractionalAnimTime = this.curAnimTime / (Double)this.durationParam.getValue();
                Preconditions.checkState((this.slider.getMaximum() == 10000 ? 1 : 0) != 0);
                this.curSliderVal = 1 + (int)(fractionalAnimTime * 9999.0);
                this.curAbsTime = timeCalc.getAbsoluteTime(this.curAnimTime);
            } else {
                this.curSliderVal = step + 1;
                this.curAbsTime = Double.NaN;
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.sliderUpdate.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(this.sliderUpdate);
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException((Throwable)e);
            }
        }
        if (this.curStep >= 0) {
            this.updateStep();
            this.updateTime();
        }
    }

    int getCurrentStep() {
        return this.curStep;
    }

    private void enableAnimControls() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enableAnimControlsRunnable.run();
        } else {
            SwingUtilities.invokeLater(this.enableAnimControlsRunnable);
        }
    }

    StepTimeCalculator getTimeCalc() {
        if (this.timeCalc == null) {
            this.timeCalc = this.getTimeCalc((Double)this.durationParam.getValue());
        }
        return this.timeCalc;
    }

    private StepTimeCalculator getTimeCalc(double duration) {
        int maxStep = this.faultAnim.getNumSteps() - 1;
        AnimType type = (AnimType)((Object)this.animTypeParam.getValue());
        switch (type.ordinal()) {
            case 0: {
                return new TimeBasedCalc((TimeBasedFaultAnimation)this.faultAnim, maxStep, duration);
            }
            case 1: {
                return new EvenlySpacedCalc(this.faultAnim, maxStep, duration);
            }
        }
        throw new IllegalStateException("Unknown anim type: " + String.valueOf((Object)type));
    }

    void enableAnimControlsAfterAnimThread() {
        new Thread(){

            @Override
            public void run() {
                while (AnimationPanel.this.animThread != null && AnimationPanel.this.animThread.isAlive()) {
                }
                AnimationPanel.this.enableAnimControls();
            }
        }.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.playButton) {
            this.animThread = new AnimThread(this, this.faultAnim, this.getTimeCalc(), (Double)this.durationParam.getValue());
            this.animThread.setLoop((Boolean)this.loopParam.getValue());
            this.animThread.start();
            this.enableAnimControls();
        } else if (e.getSource() == this.pauseButton) {
            if (this.animThread != null) {
                this.animThread.pause();
            }
            this.enableAnimControlsAfterAnimThread();
        } else if (e.getSource() == this.nextButton) {
            this.setCurrentStep(this.curStep + 1);
        } else if (e.getSource() == this.prevButton) {
            this.setCurrentStep(this.curStep - 1);
        } else if (e.getSource() == this.idField) {
            this.idFieldUpdated();
        } else if (e.getSource() == this.timeField) {
            this.yearFieldUpdated();
        } else if (e.getSource() == this.legendCheck) {
            boolean displayed = this.legendCheck.isSelected();
            this.setLegendChecksEnabled(displayed);
            this.updateLegend();
            this.setLegendDisplayed(displayed);
        } else if (e.getSource() == this.legendStepCheck || e.getSource() == this.legendTimeCheck || e.getSource() == this.legendRelativeTimeCheck || e.getSource() == this.legendIDCheck || e.getSource() == this.legendLabelCheck) {
            if (e.getSource() == this.legendTimeCheck) {
                this.setLegendChecksEnabled(this.legendCheck.isSelected());
            }
            this.updateLegend();
        }
    }

    private void setLegendChecksEnabled(boolean enabled) {
        this.legendStepCheck.setEnabled(enabled);
        this.legendTimeCheck.setEnabled(enabled);
        this.legendRelativeTimeCheck.setEnabled(enabled && this.legendTimeCheck.isSelected());
        this.legendIDCheck.setEnabled(enabled);
        this.legendLabelCheck.setEnabled(enabled);
    }

    @Override
    public void focusGained(FocusEvent focusevent) {
    }

    @Override
    public void focusLost(FocusEvent focusevent) {
        this.idFieldUpdated();
    }

    private void idFieldUpdated() {
        String idFieldVal = this.idField.getText();
        try {
            int id = Integer.parseInt(idFieldVal);
            int step = ((IDBasedFaultAnimation)this.faultAnim).getStepForID(id);
            this.setCurrentStep(step);
        }
        catch (Exception e) {
            this.idField.setText("" + ((IDBasedFaultAnimation)this.faultAnim).getIDForStep(this.curStep));
        }
    }

    private void yearFieldUpdated() {
        String year = this.timeField.getText();
        try {
            Double yearText = Double.parseDouble(year);
            this.curAbsTime = yearText * 3.1536E7;
            Double updatedTime = this.getTimeCalc().getAnimTime(this.curAbsTime);
            this.setCurrentAnimTime(updatedTime);
            this.updateStep();
            this.updateTime();
            this.updateLegend();
        }
        catch (Exception e) {
            this.timeField.setText("");
        }
    }

    private static String wrapText(String text, int len) {
        if (text == null) {
            return "";
        }
        if (len <= 0) {
            return text;
        }
        if (text.length() <= len) {
            return text;
        }
        char[] chars = text.toCharArray();
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer line = new StringBuffer();
        StringBuffer word = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            word.append(chars[i]);
            if (chars[i] != ' ') continue;
            if (line.length() + word.length() > len) {
                lines.add(line.toString());
                line.delete(0, line.length());
            }
            line.append(word);
            word.delete(0, word.length());
        }
        if (word.length() > 0) {
            if (line.length() + word.length() > len) {
                lines.add(line.toString());
                line.delete(0, line.length());
            }
            line.append(word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        Object ret = null;
        for (String str : lines) {
            ret = ret == null ? "" : (String)ret + "<br>";
            ret = (String)ret + str;
        }
        return ret;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getSource() == this.durationParam || event.getSource() == this.animTypeParam) {
            this.timeCalc = null;
        }
    }

    private Color selectLegendColor() {
        Color bkg = Info.getBackgroundColor();
        double meanVal = (double)(bkg.getRed() + bkg.getGreen() + bkg.getBlue()) / 3.0;
        Color color = meanVal >= 127.5 ? Color.BLACK : Color.WHITE;
        return color;
    }

    private synchronized void setLegendDisplayed(boolean displayed) {
        Color color = this.selectLegendColor();
        if (this.legend == null) {
            this.legend = LegendUtils.buildTextLegend(this.plugin, this.faultAnim.getName(), "SansSerif", 28, color, 5.0, 5.0);
            ((vtkTextActor)this.legend.getActor()).SetInput(this.buildLegendText());
        } else {
            ((vtkTextActor)this.legend.getActor()).GetTextProperty().SetColor(Info.convertColor(color));
        }
        if (displayed) {
            this.plugin.getPluginActors().addLegend(this.legend);
        } else {
            this.plugin.getPluginActors().removeLegend(this.legend);
        }
        MainGUI.updateRenderWindow();
    }

    private synchronized void updateLegend() {
        if (this.legend == null) {
            return;
        }
        String text = this.buildLegendText();
        Preconditions.checkState((boolean)(this.legend.getActor() instanceof vtkTextActor));
        vtkTextActor actor = (vtkTextActor)this.legend.getActor();
        actor.SetInput(text);
        actor.Modified();
        this.em.updateViewer();
    }

    private String buildLegendText() {
        String label;
        ArrayList<Object> elems = new ArrayList<Object>();
        if (this.legendStepCheck.isSelected()) {
            elems.add(this.curStep + 1 + "/" + this.faultAnim.getNumSteps());
        }
        if (this.faultAnim instanceof TimeBasedFaultAnimation && this.legendTimeCheck.isSelected() && Double.isFinite(this.curAbsTime)) {
            double time = this.curAbsTime;
            if (this.legendRelativeTimeCheck.isSelected()) {
                time -= ((TimeBasedFaultAnimation)this.faultAnim).getTimeForStep(0);
            }
            elems.add(AnimationPanel.getLabel(time));
        }
        if (this.faultAnim instanceof IDBasedFaultAnimation && this.legendIDCheck.isSelected()) {
            int id = ((IDBasedFaultAnimation)this.faultAnim).getIDForStep(this.curStep);
            elems.add("ID: " + id);
        }
        if (this.legendLabelCheck.isSelected() && (label = this.faultAnim.getCurrentLabel()) != null && !label.isEmpty()) {
            elems.add(label);
        }
        return legendJoin.join(elems);
    }

    private static enum AnimType {
        TIME_BASED("Time Based"),
        EVENLY_SPACED("Evenly Spaced");

        private String name;

        private AnimType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

