/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui.anim;

import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.faults.anim.TimeBasedFaultAnimation;
import org.scec.vtk.commons.opensha.gui.anim.StepTimeCalculator;

public class EvenlySpacedCalc
implements StepTimeCalculator {
    private final double maxStep;
    private final double duration;
    private final double absMinTime;
    private final double absDuration;

    public EvenlySpacedCalc(FaultAnimation faultAnim, int maxStep, double duration) {
        this.maxStep = maxStep;
        this.duration = duration;
        if (faultAnim instanceof TimeBasedFaultAnimation) {
            TimeBasedFaultAnimation timeAnim = (TimeBasedFaultAnimation)faultAnim;
            this.absMinTime = timeAnim.getTimeForStep(0);
            this.absDuration = timeAnim.getTimeForStep(timeAnim.getNumSteps() - 1);
        } else {
            this.absMinTime = 0.0;
            this.absDuration = duration;
        }
    }

    @Override
    public int getStepForAnimTimeSecs(double secs) {
        return this.getStepForAnimTime(-1, secs);
    }

    @Override
    public int getStepForAnimTime(int prevStep, double secs) {
        return (int)(this.maxStep * secs / this.duration);
    }

    @Override
    public double getAnimTimeUntil(double secs, int currentStep) {
        double secsForNext = (double)currentStep * this.duration / this.maxStep;
        return secsForNext - secs;
    }

    @Override
    public double getAbsoluteTime(double animTimeSecs) {
        return this.absMinTime + this.absDuration * (animTimeSecs / this.duration);
    }

    @Override
    public double getAnimTime(double absoluteTimeSecs) {
        return (absoluteTimeSecs - this.absMinTime) * this.duration / absoluteTimeSecs;
    }
}

