/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui.anim;

import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.gui.anim.AnimationPanel;
import org.scec.vtk.commons.opensha.gui.anim.StepTimeCalculator;

public class FractionalTimeAnimator {
    private AnimationPanel animPanel;
    private FaultAnimation anim;
    private StepTimeCalculator timeCalc;
    private int curStep;
    private long totTimeMillis;
    private double curFractTime;

    public FractionalTimeAnimator(AnimationPanel animPanel, FaultAnimation anim, StepTimeCalculator timeCalc) {
        this.animPanel = animPanel;
        this.anim = anim;
        this.timeCalc = timeCalc;
        this.curStep = animPanel.getCurrentStep();
        this.totTimeMillis = (long)(timeCalc.getAnimTimeUntil(0.0, anim.getNumSteps() - 1) * 1000.0 + 0.5);
        long curTimeMillis = (long)(timeCalc.getAnimTimeUntil(0.0, this.curStep) * 1000.0 + 0.5);
        this.curFractTime = (double)curTimeMillis / (double)this.totTimeMillis;
    }

    public synchronized void goToTime(double fractionalTime) {
        double animTime = fractionalTime * this.animPanel.getAnimDuration();
        this.animPanel.setCurrentAnimTime(animTime);
    }
}

