/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui.anim;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.scec.vtk.commons.opensha.faults.anim.FaultAnimation;
import org.scec.vtk.commons.opensha.faults.colorers.ColorerChangeListener;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.commons.opensha.gui.ColorerPanel;
import org.scec.vtk.commons.opensha.gui.EventManager;
import org.scec.vtk.commons.opensha.gui.anim.AnimationListener;
import org.scec.vtk.commons.opensha.gui.anim.AnimationPanel;
import org.scec.vtk.commons.opensha.gui.anim.FractionalTimeAnimator;
import org.scec.vtk.plugins.AnimatableChangeListener;
import org.scec.vtk.plugins.AnimatablePlugin;
import org.scec.vtk.plugins.Plugin;

public class MultiAnimPanel
extends JPanel
implements ItemListener,
ColorerChangeListener,
AnimationListener {
    private static final long serialVersionUID = 1L;
    private CardLayout cl;
    private JPanel mainPanel;
    private HashMap<String, FaultAnimation> animMap;
    private HashMap<String, AnimationPanel> animPanelMap;
    private JComboBox<String> combo;
    private ColorerPanel cp;
    private List<AnimatableChangeListener> animChangeListeners = new ArrayList<AnimatableChangeListener>();
    private AnimationPanel animPanel;
    private AnimatablePlugin plugin;
    private FractionalTimeAnimator animator;

    public MultiAnimPanel(Plugin plugin, EventManager em, ArrayList<FaultAnimation> anims, ColorerPanel cp) {
        super(new BorderLayout());
        this.cp = cp;
        this.cl = new CardLayout();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(this.cl);
        this.animMap = new HashMap();
        this.animPanelMap = new HashMap();
        boolean isAnimColorerSelected = false;
        for (FaultAnimation anim : anims) {
            this.animMap.put(anim.getName(), anim);
            AnimationPanel animPanel = new AnimationPanel(plugin, em, anim);
            this.animPanelMap.put(anim.getName(), animPanel);
            animPanel.addAnimationListener(this);
            this.mainPanel.add((Component)animPanel, anim.getName());
            if (anim.getFaultColorer() == null || cp.getSelectedColorer() != anim.getFaultColorer()) continue;
            isAnimColorerSelected = true;
        }
        this.combo = new JComboBox<String>(this.animMap.keySet().toArray(new String[0]));
        this.updateSelectedAnimPanel();
        if (anims.size() > 1) {
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BoxLayout(topPanel, 0));
            topPanel.add(new JLabel("Animation: "));
            topPanel.add(this.combo);
            super.add((Component)topPanel, "North");
        }
        super.add((Component)this.mainPanel, "Center");
        this.combo.addItemListener(this);
        if (isAnimColorerSelected) {
            this.itemStateChanged(null);
        }
        cp.addColorerChangeListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        FaultAnimation anim = this.getSelectedAnim();
        this.cl.show(this.mainPanel, anim.getName());
        if (anim.getFaultColorer() != null) {
            this.cp.setSelectedColorer(anim.getFaultColorer());
            anim.fireRangeChangeEvent();
        }
        this.updateSelectedAnimPanel();
    }

    public FaultAnimation getSelectedAnim() {
        String name = (String)this.combo.getSelectedItem();
        return this.animMap.get(name);
    }

    public Collection<FaultAnimation> getAnimations() {
        return this.animMap.values();
    }

    private void updateSelectedAnimPanel() {
        String name = (String)this.combo.getSelectedItem();
        this.animPanel = this.animPanelMap.get(name);
    }

    public void setSelectedAnim(FaultAnimation anim) {
        this.setSelectedAnim(anim.getName());
    }

    public void setSelectedAnim(String animName) {
        Preconditions.checkState((boolean)this.animMap.containsKey(animName));
        this.combo.setSelectedItem(animName);
        this.updateSelectedAnimPanel();
    }

    @Override
    public void colorerChanged(FaultColorer newColorer) {
        if (newColorer != null) {
            for (FaultAnimation anim : this.animMap.values()) {
                if (newColorer != anim.getFaultColorer()) continue;
                if (this.combo.getSelectedItem().equals(anim.getName())) break;
                this.combo.setSelectedItem(anim.getName());
                break;
            }
        }
    }

    public void animationStarted() {
        FaultAnimation anim = this.getSelectedAnim();
        if (anim.getFaultColorer() != null) {
            this.cp.setSelectedColorer(anim.getFaultColorer());
            anim.fireRangeChangeEvent();
        }
        this.animator = new FractionalTimeAnimator(this.animPanel, this.getSelectedAnim(), this.animPanel.getTimeCalc());
    }

    public void animationEnded() {
        this.animator = null;
    }

    public void animationTimeChanged(double fractionalTime) {
        Preconditions.checkNotNull((Object)this.animator, (Object)"Animator is null! animationStarted() not called? Or animationEnded() called prematurely.");
        this.animator.goToTime(fractionalTime);
    }

    public boolean isAnimatable() {
        return this.getSelectedAnim().getNumSteps() > 0;
    }

    public void addAnimatableChangeListener(AnimatableChangeListener l) {
        this.animChangeListeners.add(l);
    }

    public void removeAnimatableChangeListener(AnimatableChangeListener l) {
        this.animChangeListeners.remove(l);
    }

    public void setPlugin(AnimatablePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void animationRangeChanged(FaultAnimation anim) {
        this.animator = null;
        boolean isAnimatable = this.isAnimatable();
        for (AnimatableChangeListener l : this.animChangeListeners) {
            l.animatableChanged(this.plugin, isAnimatable);
        }
    }

    @Override
    public void animationStepChanged(FaultAnimation anim) {
    }
}

