/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui.anim;

import com.google.common.base.Preconditions;
import org.scec.vtk.commons.opensha.faults.anim.TimeBasedFaultAnimation;
import org.scec.vtk.commons.opensha.gui.anim.StepTimeCalculator;

public class TimeBasedCalc
implements StepTimeCalculator {
    private static final boolean D = false;
    private final TimeBasedFaultAnimation anim;
    private final double multiplier;
    private final double minTime;
    private int prevStep;

    public TimeBasedCalc(TimeBasedFaultAnimation anim, int maxStep, double duration) {
        this.anim = anim;
        this.minTime = anim.getTimeForStep(0);
        double absoluteDuration = anim.getCurrentDuration();
        double maxTime = this.minTime + absoluteDuration;
        Preconditions.checkState((maxTime > this.minTime ? 1 : 0) != 0, (String)"the time difference for the min and max step must be > 0. min=%s, max=%s", (Object)this.minTime, (Object)maxTime);
        this.multiplier = duration / absoluteDuration;
    }

    @Override
    public synchronized int getStepForAnimTimeSecs(double secs) {
        int step;
        this.prevStep = step = this.getStepForAnimTime(this.prevStep, secs);
        return step;
    }

    @Override
    public int getStepForAnimTime(int prevStep, double secs) {
        int step;
        if (this.getAnimTime(this.anim.getTimeForStep(prevStep)) > secs) {
            prevStep = 0;
        }
        int i = step = prevStep;
        while (i < this.anim.getNumSteps()) {
            double stepTime = this.anim.getTimeForStep(i);
            if (!((stepTime = this.getAnimTime(stepTime)) <= secs)) break;
            step = i++;
        }
        return step;
    }

    @Override
    public double getAnimTimeUntil(double secs, int step) {
        double absTime = this.anim.getTimeForStep(step);
        double aninTime = this.getAnimTime(absTime);
        double secsToSleep = aninTime - secs;
        return secsToSleep;
    }

    @Override
    public double getAbsoluteTime(double animTimeSecs) {
        return this.minTime + animTimeSecs / this.multiplier;
    }

    @Override
    public double getAnimTime(double absoluteTimeSecs) {
        return (absoluteTimeSecs - this.minTime) * this.multiplier;
    }
}

