/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui.dist;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.refFaultParamDb.calc.sectionDists.FaultSectDistCalculator;
import org.opensha.refFaultParamDb.calc.sectionDists.FaultSectDistRecord;
import org.opensha.refFaultParamDb.calc.sectionDists.SmartSurfaceFilter;
import org.opensha.refFaultParamDb.calc.sectionDists.SurfaceFilter;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.gui.dist.NamedDistRecord;
import org.scec.vtk.commons.opensha.gui.dist.NamedRecordAveQuantityComparator;
import org.scec.vtk.commons.opensha.gui.dist.NamedRecordDistComparator;
import org.scec.vtk.commons.opensha.gui.dist.VisibleFaultSurfacesProvider;

public class DistanceCalc {
    private VisibleFaultSurfacesProvider surfaceProv;
    private ArrayList<NamedDistRecord> records;
    private HashMap<Integer, AbstractFaultSection> idFaultMap;
    private static final DecimalFormat distFormat = new DecimalFormat("0.00");

    public DistanceCalc(VisibleFaultSurfacesProvider surfaceProv) {
        this.surfaceProv = surfaceProv;
    }

    public void updateFaultConnections(double maxDist) throws InterruptedException {
        HashMap<AbstractFaultSection, Surface3D> surfaceMap = this.surfaceProv.getVisibleSurfaces();
        ArrayList<EvenlyGriddedSurface> surfaces = new ArrayList<EvenlyGriddedSurface>();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        this.idFaultMap = new HashMap();
        for (AbstractFaultSection fs : surfaceMap.keySet()) {
            Surface3D surface = surfaceMap.get(fs);
            if (!(surface instanceof EvenlyGriddedSurface)) continue;
            ids.add(fs.getId());
            surfaces.add((EvenlyGriddedSurface)surface);
            this.idFaultMap.put(fs.getId(), fs);
        }
        System.out.println("Calculating for " + ids.size() + " sections");
        if (ids.size() == 0) {
            return;
        }
        double faultDisc = LocationUtils.linearDistance((Location)((Location)((EvenlyGriddedSurface)surfaces.get(0)).get(0, 0)), (Location)((Location)((EvenlyGriddedSurface)surfaces.get(0)).get(1, 0)));
        FaultSectDistCalculator distCalc = new FaultSectDistCalculator(true, surfaces, ids);
        double cornerMidptDistFilter = maxDist * 5.0;
        int outlineModulus = (int)(1.0 / (faultDisc / 4.0));
        int internalModulus = (int)(1.0 / (faultDisc / 5.0));
        double filterDist = maxDist * 1.75;
        System.out.println("faultDisc: " + faultDisc + " maxDist: " + maxDist + " cornerMidptDistFilter: " + cornerMidptDistFilter);
        System.out.println("outlineModulus: " + outlineModulus + " internalModulus: " + internalModulus + " filterDist: " + filterDist);
        SmartSurfaceFilter filter = new SmartSurfaceFilter(outlineModulus, internalModulus, cornerMidptDistFilter);
        distCalc.createPairings((SurfaceFilter)filter, filterDist);
        System.out.println("Pair time: " + distCalc.getPairTimeSecs());
        int threads = Runtime.getRuntime().availableProcessors();
        System.out.println("calculating distances with " + threads + " threads");
        distCalc.calcDistances(threads);
        System.out.println("Calc time: " + distCalc.getCalcTimeSecs());
        this.records = new ArrayList();
        for (FaultSectDistRecord record : distCalc.getRecords().values()) {
            if (!(record.getMinDist() <= maxDist)) continue;
            AbstractFaultSection fault1 = this.idFaultMap.get(record.getID1());
            AbstractFaultSection fault2 = this.idFaultMap.get(record.getID2());
            String name1 = fault1.getName();
            String name2 = fault2.getName();
            String recName = distFormat.format(record.getMinDist()) + " KM: " + name1 + " => " + name2;
            this.records.add(new NamedDistRecord(record, recName, fault1, fault2));
        }
    }

    public void sortByDistance() {
        this.sortRecords(new NamedRecordDistComparator());
    }

    public void sortBySlip() {
        HashMap<Integer, Double> slipMap = new HashMap<Integer, Double>();
        for (AbstractFaultSection fault : this.idFaultMap.values()) {
            slipMap.put(fault.getId(), fault.getSlipRate());
        }
        this.sortRecords(new NamedRecordAveQuantityComparator(slipMap, false));
    }

    public void sortRecords(Comparator<NamedDistRecord> comparator) {
        if (this.records == null) {
            return;
        }
        System.out.print("sorting...");
        Collections.sort(this.records, comparator);
        System.out.println("DONE!");
    }

    public ArrayList<NamedDistRecord> getRecords() {
        return this.records;
    }

    public void clear() {
        this.records = null;
        this.idFaultMap = null;
    }
}

