/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.gui.dist;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.calc.sectionDists.FaultSectDistRecord;
import org.scec.vtk.commons.opensha.gui.dist.DistanceCalc;
import org.scec.vtk.commons.opensha.gui.dist.NamedDistRecord;
import org.scec.vtk.commons.opensha.gui.dist.VisibleFaultSurfacesProvider;
import org.scec.vtk.commons.opensha.tree.AbstractFaultNode;
import org.scec.vtk.commons.opensha.tree.events.CustomColorSelectionListener;
import org.scec.vtk.commons.opensha.tree.events.TreeChangeListener;

public class DistancesPanel
extends JPanel
implements ActionListener,
ParameterChangeListener,
TreeChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String FAULT_CONNECTIONS_PARAM_NAME = "Fault Connections";
    private static final String FAULT_CONNECTIONS_PARAM_DEFAULT = "None";
    private StringParameter faultConnectionsParam;
    private JButton loadFaultConnectionsButton;
    private JButton exportFaultConnButton;
    private DoubleParameter faultConnectionsDistParam;
    private static final String FAULT_CONNECTIONS_DIST_PARAM_NAME = "Fault Distance Cutoff";
    private static final Double FAULT_CONNECTIONS_DIST_PARAM_DEFAULT = 10.0;
    private static final Double FAULT_CONNECTIONS_DIST_PARAM_MIN = 0.0;
    private static final Double FAULT_CONNECTIONS_DIST_PARAM_MAX = 100.0;
    private ArrayList<NamedDistRecord> faultDistRecords;
    private ArrayList<String> faultDistNames;
    private static final String SORT_PARAM_NAME = "Sort by ";
    private static final String SORT_DISTANCES = "Min Distance";
    private static final String SORT_SLIP = "Avg Slip";
    private static final String SORT_DEFAULT = "Min Distance";
    private StringParameter sortParam;
    private DistanceCalc distCalc;
    private static final Color SELECTED_COLOR_1 = Color.GREEN;
    private static final Color SELECTED_COLOR_2 = Color.CYAN;
    private VisibleFaultSurfacesProvider surfaceProv;
    private CustomColorSelectionListener customColorListener;

    public DistancesPanel(VisibleFaultSurfacesProvider surfaceProv, CustomColorSelectionListener customColorListener) {
        this.customColorListener = customColorListener;
        this.distCalc = new DistanceCalc(surfaceProv);
        this.surfaceProv = surfaceProv;
        ArrayList<String> allowedStrings = new ArrayList<String>();
        allowedStrings.add(FAULT_CONNECTIONS_PARAM_DEFAULT);
        this.faultConnectionsParam = new StringParameter(FAULT_CONNECTIONS_PARAM_NAME, allowedStrings, FAULT_CONNECTIONS_PARAM_DEFAULT);
        this.faultConnectionsDistParam = new DoubleParameter(FAULT_CONNECTIONS_DIST_PARAM_NAME, FAULT_CONNECTIONS_DIST_PARAM_MIN, FAULT_CONNECTIONS_DIST_PARAM_MAX, FAULT_CONNECTIONS_DIST_PARAM_DEFAULT);
        ArrayList<String> recordComparatorNames = new ArrayList<String>();
        recordComparatorNames.add("Min Distance");
        recordComparatorNames.add(SORT_SLIP);
        this.sortParam = new StringParameter(SORT_PARAM_NAME, recordComparatorNames, "Min Distance");
        this.sortParam.addParameterChangeListener((ParameterChangeListener)this);
        this.loadFaultConnectionsButton = new JButton("Update");
        this.loadFaultConnectionsButton.addActionListener(this);
        this.exportFaultConnButton = new JButton("Export");
        this.exportFaultConnButton.addActionListener(this);
        this.exportFaultConnButton.setEnabled(false);
        JPanel connectionTopPanel = new JPanel();
        connectionTopPanel.setLayout(new BoxLayout(connectionTopPanel, 0));
        connectionTopPanel.add(this.faultConnectionsDistParam.getEditor().getComponent());
        connectionTopPanel.add(this.sortParam.getEditor().getComponent());
        JPanel connectionButtonsPanel = new JPanel();
        connectionButtonsPanel.setLayout(new BoxLayout(connectionButtonsPanel, 1));
        connectionButtonsPanel.add(this.loadFaultConnectionsButton);
        connectionButtonsPanel.add(this.exportFaultConnButton);
        connectionTopPanel.add(connectionButtonsPanel);
        this.faultConnectionsParam.addParameterChangeListener((ParameterChangeListener)this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(connectionTopPanel);
        this.add(this.faultConnectionsParam.getEditor().getComponent());
    }

    private void sortFaultConnections() {
        String sortType = (String)this.sortParam.getValue();
        if (sortType.equals("Min Distance")) {
            this.distCalc.sortByDistance();
        } else if (sortType.equals(SORT_SLIP)) {
            this.distCalc.sortBySlip();
        } else {
            throw new RuntimeException("Unknown sort type: " + sortType);
        }
    }

    private void updateConnectionsParam() {
        this.faultDistRecords = this.distCalc.getRecords();
        ArrayList<String> allowedStrings = new ArrayList<String>();
        allowedStrings.add(FAULT_CONNECTIONS_PARAM_DEFAULT);
        boolean hasRecords = this.faultDistRecords != null && this.faultDistRecords.size() > 0;
        this.faultDistNames = new ArrayList();
        if (hasRecords) {
            for (NamedDistRecord record : this.faultDistRecords) {
                allowedStrings.add(record.getName());
                this.faultDistNames.add(record.getName());
            }
        }
        this.faultConnectionsParam.setValue((Object)FAULT_CONNECTIONS_PARAM_DEFAULT);
        StringConstraint sconst = (StringConstraint)this.faultConnectionsParam.getConstraint();
        sconst.setStrings(allowedStrings);
        this.faultConnectionsParam.getEditor().setParameter((Parameter)this.faultConnectionsParam);
        this.exportFaultConnButton.setEnabled(hasRecords);
    }

    private void updateFaultConnections() throws InterruptedException {
        this.distCalc.updateFaultConnections((Double)this.faultConnectionsDistParam.getValue());
        this.sortFaultConnections();
        this.updateConnectionsParam();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser;
        int ret;
        if (e.getSource().equals(this.loadFaultConnectionsButton)) {
            try {
                this.updateFaultConnections();
            }
            catch (InterruptedException e1) {
                throw new RuntimeException(e1);
            }
        }
        if (e.getSource().equals(this.exportFaultConnButton) && (ret = (chooser = new JFileChooser()).showSaveDialog(this)) == 0) {
            File file = chooser.getSelectedFile();
            try {
                FileWriter fw = new FileWriter(file);
                fw.write("\"name1\",id1,\"name2\",id2,minDist,maxDist\n");
                for (NamedDistRecord nrecord : this.faultDistRecords) {
                    String name1 = nrecord.getFault1().getName();
                    String name2 = nrecord.getFault2().getName();
                    FaultSectDistRecord record = nrecord.getRecord();
                    fw.write("\"" + name1 + "\"," + record.getID1() + ",\"" + name2 + "\"," + record.getID2() + "," + record.getMinDist() + "," + record.getMaxDist() + "\n");
                }
                fw.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void rollBackColor(AbstractFaultNode highlightedNode, Color highlightedNodePrevColor, Color highlightColor) {
        if (highlightedNode != null && highlightedNodePrevColor != null && highlightedNode.getColor().equals(highlightColor)) {
            highlightedNode.setColor(highlightedNodePrevColor);
        }
    }

    private void unHilight() {
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameterName().equals(FAULT_CONNECTIONS_PARAM_NAME)) {
            String name = (String)this.faultConnectionsParam.getValue();
            this.unHilight();
        } else if (event.getParameterName().equals(SORT_PARAM_NAME)) {
            this.unHilight();
            this.sortFaultConnections();
            this.updateConnectionsParam();
        }
    }

    @Override
    public void treeChanged(TreeNode newRoot) {
        this.unHilight();
        this.faultDistRecords = null;
        this.distCalc.clear();
        this.updateConnectionsParam();
        this.unHilight();
    }
}

