/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.surfaces;

import com.google.common.base.Preconditions;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionBundledActorList;
import org.scec.vtk.tools.picking.PointPickEnabledActor;
import vtk.vtkCellArray;
import vtk.vtkDataSet;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkUnsignedCharArray;

public class FaultActorBundle {
    private PointPickEnabledActor<AbstractFaultSection> actor;
    private vtkDataSet dataSet;
    private vtkPoints points;
    private vtkUnsignedCharArray colorArray;
    private vtkCellArray cellArray;

    public void initialize(PointPickEnabledActor<AbstractFaultSection> actor, vtkDataSet dataSet, vtkPoints points, vtkUnsignedCharArray colorArray, vtkCellArray cellArray) {
        this.actor = actor;
        this.dataSet = dataSet;
        this.points = points;
        this.colorArray = colorArray;
        this.cellArray = cellArray;
    }

    public boolean isInitialized() {
        return this.colorArray != null;
    }

    public PointPickEnabledActor<AbstractFaultSection> getActor() {
        return this.actor;
    }

    public vtkPolyData getPolyData() {
        Preconditions.checkState((boolean)(this.dataSet instanceof vtkPolyData));
        return (vtkPolyData)this.getVtkDataSet();
    }

    public vtkDataSet getVtkDataSet() {
        return this.dataSet;
    }

    public vtkPoints getPoints() {
        return this.points;
    }

    public vtkUnsignedCharArray getColorArray() {
        return this.colorArray;
    }

    public vtkCellArray getCellArray() {
        return this.cellArray;
    }

    public void setVisible(FaultSectionBundledActorList faultBundle, boolean visible) {
        Preconditions.checkState((faultBundle.getBundle() == this ? 1 : 0) != 0);
        int firstIndex = faultBundle.getMyFirstPointIndex();
        int lastIndex = firstIndex + faultBundle.getMyNumPoints() - 1;
        double opacity = visible ? (double)faultBundle.getMyOpacity() : 0.0;
        int totNumTuples = (int)this.colorArray.GetNumberOfTuples();
        for (int index = firstIndex; index <= lastIndex; ++index) {
            Preconditions.checkState((index < totNumTuples ? 1 : 0) != 0, (String)"Bad tuple index. index=%s, num tuples=%s", (int)index, (int)totNumTuples);
            double[] orig = this.colorArray.GetTuple4((long)index);
            this.colorArray.SetTuple4((long)index, orig[0], orig[1], orig[2], opacity);
            if (visible) {
                this.actor.registerPointID(index, faultBundle.getFault());
                continue;
            }
            this.actor.unregisterPointID(index);
        }
        this.modified();
    }

    public boolean areAnyPointVisible() {
        return this.actor.getNumRegisteredPoints() > 0;
    }

    public void modified() {
        if (this.actor != null) {
            this.actor.Modified();
        }
        if (this.dataSet != null) {
            this.dataSet.Modified();
        }
        if (this.points != null) {
            this.points.Modified();
        }
        if (this.colorArray != null) {
            this.colorArray.Modified();
        }
        if (this.cellArray != null) {
            this.cellArray.Modified();
        }
    }
}

