/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.surfaces;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.Container2DImpl;
import org.opensha.commons.data.Named;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.surfaces.FaultActorBundle;
import org.scec.vtk.commons.opensha.surfaces.FaultActorBundler;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionActorList;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionBundledActorList;
import org.scec.vtk.commons.opensha.surfaces.GenericFaultActorBundler;
import org.scec.vtk.commons.opensha.surfaces.events.GeometrySettingsChangeListener;
import org.scec.vtk.commons.opensha.surfaces.events.GeometrySettingsChangedEvent;
import org.scec.vtk.tools.Transform;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import org.scec.vtk.tools.picking.PointPickEnabledActor;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkDataSet;
import vtk.vtkLine;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkUnsignedCharArray;

public abstract class GeometryGenerator
implements Named {
    private String name;
    private PickHandler<AbstractFaultSection> pickHandler;
    private List<GeometrySettingsChangeListener> listeners = new ArrayList<GeometrySettingsChangeListener>();
    protected FaultActorBundler bundler = new GenericFaultActorBundler(0);
    private boolean bundlerEnabled = true;

    public GeometryGenerator(String name) {
        this.name = name;
    }

    public abstract FaultSectionActorList createFaultActors(Surface3D var1, Color var2, AbstractFaultSection var3);

    protected FaultSectionActorList handleCompound(CompoundSurface surface, Color color, AbstractFaultSection fault) {
        FaultSectionActorList list = new FaultSectionActorList(fault);
        for (RuptureSurface subSurf : surface.getSurfaceList()) {
            FaultSectionActorList sub = subSurf instanceof EvenlyGriddedSurface ? this.createFaultActors((Surface3D)((EvenlyGriddedSurface)subSurf), color, fault) : this.createFaultActors((Surface3D)subSurf, color, fault);
            list.addAll(sub);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateColor(FaultSectionActorList actorList, Color color) {
        if (actorList instanceof FaultSectionBundledActorList) {
            FaultActorBundle bundle;
            FaultSectionBundledActorList bundleList = (FaultSectionBundledActorList)actorList;
            FaultActorBundle faultActorBundle = bundle = bundleList.getBundle();
            synchronized (faultActorBundle) {
                vtkUnsignedCharArray colors = bundle.getColorArray();
                int firstIndex = bundleList.getMyFirstPointIndex();
                int lastIndex = firstIndex + bundleList.getMyNumPointsForColoring() - 1;
                int totNumTuples = (int)colors.GetNumberOfTuples();
                for (int index = firstIndex; index <= lastIndex; ++index) {
                    Preconditions.checkState((index < totNumTuples ? 1 : 0) != 0, (String)"Bad tuple index. index=%s, num tuples=%s", (int)index, (int)totNumTuples);
                    double[] orig = colors.GetTuple4((long)index);
                    colors.SetTuple4((long)index, (double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), orig[3]);
                }
                colors.Modified();
                bundle.getActor().Modified();
                bundle.modified();
                if (bundle.getActor().GetVisibility() > 0) {
                    bundle.getActor().VisibilityOff();
                    bundle.getActor().VisibilityOn();
                }
            }
            return true;
        }
        for (vtkActor actor : actorList) {
            actor.GetProperty().SetColor(GeometryGenerator.getColorDoubleArray(color));
            actor.Modified();
        }
        return true;
    }

    public static double[] getColorDoubleArray(Color color) {
        return new double[]{(double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0};
    }

    public abstract ParameterList getDisplayParams();

    public void addPlotSettingsChangeListener(GeometrySettingsChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removePlotSettingsChangeListener(GeometrySettingsChangeListener listener) {
        return this.listeners.remove(listener);
    }

    protected void firePlotSettingsChangeEvent() {
        this.clearBundles();
        GeometrySettingsChangedEvent e = new GeometrySettingsChangedEvent(this);
        for (GeometrySettingsChangeListener l : this.listeners) {
            l.geometrySettingsChanged(e);
        }
    }

    public static double[] getPointForLoc(Location loc) {
        return Transform.transformLatLonHeight(loc.getLatitude(), loc.getLongitude(), -loc.getDepth());
    }

    protected static Container2DImpl<double[]> cacheSurfacePoints(EvenlyGriddedSurface surface) {
        Container2DImpl points = new Container2DImpl(surface.getNumRows(), surface.getNumCols());
        for (int row = 0; row < surface.getNumRows(); ++row) {
            for (int col = 0; col < surface.getNumCols(); ++col) {
                points.set(row, col, (Object)GeometryGenerator.getPointForLoc((Location)surface.get(row, col)));
            }
        }
        return points;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void setFaultActorBundler(FaultActorBundler bundler) {
        this.bundler = bundler;
    }

    public FaultActorBundler getFaultActorBundler() {
        return this.bundler;
    }

    public boolean isBundlerEnabled() {
        return this.bundlerEnabled;
    }

    public void setBundlerEneabled(boolean bundlerEnabled) {
        boolean rebuild = bundlerEnabled != this.bundlerEnabled;
        this.bundlerEnabled = bundlerEnabled;
        if (rebuild) {
            this.clearBundles();
            this.firePlotSettingsChangeEvent();
        }
    }

    public void clearBundles() {
        if (this.bundler != null) {
            this.bundler.clearBundles();
        }
    }

    public void setPickHandler(PickHandler<AbstractFaultSection> pickHandler) {
        this.pickHandler = pickHandler;
    }

    public PickHandler<AbstractFaultSection> getPickHandler() {
        return this.pickHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FaultSectionActorList createFaultActors(GeometryType type, List<PointArray> cellDatas, Color color, double opacity, AbstractFaultSection fault) {
        FaultSectionActorList list;
        int firstIndex;
        PickEnabledActor actor;
        vtkCellArray cells;
        vtkUnsignedCharArray colors;
        vtkPoints pts;
        vtkPolyData polyData;
        int myOpacity = (int)(255.0 * opacity);
        FaultActorBundle currentBundle = this.bundler != null && this.bundlerEnabled && fault != null ? this.bundler.getBundle(fault) : null;
        boolean bundle = currentBundle != null;
        boolean newBundle = currentBundle == null || !currentBundle.isInitialized();
        Object synchOn = this;
        if (newBundle) {
            polyData = new vtkPolyData();
            pts = new vtkPoints();
            if (bundle) {
                colors = new vtkUnsignedCharArray();
                colors.SetNumberOfComponents(4);
                colors.SetName("Colors");
            } else {
                colors = null;
            }
            cells = new vtkCellArray();
            if (bundle) {
                PointPickEnabledActor<AbstractFaultSection> myActor;
                actor = myActor = new PointPickEnabledActor<AbstractFaultSection>(this.getPickHandler());
                currentBundle.initialize(myActor, (vtkDataSet)polyData, pts, colors, cells);
                synchOn = currentBundle;
            } else {
                actor = fault == null ? new PointPickEnabledActor<AbstractFaultSection>() : new PickEnabledActor<AbstractFaultSection>(this.getPickHandler(), fault);
            }
        } else {
            polyData = currentBundle.getPolyData();
            pts = currentBundle.getPoints();
            colors = currentBundle.getColorArray();
            Preconditions.checkState((colors.GetNumberOfComponents() == 4 ? 1 : 0) != 0);
            cells = currentBundle.getCellArray();
            actor = currentBundle.getActor();
        }
        GeometryGenerator geometryGenerator = synchOn;
        synchronized (geometryGenerator) {
            firstIndex = (int)pts.GetNumberOfPoints();
            PointOrganizer organizer = new PointOrganizer(pts, colors, color);
            block11: for (PointArray cell : cellDatas) {
                switch (type.ordinal()) {
                    case 0: {
                        vtkLine line = new vtkLine();
                        for (int i = 0; i < cell.size(); ++i) {
                            line.GetPointIds().SetId((long)i, (long)organizer.getIndex(cell.get(i)));
                        }
                        cells.InsertNextCell((vtkCell)line);
                        continue block11;
                    }
                    case 1: {
                        vtkLine polygon = new vtkLine();
                        int size = cell.size();
                        boolean closed = Arrays.equals(cell.get(0), cell.get(size - 1));
                        if (closed) {
                            --size;
                        }
                        Preconditions.checkState((size >= 3 ? 1 : 0) != 0);
                        polygon.GetPointIds().SetNumberOfIds((long)size);
                        for (int i = 0; i < size; ++i) {
                            polygon.GetPointIds().SetId((long)i, (long)organizer.getIndex(cell.get(i)));
                        }
                        cells.InsertNextCell((vtkCell)polygon);
                        continue block11;
                    }
                }
                throw new IllegalStateException("Unknkown GeometryType");
            }
            if (newBundle) {
                polyData.SetPoints(pts);
                switch (type.ordinal()) {
                    case 0: {
                        polyData.SetLines(cells);
                        break;
                    }
                    case 1: {
                        polyData.SetPolys(cells);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknkown GeometryType");
                    }
                }
                if (bundle) {
                    polyData.GetPointData().AddArray((vtkAbstractArray)colors);
                }
                vtkPolyDataMapper mapper = new vtkPolyDataMapper();
                mapper.SetInputData(polyData);
                if (bundle) {
                    mapper.ScalarVisibilityOn();
                    mapper.SetScalarModeToUsePointFieldData();
                    mapper.SelectColorArray("Colors");
                }
                actor.SetMapper((vtkMapper)mapper);
                this.setActorProperties(actor, bundle, color, opacity);
            } else if (currentBundle != null) {
                currentBundle.modified();
            }
        }
        if (bundle) {
            Preconditions.checkState((pts.GetNumberOfPoints() == colors.GetNumberOfTuples() ? 1 : 0) != 0);
            list = new FaultSectionBundledActorList(fault, currentBundle, firstIndex, (int)(pts.GetNumberOfPoints() - (long)firstIndex), myOpacity);
        } else {
            list = new FaultSectionActorList(fault);
            list.add(actor);
        }
        return list;
    }

    protected void setActorProperties(vtkActor actor, boolean bundle, Color color, double opacity) {
        if (!bundle) {
            actor.GetProperty().SetColor(GeometryGenerator.getColorDoubleArray(color));
            actor.GetProperty().SetOpacity(opacity);
        }
    }

    public static class PointOrganizer {
        private vtkPoints points;
        private vtkUnsignedCharArray colorsArray;
        private Map<double[], Integer> pointsIndexMap;
        double r;
        double g;
        double b;
        double a;

        public PointOrganizer(vtkPoints points, vtkUnsignedCharArray colorsArray, Color color) {
            this.points = points;
            this.colorsArray = colorsArray;
            this.pointsIndexMap = Maps.newHashMap();
            if (colorsArray != null) {
                this.r = color.getRed();
                this.g = color.getGreen();
                this.b = color.getBlue();
                this.a = 0.0;
            }
        }

        public int getIndex(double[] point) {
            Integer index = this.pointsIndexMap.get(point);
            if (index == null) {
                index = (int)this.points.GetNumberOfPoints();
                this.points.InsertNextPoint(point);
                if (this.colorsArray != null) {
                    this.colorsArray.InsertNextTuple4(this.r, this.g, this.b, this.a);
                }
                this.pointsIndexMap.put(point, index);
            }
            return index;
        }
    }

    public static class PointArray {
        private double[][] points;

        public PointArray(double[] ... points) {
            this.points = points;
        }

        public int size() {
            return this.points.length;
        }

        public double[][] get() {
            return this.points;
        }

        public double[] get(int index) {
            return this.points[index];
        }
    }

    public static enum GeometryType {
        LINE,
        POLYGON;

    }
}

