/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.surfaces;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.opensha.commons.data.Container2DImpl;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionActorList;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.commons.opensha.surfaces.params.DiscreteSizeParam;
import vtk.vtkActor;

public class LineSurfaceGenerator
extends GeometryGenerator
implements ParameterChangeListener {
    public static final String NAME = "Lines";
    private ParameterList faultDisplayParams;
    private static final String LINE_SIZE_PARAM_NAME = "Line Size";
    private DiscreteSizeParam lineSizeParam = new DiscreteSizeParam("Line Size", 1.0, 10.0, 1.0);
    public static final String OPACITY_PARAM_NAME = "Line Opacity";
    private static final double OPACITY_DEFAULT = 1.0;
    private static final double OPACITY_MIN = 0.0;
    private static final double OPACITY_MAX = 1.0;
    private DoubleParameter opacityParam;
    private static final String SURFACE_TYPE_PARAM_NAME = "Surface Type";
    private static final SurfaceType SURFACE_TYPE_DEFAULT = SurfaceType.SOLID;
    private EnumParameter<SurfaceType> surfaceTypeParam;

    public LineSurfaceGenerator() {
        super(NAME);
        this.faultDisplayParams = new ParameterList();
        this.surfaceTypeParam = new EnumParameter(SURFACE_TYPE_PARAM_NAME, EnumSet.allOf(SurfaceType.class), (Enum)SURFACE_TYPE_DEFAULT, null);
        this.faultDisplayParams.addParameter(this.surfaceTypeParam);
        this.surfaceTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.faultDisplayParams.addParameter((Parameter)this.lineSizeParam);
        this.lineSizeParam.addParameterChangeListener(this);
        this.opacityParam = new DoubleParameter(OPACITY_PARAM_NAME, 0.0, 1.0);
        this.opacityParam.setDefaultValue((Object)1.0);
        this.opacityParam.setValue(1.0);
        this.faultDisplayParams.addParameter((Parameter)this.opacityParam);
        this.opacityParam.addParameterChangeListener((ParameterChangeListener)this);
    }

    public void setOpacity(double opacity) {
        this.opacityParam.setValue(opacity);
    }

    @Override
    public FaultSectionActorList createFaultActors(Surface3D surface, Color color, AbstractFaultSection fault) {
        if (surface instanceof CompoundSurface) {
            return this.handleCompound((CompoundSurface)surface, color, fault);
        }
        if (surface instanceof EvenlyGriddedSurface) {
            return this.createFaultActors((EvenlyGriddedSurface)surface, color, fault);
        }
        LocationList outline = surface.getPerimeter();
        return this.createFaultActors(outline, color, fault);
    }

    public FaultSectionActorList createFaultActors(LocationList outline, Color color, AbstractFaultSection fault) {
        Preconditions.checkState((!outline.isEmpty() ? 1 : 0) != 0);
        ArrayList<GeometryGenerator.PointArray> points = new ArrayList<GeometryGenerator.PointArray>();
        for (int i = 0; i < outline.size(); ++i) {
            double[] pt1 = LineSurfaceGenerator.getPointForLoc((Location)outline.get(i));
            double[] pt2 = i + 1 == outline.size() ? ((GeometryGenerator.PointArray)points.get(0)).get(0) : LineSurfaceGenerator.getPointForLoc((Location)outline.get(i + 1));
            points.add(new GeometryGenerator.PointArray(pt1, pt2));
        }
        return this.createFaultActors(points, color, fault);
    }

    public FaultSectionActorList createFaultActors(EvenlyGriddedSurface surface, Color color, AbstractFaultSection fault) {
        int cols = surface.getNumCols();
        int rows = surface.getNumRows();
        SurfaceType surfaceType = (SurfaceType)((Object)this.surfaceTypeParam.getValue());
        boolean outlineOnly = surfaceType == SurfaceType.OUTLINE_ONLY;
        boolean traceOnly = surfaceType == SurfaceType.TRACE_ONLY;
        ArrayList<GeometryGenerator.PointArray> points = new ArrayList<GeometryGenerator.PointArray>();
        Container2DImpl<double[]> pointSurface = LineSurfaceGenerator.cacheSurfacePoints(surface);
        int lastLoopCol = cols - 2;
        int lastLoopRow = rows - 2;
        if (rows == 0) {
            return null;
        }
        if (rows == 1) {
            for (int col = 0; col < pointSurface.getNumCols() - 1; ++col) {
                points.add(new GeometryGenerator.PointArray((double[])pointSurface.get(0, col), (double[])pointSurface.get(0, col + 1)));
            }
        } else {
            for (int row = 0; !(row > lastLoopRow || traceOnly && row > 0); ++row) {
                for (int col = 0; col <= lastLoopCol; ++col) {
                    if (outlineOnly && row != 0 && row != lastLoopRow && col != 0 && col != lastLoopCol) continue;
                    double[] pt0 = (double[])pointSurface.get(row, col);
                    double[] pt1 = (double[])pointSurface.get(row + 1, col);
                    double[] pt2 = (double[])pointSurface.get(row + 1, col + 1);
                    double[] pt3 = (double[])pointSurface.get(row, col + 1);
                    if (!(traceOnly || outlineOnly && col != 0)) {
                        points.add(new GeometryGenerator.PointArray(pt0, pt1));
                    }
                    if (!(traceOnly || outlineOnly && row != lastLoopRow)) {
                        points.add(new GeometryGenerator.PointArray(pt1, pt2));
                    }
                    if (!(traceOnly || outlineOnly && col != lastLoopCol)) {
                        points.add(new GeometryGenerator.PointArray(pt2, pt3));
                    }
                    if (row != 0 && outlineOnly && (col != 0 || row != 0)) continue;
                    points.add(new GeometryGenerator.PointArray(pt3, pt0));
                }
            }
        }
        return this.createFaultActors(points, color, fault);
    }

    private synchronized FaultSectionActorList createFaultActors(List<GeometryGenerator.PointArray> points, Color color, AbstractFaultSection fault) {
        return this.createFaultActors(GeometryGenerator.GeometryType.LINE, points, color, (Double)this.opacityParam.getValue(), fault);
    }

    @Override
    protected void setActorProperties(vtkActor actor, boolean bundle, Color color, double opacity) {
        super.setActorProperties(actor, bundle, color, opacity);
        actor.GetProperty().SetLineWidth(((Double)this.lineSizeParam.getValue()).floatValue());
    }

    public void setSize(double size) {
        this.lineSizeParam.setValue(size);
    }

    @Override
    public ParameterList getDisplayParams() {
        return this.faultDisplayParams;
    }

    public void parameterChange(ParameterChangeEvent event) {
        super.firePlotSettingsChangeEvent();
    }

    private static enum SurfaceType {
        SOLID("All Lines"),
        OUTLINE_ONLY("Outline Only"),
        TRACE_ONLY("Trace Only");

        private String name;

        private SurfaceType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

