/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.commons.opensha.surfaces;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.Surface3D;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.surfaces.FaultActorBundle;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionActorList;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionBundledActorList;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.commons.opensha.surfaces.params.ColorParameter;
import org.scec.vtk.commons.opensha.surfaces.params.DiscreteSizeParam;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PointPickEnabledActor;
import vtk.vtkAbstractArray;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkUnsignedCharArray;
import vtk.vtkUnstructuredGrid;
import vtk.vtkVertex;

public class PointSurfaceGenerator
extends GeometryGenerator
implements ParameterChangeListener {
    private static final String NAME = "Points";
    private ParameterList faultDisplayParams;
    private static final String OUTLINE_COLOR_PARAM_NAME = "Outline Color";
    private ColorParameter outlineColorParam = new ColorParameter("Outline Color", Color.WHITE);
    public static final String POINT_SIZE_PARAM_NAME = "Point Size";
    private DiscreteSizeParam pointSizeParam = new DiscreteSizeParam("Point Size", 1.0, 10.0, 1.0);
    private static final String SURFACE_TYPE_PARAM_NAME = "Surface Type";
    private static final SurfaceType SURFACE_TYPE_DEFAULT = SurfaceType.SOLID;
    private EnumParameter<SurfaceType> surfaceTypeParam;

    public PointSurfaceGenerator() {
        super(NAME);
        this.faultDisplayParams = new ParameterList();
        this.surfaceTypeParam = new EnumParameter(SURFACE_TYPE_PARAM_NAME, EnumSet.allOf(SurfaceType.class), (Enum)SURFACE_TYPE_DEFAULT, null);
        this.faultDisplayParams.addParameter(this.surfaceTypeParam);
        this.surfaceTypeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.faultDisplayParams.addParameter((Parameter)this.outlineColorParam);
        this.outlineColorParam.addParameterChangeListener(this);
        this.faultDisplayParams.addParameter((Parameter)this.pointSizeParam);
        this.pointSizeParam.addParameterChangeListener(this);
        this.enableForSurfaceType();
    }

    private boolean shouldUseOutlineColor() {
        return this.surfaceTypeParam.getValue() == SurfaceType.SOLID_WITH_OUTLINE;
    }

    private void enableForSurfaceType() {
        this.outlineColorParam.getEditor().setEnabled(this.shouldUseOutlineColor());
    }

    private boolean isSolid() {
        return this.surfaceTypeParam.getValue() == SurfaceType.SOLID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FaultSectionActorList createFaultActors(Surface3D surface, Color color, AbstractFaultSection fault) {
        FaultSectionActorList list;
        int firstIndex;
        PickEnabledActor actor;
        vtkUnsignedCharArray colors;
        vtkPoints pts;
        vtkUnstructuredGrid gridData;
        FaultActorBundle currentBundle;
        double initialOpacity;
        if (surface instanceof CompoundSurface) {
            return this.handleCompound((CompoundSurface)surface, color, fault);
        }
        if (surface instanceof EvenlyGriddedSurface) {
            return this.createFaultActors((EvenlyGriddedSurface)surface, color, fault);
        }
        ArrayList<double[]> points = new ArrayList<double[]>();
        ListIterator it = surface.getLocationsIterator();
        while (it.hasNext()) {
            Location loc = (Location)it.next();
            points.add(PointSurfaceGenerator.getPointForLoc(loc));
        }
        Preconditions.checkState((!points.isEmpty() ? 1 : 0) != 0, (Object)"NumSurfacePoints must be >0");
        if (this.isBundlerEnabled() && this.bundler != null) {
            initialOpacity = 0.0;
            currentBundle = this.bundler.getBundle(fault);
        } else {
            initialOpacity = 255.0;
            currentBundle = null;
        }
        boolean bundle = this.isBundlerEnabled() && currentBundle != null;
        boolean newBundle = currentBundle == null || !currentBundle.isInitialized();
        Object synchOn = this;
        if (newBundle) {
            gridData = new vtkUnstructuredGrid();
            pts = new vtkPoints();
            if (bundle) {
                colors = new vtkUnsignedCharArray();
                colors.SetNumberOfComponents(4);
                colors.SetName("Colors");
            } else {
                colors = null;
            }
            if (bundle) {
                PointPickEnabledActor<AbstractFaultSection> myActor = new PointPickEnabledActor<AbstractFaultSection>(this.getPickHandler());
                actor = myActor;
                currentBundle.initialize(myActor, (vtkDataSet)gridData, pts, colors, null);
                synchOn = currentBundle;
            } else {
                actor = new PickEnabledActor<AbstractFaultSection>(this.getPickHandler(), fault);
            }
        } else {
            gridData = (vtkUnstructuredGrid)currentBundle.getVtkDataSet();
            pts = currentBundle.getPoints();
            colors = currentBundle.getColorArray();
            Preconditions.checkState((colors.GetNumberOfComponents() == 4 ? 1 : 0) != 0);
            actor = currentBundle.getActor();
        }
        PointSurfaceGenerator pointSurfaceGenerator = synchOn;
        synchronized (pointSurfaceGenerator) {
            firstIndex = (int)pts.GetNumberOfPoints();
            for (double[] point : points) {
                pts.InsertNextPoint(point);
                if (!bundle) continue;
                colors.InsertNextTuple4((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), initialOpacity);
            }
            int i = firstIndex;
            while ((long)i < pts.GetNumberOfPoints()) {
                vtkVertex vertex = new vtkVertex();
                vertex.GetPointIds().SetId(0L, (long)i);
                gridData.InsertNextCell(vertex.GetCellType(), vertex.GetPointIds());
                ++i;
            }
            if (newBundle) {
                gridData.SetPoints(pts);
                if (bundle) {
                    gridData.GetPointData().AddArray((vtkAbstractArray)colors);
                }
                vtkDataSetMapper mapper = new vtkDataSetMapper();
                mapper.SetInputData((vtkDataSet)gridData);
                if (bundle) {
                    mapper.ScalarVisibilityOn();
                    mapper.SetScalarModeToUsePointFieldData();
                    mapper.SelectColorArray("Colors");
                }
                actor.SetMapper((vtkMapper)mapper);
                actor.GetProperty().SetPointSize(((Double)this.pointSizeParam.getValue()).floatValue());
                this.setActorProperties(actor, bundle, color, 1.0);
            } else if (currentBundle != null) {
                currentBundle.modified();
            }
        }
        if (bundle) {
            Preconditions.checkState((pts.GetNumberOfPoints() == colors.GetNumberOfTuples() ? 1 : 0) != 0);
            int totNumPoints = (int)(pts.GetNumberOfPoints() - (long)firstIndex);
            list = new FaultSectionBundledActorList(fault, currentBundle, firstIndex, totNumPoints, totNumPoints, 255);
        } else {
            list = new FaultSectionActorList(fault);
            list.add(actor);
        }
        return list;
    }

    private List<double[]> getPointsForLocs(LocationList locs, LocationList excludeLocs) {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        HashSet excludes = excludeLocs == null ? null : new HashSet(excludeLocs);
        for (Location loc : locs) {
            if (excludes != null && excludes.contains(loc)) continue;
            pts.add(PointSurfaceGenerator.getPointForLoc(loc));
        }
        return pts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FaultSectionActorList createFaultActors(EvenlyGriddedSurface surface, Color color, AbstractFaultSection fault) {
        FaultSectionActorList list;
        int firstIndex;
        PickEnabledActor actor;
        vtkUnsignedCharArray colors;
        vtkPoints pts;
        vtkUnstructuredGrid gridData;
        FaultActorBundle currentBundle;
        double initialOpacity;
        int numSurfacePoints = (int)surface.size();
        Preconditions.checkState((numSurfacePoints > 0 ? 1 : 0) != 0, (Object)"NumSurfacePoints must be >0");
        double[][] points = new double[numSurfacePoints][];
        int cnt = 0;
        ListIterator it = surface.getLocationsIterator();
        while (it.hasNext()) {
            Location loc = (Location)it.next();
            points[cnt++] = PointSurfaceGenerator.getPointForLoc(loc);
        }
        ArrayList center = null;
        ArrayList top = null;
        ArrayList bottom = null;
        ArrayList left = null;
        ArrayList right = null;
        int rows = surface.getNumRows();
        int cols = surface.getNumCols();
        SurfaceType surfaceType = (SurfaceType)((Object)this.surfaceTypeParam.getValue());
        boolean solid = this.isSolid();
        boolean drawCenter = solid || surfaceType == SurfaceType.SOLID_WITH_OUTLINE;
        boolean drawSideBottoms = surfaceType == SurfaceType.SOLID_WITH_OUTLINE || surfaceType == SurfaceType.OUTLINE_ONLY;
        cnt = 0;
        int n = points.length;
        if (drawCenter) {
            center = Lists.newArrayList();
        }
        if (!solid) {
            top = Lists.newArrayList();
        }
        if (drawSideBottoms) {
            left = Lists.newArrayList();
            bottom = Lists.newArrayList();
            right = Lists.newArrayList();
        }
        while (cnt < n) {
            if (!solid) {
                if (cnt < cols) {
                    top.add(points[cnt]);
                    ++cnt;
                    continue;
                }
                if (cnt % cols == 0) {
                    if (drawSideBottoms) {
                        right.add(points[cnt]);
                    }
                    ++cnt;
                    continue;
                }
                if ((cnt + 1) % cols == 0) {
                    if (drawSideBottoms) {
                        left.add(points[cnt]);
                    }
                    ++cnt;
                    continue;
                }
                if (cnt > n - cols && bottom != null) {
                    if (drawSideBottoms) {
                        bottom.add(points[cnt]);
                    }
                    ++cnt;
                    continue;
                }
            }
            if (drawCenter && center != null) {
                center.add(points[cnt]);
            }
            ++cnt;
        }
        if (this.isBundlerEnabled() && this.bundler != null) {
            initialOpacity = 0.0;
            currentBundle = this.bundler.getBundle(fault);
        } else {
            initialOpacity = 255.0;
            currentBundle = null;
        }
        boolean bundle = this.isBundlerEnabled() && currentBundle != null;
        boolean newBundle = currentBundle == null || !currentBundle.isInitialized();
        Object synchOn = this;
        if (newBundle) {
            gridData = new vtkUnstructuredGrid();
            pts = new vtkPoints();
            if (bundle) {
                colors = new vtkUnsignedCharArray();
                colors.SetNumberOfComponents(4);
                colors.SetName("Colors");
            } else {
                colors = null;
            }
            if (bundle) {
                PointPickEnabledActor<AbstractFaultSection> myActor = new PointPickEnabledActor<AbstractFaultSection>(this.getPickHandler());
                actor = myActor;
                currentBundle.initialize(myActor, (vtkDataSet)gridData, pts, colors, null);
                synchOn = currentBundle;
            } else {
                actor = new PickEnabledActor<AbstractFaultSection>(this.getPickHandler(), fault);
            }
        } else {
            gridData = (vtkUnstructuredGrid)currentBundle.getVtkDataSet();
            pts = currentBundle.getPoints();
            colors = currentBundle.getColorArray();
            Preconditions.checkState((colors.GetNumberOfComponents() == 4 ? 1 : 0) != 0);
            actor = currentBundle.getActor();
        }
        ArrayList outlinePoints = null;
        if (!solid) {
            outlinePoints = new ArrayList();
            outlinePoints.addAll(top);
            if (drawSideBottoms) {
                outlinePoints.addAll(left);
                outlinePoints.addAll(bottom);
                outlinePoints.addAll(right);
            }
        }
        int numMainColor = 0;
        PointSurfaceGenerator pointSurfaceGenerator = synchOn;
        synchronized (pointSurfaceGenerator) {
            firstIndex = (int)pts.GetNumberOfPoints();
            if (drawCenter) {
                for (Object point : center) {
                    pts.InsertNextPoint((double[])point);
                    ++numMainColor;
                    if (!bundle) continue;
                    colors.InsertNextTuple4((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), initialOpacity);
                }
                if (!solid) {
                    Object point;
                    Color outlineColor = (Color)this.outlineColorParam.getValue();
                    point = outlinePoints.iterator();
                    while (point.hasNext()) {
                        double[] point2 = (double[])point.next();
                        pts.InsertNextPoint(point2);
                        if (!bundle) continue;
                        colors.InsertNextTuple4((double)outlineColor.getRed(), (double)outlineColor.getGreen(), (double)outlineColor.getBlue(), initialOpacity);
                    }
                }
            } else {
                for (Object point : outlinePoints) {
                    pts.InsertNextPoint((double[])point);
                    ++numMainColor;
                    if (!bundle) continue;
                    colors.InsertNextTuple4((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), initialOpacity);
                }
            }
            int i = firstIndex;
            while ((long)i < pts.GetNumberOfPoints()) {
                vtkVertex vertex = new vtkVertex();
                vertex.GetPointIds().SetId(0L, (long)i);
                gridData.InsertNextCell(vertex.GetCellType(), vertex.GetPointIds());
                ++i;
            }
            if (newBundle) {
                gridData.SetPoints(pts);
                if (bundle) {
                    gridData.GetPointData().AddArray((vtkAbstractArray)colors);
                }
                vtkDataSetMapper mapper = new vtkDataSetMapper();
                mapper.SetInputData((vtkDataSet)gridData);
                if (bundle) {
                    mapper.ScalarVisibilityOn();
                    mapper.SetScalarModeToUsePointFieldData();
                    mapper.SelectColorArray("Colors");
                }
                actor.SetMapper((vtkMapper)mapper);
                actor.GetProperty().SetPointSize(((Double)this.pointSizeParam.getValue()).floatValue());
                this.setActorProperties(actor, bundle, color, 1.0);
            } else if (currentBundle != null) {
                currentBundle.modified();
            }
        }
        if (bundle) {
            Preconditions.checkState((pts.GetNumberOfPoints() == colors.GetNumberOfTuples() ? 1 : 0) != 0);
            int totNumPoints = (int)(pts.GetNumberOfPoints() - (long)firstIndex);
            list = new FaultSectionBundledActorList(fault, currentBundle, firstIndex, totNumPoints, numMainColor, 255);
        } else {
            list = new FaultSectionActorList(fault);
            list.add(actor);
        }
        return list;
    }

    @Override
    public ParameterList getDisplayParams() {
        return this.faultDisplayParams;
    }

    public void parameterChange(ParameterChangeEvent event) {
        if (event.getSource() == this.surfaceTypeParam) {
            this.enableForSurfaceType();
        }
        super.firePlotSettingsChangeEvent();
    }

    private static enum SurfaceType {
        SOLID("Solid"),
        SOLID_WITH_OUTLINE("Solid w/ Outline"),
        OUTLINE_ONLY("Outline Only"),
        TRACE_ONLY("Trace Only");

        private String name;

        private SurfaceType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

